/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.wizards;

import java.util.ArrayList;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewInterfaceCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewInterfaceCreationWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.workbench.condition.EditorWithTitleIsActive;
import org.eclipse.reddeer.workbench.handler.EditorHandler;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class NewInterfaceCreationWizardTest {
    protected static final String PROJECT_NAME = "testproject";
    protected static final String INTERFACE_NAME = "InterfaceName";
    protected static final String SOURCE_FOLDER_NAME = "testproject/src";
    protected static final String PACKAGE_NAME = "org.example.test";
    protected static final String ENCLOSING_TYPE_CUSTOM_VALUE = "org.example.test.InterfaceName";

    @BeforeClass
    public static void setup() {
        NewInterfaceCreationWizardTest.createTestProject();
    }

    @After
    public void closeAllEditors() {
        EditorHandler.getInstance().closeAll(true);
    }

    @AfterClass
    public static void clean() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        pe.deleteAllProjects(true, TimePeriod.LONG);
    }

    @Test
    public void testCreateNewInterface() {
        NewInterfaceCreationWizard interfaceDialog = new NewInterfaceCreationWizard();
        interfaceDialog.open();
        NewInterfaceCreationWizardPage interfacePage = new NewInterfaceCreationWizardPage((ReferencedComposite)interfaceDialog);
        interfacePage.setPackage(PACKAGE_NAME).setName(INTERFACE_NAME);
        interfaceDialog.finish();
        new WaitUntil((WaitCondition)new EditorWithTitleIsActive("InterfaceName.java"), TimePeriod.LONG);
        TextEditor te = new TextEditor("InterfaceName.java");
        Assert.assertTrue((String)"Interface source file should contain String 'package org.example.test'", (te.getPositionOfText("package org.example.test", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Interface source file should contain String 'public interface InterfaceName'", (te.getPositionOfText("public interface InterfaceName", 0) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateNewInterfaceWithCustomSettings() {
        NewInterfaceCreationWizard interfaceDialog = new NewInterfaceCreationWizard();
        interfaceDialog.open();
        NewInterfaceCreationWizardPage interfacePage = new NewInterfaceCreationWizardPage((ReferencedComposite)interfaceDialog);
        interfacePage.setPackage("org.example.test2").setName("InterfaceName2");
        interfacePage.setPackageModifier();
        interfacePage.addExtendedInterface("javax.accessibility.AccessibleAction");
        interfacePage.toggleGenerateCommentsCheckbox(true);
        interfaceDialog.finish();
        new WaitUntil((WaitCondition)new EditorWithTitleIsActive("InterfaceName2.java"), TimePeriod.LONG);
        TextEditor te = new TextEditor("InterfaceName2.java");
        Assert.assertTrue((String)"Interface source file should contain String 'package org.example.test2'", (te.getPositionOfText("package org.example.test2", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Interface source file should contain String '\ninterface InterfaceName2 extends AccessibleAction'", (te.getPositionOfText("\ninterface InterfaceName2 extends AccessibleAction", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Interface source file should contain String 'import javax.accessibility.AccessibleAction;'", (te.getPositionOfText("import javax.accessibility.AccessibleAction;", 0) >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Interface source file should contain String '/**\n *'", (te.getPositionOfText("/**\n *", 0) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSettingAndGettingInputAndCheckboxValues() {
        NewInterfaceCreationWizard interfaceDialog = new NewInterfaceCreationWizard();
        interfaceDialog.open();
        NewInterfaceCreationWizardPage interfacePage = new NewInterfaceCreationWizardPage((ReferencedComposite)interfaceDialog);
        interfacePage.setSourceFolder(SOURCE_FOLDER_NAME).setPackage(PACKAGE_NAME).setName(INTERFACE_NAME);
        Assert.assertTrue((String)"Source folder name obtained from the input using getSourceFolder() function is not the same as name set using setSourceFolder().", (boolean)interfacePage.getSourceFolder().equals(SOURCE_FOLDER_NAME));
        Assert.assertTrue((String)"Package name obtained from the input using getPackage() function is not the same as name set using setPackage().", (boolean)interfacePage.getPackage().equals(PACKAGE_NAME));
        Assert.assertTrue((String)"Interface name obtained from the input using getName() function is not the same as name set using setName().", (boolean)interfacePage.getName().equals(INTERFACE_NAME));
        interfacePage.toggleEnclosingTypeCheckbox(true);
        String enclosingTypeDefaultValue = interfacePage.getEnclosingType();
        interfacePage.setEnclosingType(ENCLOSING_TYPE_CUSTOM_VALUE);
        Assert.assertTrue((String)"Interface enclosing type obtained from the wizard using getEnclosingType() is not the same as the type given using setEnclosingType().", (boolean)interfacePage.getEnclosingType().equals(ENCLOSING_TYPE_CUSTOM_VALUE));
        interfacePage.setEnclosingType(enclosingTypeDefaultValue);
        Assert.assertTrue((String)("Currently set modifier should be 'public', but is '" + interfacePage.getCurrentModifier() + "'."), (boolean)interfacePage.setPublicModifier().getCurrentModifier().equals("public"));
        Assert.assertTrue((String)("Currently set modifier should be 'package', but is '" + interfacePage.getCurrentModifier() + "'."), (boolean)interfacePage.setPackageModifier().getCurrentModifier().equals("package"));
        Assert.assertTrue((String)("Currently set modifier should be 'private', but is '" + interfacePage.getCurrentModifier() + "'."), (boolean)interfacePage.setPrivateModifier().getCurrentModifier().equals("private"));
        Assert.assertTrue((String)("Currently set modifier should be 'protected', but is '" + interfacePage.getCurrentModifier() + "'."), (boolean)interfacePage.setProtectedModifier().getCurrentModifier().equals("protected"));
        interfacePage.toggleEnclosingTypeCheckbox(false);
        boolean generateCommentsCheckboxState = interfacePage.getGenerateCommentsCheckboxState();
        interfacePage.toggleGenerateCommentsCheckbox(!generateCommentsCheckboxState);
        Assert.assertTrue((String)("The Generate comments checkbox state should be '" + !generateCommentsCheckboxState + "' but is'" + generateCommentsCheckboxState + " '."), (boolean)(interfacePage.getGenerateCommentsCheckboxState() ^ generateCommentsCheckboxState));
        interfacePage.toggleGenerateCommentsCheckbox(generateCommentsCheckboxState);
        Assert.assertTrue((String)("The Generate comments checkbox state should be '" + generateCommentsCheckboxState + "' but is'" + !generateCommentsCheckboxState + " '."), (interfacePage.getGenerateCommentsCheckboxState() == generateCommentsCheckboxState ? 1 : 0) != 0);
        interfaceDialog.cancel();
    }

    @Test
    public void testAddingAndRemovingExtendedInterfaces() {
        NewInterfaceCreationWizard interfaceDialog = new NewInterfaceCreationWizard();
        interfaceDialog.open();
        NewInterfaceCreationWizardPage interfacePage = new NewInterfaceCreationWizardPage((ReferencedComposite)interfaceDialog);
        ArrayList<String> extendedIterfaceList = new ArrayList<String>();
        extendedIterfaceList.add("javax.accessibility.AccessibleAction");
        extendedIterfaceList.add("javax.accessibility.AccessibleEditableText");
        extendedIterfaceList.add("javax.accessibility.AccessibleExtendedTable");
        extendedIterfaceList.add("javax.accessibility.AccessibleStreamable");
        extendedIterfaceList.add("javax.accessibility.AccessibleText");
        for (String extendedInterfaceName : extendedIterfaceList) {
            interfacePage.addExtendedInterface(extendedInterfaceName);
        }
        Assert.assertTrue((String)"List of interfaces obtained using function getExtendedInterfaces() has to be the same as list interfaces, that has been set.", (boolean)interfacePage.getExtendedInterfaces().equals(extendedIterfaceList));
        for (String extendedInterfaceName : extendedIterfaceList) {
            interfacePage.removeExtendedInterface(extendedInterfaceName);
        }
        interfaceDialog.cancel();
    }

    @Test
    public void testAddingAndRemovingNonexistingAndNotFullySpecifiedInterfaces() {
        NewInterfaceCreationWizard interfaceDialog = new NewInterfaceCreationWizard();
        interfaceDialog.open();
        NewInterfaceCreationWizardPage interfacePage = new NewInterfaceCreationWizardPage((ReferencedComposite)interfaceDialog);
        try {
            interfacePage.addExtendedInterface("nonexisting.interface.name");
            Assert.fail((String)"RedDeer exception was not thrown when trying to add a non-existing extended interface.");
        }
        catch (RedDeerException redDeerException) {
            new PushButton("Cancel").click();
        }
        try {
            interfacePage.addExtendedInterface("Acl");
            Assert.fail((String)"RedDeer exception was not thrown when trying to add an extended interface, that is not fully specified by its name.");
        }
        catch (RedDeerException redDeerException) {
            new PushButton("Cancel").click();
        }
        try {
            interfacePage.removeExtendedInterface("javax.accessibility.AccessibleAction");
            Assert.fail((String)"RedDeer exception was not thrown when trying to remove an extended interface, that is not on the list.");
        }
        catch (RedDeerException redDeerException) {}
        interfacePage.addExtendedInterface("org.w3c.dom.views.AbstractView");
        try {
            interfacePage.removeExtendedInterface("AbstractView");
            Assert.fail((String)"RedDeer exception was not thrown when trying to remove an extended interface, that was added, but was not fully specified.");
        }
        catch (RedDeerException redDeerException) {
            interfacePage.removeExtendedInterface("org.w3c.dom.views.AbstractView");
        }
        interfaceDialog.cancel();
    }

    private static void createTestProject() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        dialog.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)dialog).setProjectName(PROJECT_NAME);
        dialog.finish();
    }
}

