/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.impl.button.CheckBox;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.RadioButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.hamcrest.Matcher;

public class NewInterfaceCreationWizardPage
extends WizardPage {
    public NewInterfaceCreationWizardPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public NewInterfaceCreationWizardPage setName(String name) {
        new LabeledText((ReferencedComposite)this, "Name:").setText(name);
        return this;
    }

    public NewInterfaceCreationWizardPage setPackage(String packageName) {
        new LabeledText((ReferencedComposite)this, "Package:").setText(packageName);
        return this;
    }

    public NewInterfaceCreationWizardPage setSourceFolder(String sourceFolder) {
        new LabeledText((ReferencedComposite)this, "Source folder:").setText(sourceFolder);
        return this;
    }

    public String getPackage() {
        return new LabeledText((ReferencedComposite)this, "Package:").getText();
    }

    public String getName() {
        return new LabeledText((ReferencedComposite)this, "Name:").getText();
    }

    public String getSourceFolder() {
        return new LabeledText((ReferencedComposite)this, "Source folder:").getText();
    }

    public NewInterfaceCreationWizardPage toggleEnclosingTypeCheckbox(boolean toggle) {
        new CheckBox((ReferencedComposite)this, "Enclosing type:").toggle(toggle);
        return this;
    }

    public String getEnclosingType() {
        return new DefaultText(2, new Matcher[0]).getText();
    }

    public NewInterfaceCreationWizardPage setEnclosingType(String enclosingTypeName) {
        new DefaultText(2, new Matcher[0]).setText(enclosingTypeName);
        return this;
    }

    public String getCurrentModifier() {
        if (new RadioButton((ReferencedComposite)this, "public").isSelected()) {
            return "public";
        }
        if (new RadioButton((ReferencedComposite)this, "package").isSelected()) {
            return "package";
        }
        if (new RadioButton((ReferencedComposite)this, "private").isSelected()) {
            return "private";
        }
        if (new RadioButton((ReferencedComposite)this, "protected").isSelected()) {
            return "protected";
        }
        throw new RedDeerException("New Java Interface wizard modifiers property has to be set to 1 of 4 values ('public', 'package', 'private' or 'protected').");
    }

    public NewInterfaceCreationWizardPage setPublicModifier() {
        new RadioButton((ReferencedComposite)this, "public").toggle(true);
        return this;
    }

    public NewInterfaceCreationWizardPage setPackageModifier() {
        new RadioButton((ReferencedComposite)this, "package").toggle(true);
        return this;
    }

    public NewInterfaceCreationWizardPage setPrivateModifier() {
        new RadioButton((ReferencedComposite)this, "private").toggle(true);
        return this;
    }

    public NewInterfaceCreationWizardPage setProtectedModifier() {
        new RadioButton((ReferencedComposite)this, "protected").toggle(true);
        return this;
    }

    public void addExtendedInterface(String interfaceName) {
        new PushButton("Add...").click();
        new DefaultShell("Extended Interfaces Selection");
        new DefaultText(0, new Matcher[0]).setText(interfaceName);
        switch (new DefaultTable(0, new Matcher[0]).getItems().size()) {
            case 0: {
                throw new RedDeerException("No item was found for given interface name '" + interfaceName + "'.");
            }
            case 1: {
                new PushButton("OK").click();
                break;
            }
            default: {
                throw new RedDeerException("More than 1 item was found for given interface name '" + interfaceName + "'.");
            }
        }
    }

    public void removeExtendedInterface(String interfaceName) {
        DefaultTable table = new DefaultTable(0, new Matcher[0]);
        table.getItem(interfaceName).select();
        new PushButton("Remove").click();
    }

    public ArrayList<String> getExtendedInterfaces() {
        DefaultTable table = new DefaultTable(0, new Matcher[0]);
        List tableItems = table.getItems();
        ArrayList<String> tableItemNames = new ArrayList<String>();
        for (TableItem item : tableItems) {
            tableItemNames.add(item.getText());
        }
        return tableItemNames;
    }

    public NewInterfaceCreationWizardPage toggleGenerateCommentsCheckbox(boolean toggle) {
        new CheckBox((ReferencedComposite)this, "Generate comments").toggle(toggle);
        return this;
    }

    public boolean getGenerateCommentsCheckboxState() {
        return new CheckBox((ReferencedComposite)this, "Generate comments").isChecked();
    }
}

