/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.tab;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.impl.tab.DefaultTabFolder;
import org.eclipse.reddeer.swt.impl.tab.DefaultTabItem;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TabFolderTest
extends SWTLayerTestCase {
    private static final String ITEM_LABEL_PREFIX = "Item ";
    private static final String TOOLTIP_PREFIX = "Tool for Item ";
    private static final String CONTENT_PREFIX = "Content for Item ";

    @Override
    protected void createControls(Shell shell) {
        TabFolder folder = new TabFolder((Composite)shell, 2048);
        int i = 0;
        while (i < 4) {
            TabItem item = new TabItem(folder, 0);
            item.setText(ITEM_LABEL_PREFIX + i);
            item.setToolTipText(TOOLTIP_PREFIX + i);
            Text text = new Text((Composite)folder, 2);
            text.setText(CONTENT_PREFIX + i);
            item.setControl((Control)text);
            ++i;
        }
    }

    @Test
    public void findByIndexAndActivate() {
        int index = 2;
        new DefaultTabItem(index, new Matcher[0]).activate();
        String expectedTabItemContent = CONTENT_PREFIX + index;
        String tabItemContent = new DefaultText(0, new Matcher[0]).getText();
        Assert.assertTrue((String)("cTabItem content is " + tabItemContent + "\nbut expected CTabItem content is " + expectedTabItemContent), (boolean)tabItemContent.equals(expectedTabItemContent));
    }

    @Test
    public void findByNameAndActivate() {
        int index = 1;
        new DefaultTabItem(ITEM_LABEL_PREFIX + index).activate();
        String expectedTabItemContent = CONTENT_PREFIX + index;
        String tabItemContent = new DefaultText(0, new Matcher[0]).getText();
        Assert.assertTrue((String)("cTabItem content is " + tabItemContent + "\nbut expected CTabItem content is " + expectedTabItemContent), (boolean)tabItemContent.equals(expectedTabItemContent));
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByIndex() {
        new DefaultTabItem(5, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByLabel() {
        new DefaultTabItem("NON_EXISTING_#$");
    }

    @Test
    public void tabFolderTest() {
        String[] tabItemLabel = new DefaultTabFolder().getTabItemLabels();
        Assert.assertEquals((long)4L, (long)tabItemLabel.length);
        Assert.assertEquals((Object)"Item 0", (Object)tabItemLabel[0]);
        Assert.assertEquals((Object)"Item 1", (Object)tabItemLabel[1]);
        Assert.assertEquals((Object)"Item 2", (Object)tabItemLabel[2]);
        Assert.assertEquals((Object)"Item 3", (Object)tabItemLabel[3]);
    }

    @Test
    public void getSelectedFolderItems() {
        new DefaultTabItem().activate();
        Assert.assertTrue((new DefaultTabFolder().getSelection().size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void getAllFolderItems() {
        Assert.assertTrue((new DefaultTabFolder().getItems().size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void isTabItemSelected() {
        DefaultTabItem tab1 = new DefaultTabItem("Item 0");
        DefaultTabItem tab2 = new DefaultTabItem("Item 1");
        tab2.activate();
        Assert.assertFalse((boolean)tab1.isSelected());
        Assert.assertTrue((boolean)tab2.isSelected());
        tab1.activate();
        Assert.assertTrue((boolean)tab1.isSelected());
        Assert.assertFalse((boolean)tab2.isSelected());
    }
}

