/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTOutlineView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    NSTableHeaderView headerView;
    TreeItem[] items;
    int itemCount;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    int columnCount;
    int sortDirection;
    int selectedRowIndex = -1;
    boolean ignoreExpand;
    boolean ignoreSelect;
    boolean ignoreRedraw;
    boolean reloadPending;
    boolean drawExpansion;
    boolean didSelect;
    boolean preventSelect;
    boolean dragDetected;
    Rectangle imageBounds;
    TreeItem insertItem;
    boolean insertBefore;
    double[] headerBackground;
    double[] headerForeground;
    boolean shouldExpand = true;
    boolean shouldScroll = true;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 17;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    @Override
    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        this.clearCachedWidth(this.items);
    }

    TreeItem _getItem(TreeItem parentItem, int index, boolean create) {
        TreeItem[] items;
        int count;
        if (parentItem != null) {
            count = parentItem.itemCount;
            items = parentItem.items;
        } else {
            count = this.itemCount;
            items = this.items;
        }
        if (index < 0 || index >= count) {
            return null;
        }
        TreeItem item = items[index];
        if (item != null || (this.style & 0x10000000) == 0 || !create) {
            return item;
        }
        items[index] = item = new TreeItem(this, parentItem, 0, index, false);
        return item;
    }

    @Override
    boolean acceptsFirstResponder(long id2, long sel) {
        return true;
    }

    @Override
    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        long superValue;
        long returnValue = 0L;
        NSString attributeName = new NSString(arg0);
        if ((attributeName.isEqualToString(OS.NSAccessibilityColumnsAttribute) || attributeName.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) && (this.style & 0x20) != 0 && (superValue = super.accessibilityAttributeValue(id2, sel, arg0)) != 0L) {
            NSArray columns = new NSArray(superValue);
            NSMutableArray columnsWithoutCheck = NSMutableArray.arrayWithCapacity(columns.count() - 1L);
            columnsWithoutCheck.addObjectsFromArray(columns);
            columnsWithoutCheck.removeObjectAtIndex(0L);
            returnValue = columnsWithoutCheck.id;
        }
        if (returnValue != 0L) {
            return returnValue;
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(TreeItem[] items, int index, GC gc, boolean recurse) {
        if (items == null) {
            return 0;
        }
        int width = 0;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item != null) {
                int itemWidth = item.calculateWidth(index, gc);
                width = Math.max(width, itemWidth);
                if (recurse && item.getExpanded()) {
                    width = Math.max(width, this.calculateWidth(item.items, index, gc, recurse));
                }
            }
            ++i;
        }
        return width;
    }

    @Override
    NSSize cellSize(long id2, long sel) {
        NSSize size = super.cellSize(id2, sel);
        NSCell cell = new NSCell(id2);
        NSImage image = cell.image();
        if (image != null) {
            size.width += (double)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            long[] outValue = new long[1];
            OS.object_getInstanceVariable(id2, Display.SWT_ROW, outValue);
            TreeItem item = (TreeItem)this.display.getWidget(outValue[0]);
            OS.object_getInstanceVariable(id2, Display.SWT_COLUMN, outValue);
            long tableColumn = outValue[0];
            int columnIndex = 0;
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].nsColumn.id == tableColumn) {
                    columnIndex = i;
                    break;
                }
                ++i;
            }
            this.sendMeasureItem(item, cell.isHighlighted(), columnIndex, size);
        }
        return size;
    }

    @Override
    boolean canDragRowsWithIndexes_atPoint(long id2, long sel, long rowIndexes, NSPoint mouseDownPoint) {
        boolean drag;
        if (!super.canDragRowsWithIndexes_atPoint(id2, sel, rowIndexes, mouseDownPoint)) {
            return false;
        }
        NSTableView widget = (NSTableView)this.view;
        long row = widget.rowAtPoint(mouseDownPoint);
        long modifiers = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl = drag = (this.state & 0x40000) != 0 && this.hooks(29);
        if (drag && !widget.isRowSelected(row) && (modifiers & 0x1E0000L) == 0L) {
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndex(row);
            widget.selectRowIndexes(set, false);
            set.release();
        }
        return widget.isRowSelected(row) && drag || !this.hasFocus();
    }

    boolean checkData(TreeItem item) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            TreeItem parentItem = item.getParentItem();
            event.item = item;
            event.index = parentItem == null ? this.indexOf(item) : parentItem.indexOf(item);
            this.ignoreRedraw = true;
            this.sendEvent(36, event);
            this.ignoreRedraw = false;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(item)) {
                item.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Tree.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void checkItems() {
        if (!this.reloadPending) {
            return;
        }
        this.reloadPending = false;
        TreeItem[] selectedItems = this.getSelection();
        ((NSOutlineView)this.view).reloadData();
        this.selectItems(selectedItems, true);
        this.ignoreExpand = true;
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] != null) {
                this.items[i].updateExpanded();
            }
            ++i;
        }
        this.ignoreExpand = false;
    }

    void clear(TreeItem parentItem, int index, boolean all) {
        TreeItem item = this._getItem(parentItem, index, false);
        if (item != null) {
            item.clear();
            item.redraw(-1);
            if (all) {
                this.clearAll(item, true);
            }
        }
    }

    void clearAll(TreeItem parentItem, boolean all) {
        int count = this.getItemCount(parentItem);
        if (count == 0) {
            return;
        }
        TreeItem[] children = parentItem == null ? this.items : parentItem.items;
        int i = 0;
        while (i < count) {
            TreeItem item = children[i];
            if (item != null) {
                item.clear();
                item.redraw(-1);
                if (all) {
                    this.clearAll(item, true);
                }
            }
            ++i;
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        this.clear(null, index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.clearAll(null, all);
    }

    void clearCachedWidth(TreeItem[] items) {
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item == null) break;
            item.width = -1;
            this.clearCachedWidth(item.items);
            ++i;
        }
    }

    @Override
    void collapseItem_collapseChildren(long id2, long sel, long itemID, boolean children) {
        TreeItem item = (TreeItem)this.display.getWidget(itemID);
        if (item == null) {
            return;
        }
        if (!this.ignoreExpand) {
            item.sendExpand(false, children);
        }
        this.ignoreExpand = true;
        super.collapseItem_collapseChildren(id2, sel, itemID, children);
        this.ignoreExpand = false;
        if (this.isDisposed() || item.isDisposed()) {
            return;
        }
        this.setScrollWidth();
    }

    @Override
    long columnAtPoint(long id2, long sel, NSPoint point) {
        if ((this.style & 0x20) != 0 && point.x <= (double)this.getCheckColumnWidth() && point.y < this.headerView.frame().height) {
            return 1L;
        }
        return super.columnAtPoint(id2, sel, point);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if (wHint == -1) {
            if (this.columnCount != 0) {
                int i = 0;
                while (i < this.columnCount) {
                    width += this.columns[i].getWidth();
                    ++i;
                }
            } else {
                GC gc = new GC(this);
                width = this.calculateWidth(this.items, 0, gc, true) + 1;
                gc.dispose();
            }
            if ((this.style & 0x20) != 0) {
                width += this.getCheckColumnWidth();
            }
        } else {
            width = wHint;
        }
        height = hHint == -1 ? (int)((NSOutlineView)this.view).numberOfRows() * this.getItemHeight() + this.getHeaderHeight() : hHint;
        if (width <= 0) {
            width = 64;
        }
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    void createColumn(TreeItem item, int index) {
        Font[] cellFont;
        Color[] cellForeground;
        Color[] cellBackground;
        Image[] images;
        String[] strings;
        if (item.items != null) {
            int i = 0;
            while (i < item.items.length) {
                if (item.items[i] != null) {
                    this.createColumn(item.items[i], index);
                }
                ++i;
            }
        }
        if ((strings = item.strings) != null) {
            String[] temp = new String[this.columnCount];
            System.arraycopy(strings, 0, temp, 0, index);
            System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
            temp[index] = "";
            item.strings = temp;
        }
        if (index == 0) {
            item.text = "";
        }
        if ((images = item.images) != null) {
            Image[] temp = new Image[this.columnCount];
            System.arraycopy(images, 0, temp, 0, index);
            System.arraycopy(images, index, temp, index + 1, this.columnCount - index - 1);
            item.images = temp;
        }
        if (index == 0) {
            item.image = null;
        }
        if ((cellBackground = item.cellBackground) != null) {
            Color[] temp = new Color[this.columnCount];
            System.arraycopy(cellBackground, 0, temp, 0, index);
            System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index - 1);
            item.cellBackground = temp;
        }
        if ((cellForeground = item.cellForeground) != null) {
            Color[] temp = new Color[this.columnCount];
            System.arraycopy(cellForeground, 0, temp, 0, index);
            System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index - 1);
            item.cellForeground = temp;
        }
        if ((cellFont = item.cellFont) != null) {
            Font[] temp = new Font[this.columnCount];
            System.arraycopy(cellFont, 0, temp, 0, index);
            System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
            item.cellFont = temp;
        }
    }

    @Override
    void createHandle() {
        NSString nsstring;
        NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
        scrollWidget.init();
        scrollWidget.setHasHorizontalScroller((this.style & 0x100) != 0);
        scrollWidget.setHasVerticalScroller((this.style & 0x200) != 0);
        scrollWidget.setAutohidesScrollers(true);
        scrollWidget.setBorderType(this.hasBorder() ? 2 : 0);
        NSOutlineView widget = (NSOutlineView)new SWTOutlineView().alloc();
        widget.initWithFrame(new NSRect());
        widget.setAllowsMultipleSelection((this.style & 2) != 0);
        widget.setAutoresizesOutlineColumn(false);
        widget.setAutosaveExpandedItems(true);
        widget.setDataSource(widget);
        widget.setDelegate(widget);
        widget.setColumnAutoresizingStyle(0L);
        NSSize spacing = new NSSize();
        spacing.height = 1.0;
        spacing.width = 1.0;
        widget.setIntercellSpacing(spacing);
        widget.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            widget.setFocusRingType(1L);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        widget.setHeaderView(null);
        NSString str = NSString.string();
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            nsstring = (NSString)new NSString().alloc();
            nsstring = nsstring.initWithString(String.valueOf(++NEXT_ID));
            this.checkColumn = this.checkColumn.initWithIdentifier(nsstring);
            nsstring.release();
            this.checkColumn.headerCell().setTitle(str);
            widget.addTableColumn(this.checkColumn);
            widget.setOutlineTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0L);
            this.checkColumn.setEditable(false);
            long cls = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(cls, 0L));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3L);
            this.buttonCell.setControlSize(1L);
            this.buttonCell.setImagePosition(1L);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString(String.valueOf(++NEXT_ID));
        this.firstColumn = this.firstColumn.initWithIdentifier(nsstring);
        nsstring.release();
        this.firstColumn.setMinWidth(17.0);
        this.firstColumn.setWidth(0.0);
        this.firstColumn.setResizingMask(0L);
        this.firstColumn.headerCell().setTitle(str);
        widget.addTableColumn(this.firstColumn);
        widget.setOutlineTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(4L);
        this.firstColumn.setDataCell(this.dataCell);
        this.scrollView = scrollWidget;
        this.view = widget;
    }

    void createItem(TreeColumn column, int index) {
        NSTableColumn nsColumn;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (index == 0) {
            column.style &= 0xFEFDBFFF;
            column.style |= 0x4000;
        }
        if (this.columnCount == this.columns.length) {
            TreeColumn[] newColumns = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        if (this.columnCount == 0) {
            nsColumn = this.firstColumn;
            nsColumn.setMinWidth(0.0);
            nsColumn.setResizingMask(2L);
            this.firstColumn = null;
        } else {
            NSOutlineView outlineView = (NSOutlineView)this.view;
            NSString str = NSString.string();
            nsColumn = (NSTableColumn)new NSTableColumn().alloc();
            NSString nsstring = (NSString)new NSString().alloc();
            nsstring = nsstring.initWithString(String.valueOf(++NEXT_ID));
            nsColumn = nsColumn.initWithIdentifier(nsstring);
            nsstring.release();
            nsColumn.setMinWidth(0.0);
            nsColumn.headerCell().setTitle(str);
            outlineView.addTableColumn(nsColumn);
            int checkColumn = (this.style & 0x20) != 0 ? 1 : 0;
            outlineView.moveColumn(this.columnCount + checkColumn, index + checkColumn);
            nsColumn.setDataCell(this.dataCell);
            if (index == 0) {
                outlineView.setOutlineTableColumn(nsColumn);
            }
        }
        column.createJNIRef();
        NSTableHeaderCell headerCell = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        if (this.font != null) {
            headerCell.setFont(this.font.handle);
        }
        nsColumn.setHeaderCell(headerCell);
        this.display.addWidget(headerCell, column);
        column.nsColumn = nsColumn;
        nsColumn.setWidth(0.0);
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.items[i];
            if (item != null && this.columnCount > 1) {
                this.createColumn(item, index);
            }
            ++i;
        }
    }

    void createItem(TreeItem item, TreeItem parentItem, int index) {
        SWTTreeItem handle;
        TreeItem[] items;
        int count;
        if (parentItem != null) {
            count = parentItem.itemCount;
            items = parentItem.items;
        } else {
            count = this.itemCount;
            items = this.items;
        }
        if (index == -1) {
            index = count;
        }
        if (index < 0 || index > count) {
            this.error(6);
        }
        if (count == items.length) {
            TreeItem[] newItems = new TreeItem[items.length + 4];
            System.arraycopy(items, 0, newItems, 0, items.length);
            items = newItems;
            if (parentItem != null) {
                parentItem.items = items;
            } else {
                this.items = items;
            }
        }
        System.arraycopy(items, index, items, index + 1, count++ - index);
        items[index] = item;
        item.items = new TreeItem[4];
        item.handle = handle = (SWTTreeItem)new SWTTreeItem().alloc().init();
        item.createJNIRef();
        item.register();
        if (parentItem != null) {
            parentItem.itemCount = count;
        } else {
            this.itemCount = count;
        }
        this.ignoreExpand = true;
        NSOutlineView widget = (NSOutlineView)this.view;
        if (this.getDrawing()) {
            TreeItem[] selectedItems = this.getSelection();
            if (parentItem != null) {
                widget.reloadItem(parentItem.handle, true);
            } else {
                widget.reloadData();
            }
            this.selectItems(selectedItems, true);
        } else {
            this.reloadPending = true;
        }
        if (parentItem != null && parentItem.itemCount == 1 && parentItem.expanded) {
            widget.expandItem(parentItem.handle);
        }
        this.ignoreExpand = false;
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
    }

    @Override
    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.outlineViewFont;
    }

    @Override
    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    @Override
    void deselectAll(long id2, long sel, long sender) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() != -1L) {
            return;
        }
        super.deselectAll(id2, sel, sender);
    }

    @Override
    void deselectRow(long id2, long sel, long index) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() == index) {
            return;
        }
        super.deselectRow(id2, sel, index);
    }

    public void deselectAll() {
        this.checkWidget();
        NSOutlineView widget = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        widget.deselectAll(null);
        this.ignoreSelect = false;
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    public void deselect(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        NSOutlineView widget = (NSOutlineView)this.view;
        long row = widget.rowForItem(item.handle);
        this.ignoreSelect = true;
        widget.deselectRow(row);
        this.ignoreSelect = false;
    }

    void destroyItem(TreeColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null) {
                if (this.columnCount <= 1) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[this.columnCount - 1];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, this.columnCount - 1 - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[this.columnCount - 1];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, this.columnCount - 1 - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        Color[] cellBackground = item.cellBackground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellBackground = temp;
                    }
                    if (item.cellForeground != null) {
                        Color[] cellForeground = item.cellForeground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellForeground = temp;
                    }
                    if (item.cellFont != null) {
                        Font[] cellFont = item.cellFont;
                        temp = new Font[this.columnCount - 1];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellFont = temp;
                    }
                }
            }
            ++i;
        }
        int oldIndex = this.indexOf(column.nsColumn);
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = column.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(17.0);
            this.firstColumn.setResizingMask(0L);
            this.setScrollWidth();
        } else {
            if (index == 0) {
                ((NSOutlineView)this.view).setOutlineTableColumn(this.columns[0].nsColumn);
            }
            ((NSOutlineView)this.view).removeTableColumn(column.nsColumn);
        }
        NSArray array = ((NSOutlineView)this.view).tableColumns();
        int arraySize = (int)array.count();
        int i2 = oldIndex;
        while (i2 < arraySize) {
            long columnId = array.objectAtIndex((long)((long)i2)).id;
            int j = 0;
            while (j < this.columnCount) {
                if (this.columns[j].nsColumn.id == columnId) {
                    this.columns[j].sendEvent(10);
                    break;
                }
                ++j;
            }
            ++i2;
        }
    }

    void destroyItem(TreeItem item) {
        TreeItem[] items;
        int count;
        TreeItem parentItem = item.parentItem;
        if (parentItem != null) {
            count = parentItem.itemCount;
            items = parentItem.items;
        } else {
            count = this.itemCount;
            items = this.items;
        }
        int index = 0;
        while (index < count) {
            if (items[index] == item) break;
            ++index;
        }
        System.arraycopy(items, index + 1, items, index, --count - index);
        items[count] = null;
        if (parentItem != null) {
            parentItem.itemCount = count;
        } else {
            this.itemCount = count;
        }
        NSOutlineView widget = (NSOutlineView)this.view;
        if (this.getDrawing()) {
            if (parentItem != null) {
                widget.reloadItem(parentItem.handle, true);
            } else {
                widget.reloadData();
            }
        } else {
            this.reloadPending = true;
        }
        this.setScrollWidth();
        if (this.itemCount == 0) {
            this.imageBounds = null;
        }
        if (this.insertItem == item) {
            this.insertItem = null;
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        return false;
    }

    @Override
    void drawBackgroundInClipRect(long id2, long sel, NSRect rect) {
        super.drawViewBackgroundInRect(id2, sel, rect);
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), rect, -1);
    }

    @Override
    void drawInteriorWithFrame_inView(long id2, long sel, NSRect rect, long view) {
        Object color;
        GC gc;
        GCData data;
        boolean isSelected;
        Color background;
        boolean hooksErase = this.hooks(40);
        boolean hooksPaint = this.hooks(42);
        boolean hooksMeasure = this.hooks(41);
        NSTextFieldCell cell = new NSTextFieldCell(id2);
        NSOutlineView widget = (NSOutlineView)this.view;
        long[] outValue = new long[1];
        OS.object_getInstanceVariable(id2, Display.SWT_ROW, outValue);
        long rowIndex = widget.rowForItem(new id(outValue[0]));
        if (rowIndex == -1L) {
            return;
        }
        TreeItem item = (TreeItem)this.display.getWidget(outValue[0]);
        if (item == null) {
            return;
        }
        OS.object_getInstanceVariable(id2, Display.SWT_COLUMN, outValue);
        long tableColumn = outValue[0];
        long nsColumnIndex = widget.tableColumns().indexOfObjectIdenticalTo(new id(tableColumn));
        int columnIndex = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == tableColumn) {
                columnIndex = i;
                break;
            }
            ++i;
        }
        Color color2 = background = item.cellBackground != null ? item.cellBackground[columnIndex] : null;
        if (background == null) {
            background = item.background;
        }
        boolean drawBackground = background != null;
        boolean drawForeground = true;
        boolean drawSelection = isSelected = cell.isHighlighted();
        boolean hasFocus = this.hasFocus();
        Color selectionBackground = null;
        Color selectionForeground = null;
        if (isSelected && (hooksErase || hooksPaint)) {
            selectionForeground = Color.cocoa_new(this.display, hasFocus || Display.APPEARANCE.Dark == this.display.appAppearance ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            selectionBackground = Color.cocoa_new(this.display, hasFocus ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize contentSize = super.cellSize(id2, OS.sel_cellSize);
        NSImage image = cell.image();
        if (image != null) {
            contentSize.width += (double)(this.imageBounds.width + 3);
        }
        int contentWidth = (int)Math.ceil(contentSize.width);
        NSSize spacing = widget.intercellSpacing();
        int itemHeight = (int)Math.ceil(widget.rowHeight() + spacing.height);
        NSRect cellRect = widget.rectOfColumn(nsColumnIndex);
        cellRect.y = rect.y;
        cellRect.height = rect.height + spacing.height;
        if (this.columnCount == 0) {
            NSRect rowRect = widget.rectOfRow(rowIndex);
            cellRect.width = rowRect.width;
        }
        double offsetX = 0.0;
        double offsetY = 0.0;
        if (hooksPaint || hooksErase) {
            NSRect frameCell = widget.frameOfCellAtColumn(nsColumnIndex, rowIndex);
            offsetX = rect.x - frameCell.x;
            offsetY = rect.y - frameCell.y;
            if (this.drawExpansion) {
                offsetX -= 0.5;
                offsetY -= 0.5;
            }
        }
        int itemX = (int)(rect.x - offsetX);
        int itemY = (int)(rect.y - offsetY);
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        if (hooksMeasure) {
            this.sendMeasureItem(item, cell.isHighlighted(), columnIndex, contentSize);
        }
        Color userForeground = null;
        if (hooksErase) {
            Color fg;
            context.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(offsetX, offsetY);
            transform.concat();
            data = new GCData();
            data.paintRect = cellRect;
            gc = GC.cocoa_new(this, data);
            gc.setFont(item.getFont(columnIndex));
            if (isSelected && ((this.style & 0x8000) == 0 || hasFocus)) {
                fg = selectionForeground;
                gc.setBackground(selectionBackground);
            } else {
                fg = item.getForeground(columnIndex);
                gc.setBackground(item.getBackground(columnIndex));
            }
            gc.setForeground(fg);
            if (!this.drawExpansion) {
                gc.setClipping((int)(cellRect.x - offsetX), (int)(cellRect.y - offsetY), (int)cellRect.width, (int)cellRect.height);
            }
            Event event = new Event();
            event.item = item;
            event.gc = gc;
            event.index = columnIndex;
            event.detail = 16;
            if (drawBackground) {
                event.detail |= 8;
            }
            if (isSelected && ((this.style & 0x8000) == 0 || hasFocus)) {
                event.detail |= 2;
            }
            event.x = (int)cellRect.x;
            event.y = (int)cellRect.y;
            event.width = (int)cellRect.width;
            event.height = (int)cellRect.height;
            this.sendEvent(40, event);
            if (!event.doit) {
                drawSelection = false;
                drawBackground = false;
                drawForeground = false;
            } else {
                drawBackground = drawBackground && (event.detail & 8) != 0;
                drawForeground = (event.detail & 0x10) != 0;
                boolean bl = drawSelection = drawSelection && (event.detail & 2) != 0;
            }
            if (!drawSelection && isSelected) {
                userForeground = Color.cocoa_new(this.display, gc.getForeground().handle);
            }
            gc.dispose();
            context.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (item.isDisposed()) {
                return;
            }
            if (drawSelection && ((this.style & 0x8000) == 0 || hasFocus)) {
                cellRect.height -= spacing.height;
                this.callSuper(widget.id, OS.sel_highlightSelectionInClipRect_, cellRect);
                cellRect.height += spacing.height;
            }
        } else if (isSelected && (this.style & 0x8000) != 0 && !hasFocus) {
            userForeground = item.getForeground(columnIndex);
        }
        if (drawBackground && !drawSelection) {
            context.saveGraphicsState();
            double[] colorRGB = background.handle;
            color = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 1.0);
            ((NSColor)color).setFill();
            NSBezierPath.fillRect(cellRect);
            context.restoreGraphicsState();
        }
        if (item == this.insertItem && this.insertItem != null && !this.insertItem.isDisposed()) {
            context.saveGraphicsState();
            NSRect contentRect = cell.titleRectForBounds(rect);
            data = new GCData();
            data.paintRect = contentRect;
            gc = GC.cocoa_new(this, data);
            gc.setClipping((int)(contentRect.x - offsetX), (int)(contentRect.y - offsetY), (int)contentRect.width, (int)contentRect.height);
            Rectangle itemRect = this.insertItem.getImageBounds(0).union(this.insertItem.getBounds());
            Rectangle clientRect = this.getClientArea();
            int x = clientRect.x + clientRect.width;
            int posY = this.insertBefore ? itemRect.y : itemRect.y + itemRect.height - 1;
            gc.drawLine(itemRect.x, posY, x, posY);
            gc.dispose();
            context.restoreGraphicsState();
        }
        if (drawForeground) {
            NSSize size;
            if ((!this.drawExpansion || hooksMeasure) && image != null) {
                NSRect destRect = new NSRect();
                destRect.x = rect.x + 3.0;
                destRect.y = rect.y + (double)((float)Math.ceil((rect.height - (double)this.imageBounds.height) / 2.0));
                destRect.width = this.imageBounds.width;
                destRect.height = this.imageBounds.height;
                NSRect srcRect = new NSRect();
                size = image.size();
                srcRect.width = size.width;
                srcRect.height = size.height;
                context.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(rect).addClip();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.scaleXBy(1.0, -1.0);
                transform.translateXBy(0.0, -(destRect.height + 2.0 * destRect.y));
                transform.concat();
                image.drawInRect(destRect, srcRect, 2L, 1.0);
                context.restoreGraphicsState();
                int imageWidth = this.imageBounds.width + 3;
                rect.x += (double)imageWidth;
                rect.width -= (double)imageWidth;
            }
            cell.setHighlighted(false);
            boolean callSuper = false;
            if (userForeground != null) {
                color = userForeground.handle;
                if (color[0] == 0.0 && color[1] == 0.0 && color[2] == 0.0 && color[3] == 1.0) {
                    NSMutableAttributedString newStr = new NSMutableAttributedString(cell.attributedStringValue().mutableCopy());
                    NSRange range = new NSRange();
                    range.length = newStr.length();
                    newStr.removeAttribute(OS.NSForegroundColorAttributeName, range);
                    int alignment = this.columnCount == 0 ? 16384 : this.columns[columnIndex].style & 0x1024000;
                    NSSize size2 = newStr.size();
                    NSRect newRect = new NSRect();
                    newRect.x = rect.x + 2.0;
                    newRect.y = rect.y;
                    newRect.width = rect.width - 2.0;
                    switch (alignment) {
                        case 0x1000000: {
                            newRect.width -= 2.0;
                            break;
                        }
                        case 131072: {
                            if (!(rect.width > size2.width)) break;
                            newRect.width -= 2.0;
                        }
                    }
                    newRect.height = rect.height;
                    if (newRect.height > size2.height) {
                        newRect.y += (newRect.height - size2.height) / 2.0;
                        newRect.height = size2.height;
                    }
                    newStr.drawInRect(newRect);
                    newStr.release();
                } else {
                    NSColor nsColor = NSColor.colorWithDeviceRed((double)color[0], (double)color[1], (double)color[2], (double)color[3]);
                    cell.setTextColor(nsColor);
                    callSuper = true;
                }
            } else {
                callSuper = true;
            }
            if (callSuper) {
                NSAttributedString attrStr = cell.attributedStringValue();
                size = attrStr.size();
                if (rect.height > size.height) {
                    rect.y += (rect.height - size.height) / 2.0;
                    rect.height = size.height;
                }
                super.drawInteriorWithFrame_inView(id2, sel, rect, view);
            }
        }
        if (hooksPaint) {
            context.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(offsetX, offsetY);
            transform.concat();
            data = new GCData();
            data.paintRect = cellRect;
            gc = GC.cocoa_new(this, data);
            gc.setFont(item.getFont(columnIndex));
            if (drawSelection) {
                gc.setForeground(selectionForeground);
                gc.setBackground(selectionBackground);
            } else {
                gc.setForeground(userForeground != null ? userForeground : item.getForeground(columnIndex));
                gc.setBackground(item.getBackground(columnIndex));
            }
            if (!this.drawExpansion) {
                gc.setClipping((int)(cellRect.x - offsetX), (int)(cellRect.y - offsetY), (int)cellRect.width, (int)cellRect.height);
            }
            Event event = new Event();
            event.item = item;
            event.gc = gc;
            event.index = columnIndex;
            if (drawForeground) {
                event.detail |= 0x10;
            }
            if (drawBackground) {
                event.detail |= 8;
            }
            if (isSelected) {
                event.detail |= 2;
            }
            event.x = itemX;
            event.y = itemY;
            event.width = contentWidth;
            event.height = itemHeight;
            this.sendEvent(42, event);
            gc.dispose();
            context.restoreGraphicsState();
        }
    }

    @Override
    void drawWithExpansionFrame_inView(long id2, long sel, NSRect cellFrame, long view) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(id2, sel, cellFrame, view);
        this.drawExpansion = false;
    }

    @Override
    void expandItem_expandChildren(long id2, long sel, long itemID, boolean children) {
        TreeItem item = (TreeItem)this.display.getWidget(itemID);
        if (item == null) {
            return;
        }
        if (!this.ignoreExpand) {
            item.sendExpand(true, children);
        }
        this.ignoreExpand = true;
        super.expandItem_expandChildren(id2, sel, itemID, children);
        this.ignoreExpand = false;
        if (this.isDisposed() || item.isDisposed()) {
            return;
        }
        if (!children) {
            this.ignoreExpand = true;
            TreeItem[] items = item.items;
            int i = 0;
            while (i < item.itemCount) {
                if (items[i] != null) {
                    items[i].updateExpanded();
                }
                ++i;
            }
            this.ignoreExpand = false;
        }
        this.setScrollWidth(false, item.items, true);
    }

    @Override
    NSRect expansionFrameWithFrame_inView(long id2, long sel, NSRect cellRect, long view) {
        if (this.toolTipText == null) {
            NSRect expansionRect;
            NSRect rect = super.expansionFrameWithFrame_inView(id2, sel, cellRect, view);
            NSCell cell = new NSCell(id2);
            NSAttributedString str = cell.attributedStringValue();
            NSSize textSize = str.size();
            if (rect.width != 0.0 && rect.height != 0.0) {
                if (this.hooks(41)) {
                    expansionRect = cellRect;
                    NSSize cellSize = cell.cellSize();
                    expansionRect.width = cellSize.width;
                } else {
                    expansionRect = rect;
                }
                if (textSize.height > expansionRect.height) {
                    expansionRect.height = textSize.height;
                }
            } else {
                NSSize cellSize;
                if (this.hooks(41)) {
                    expansionRect = cellRect;
                    cellSize = cell.cellSize();
                    expansionRect.width = cellSize.width;
                } else {
                    expansionRect = cell.titleRectForBounds(cellRect);
                    cellSize = super.cellSize(id2, OS.sel_cellSize);
                    expansionRect.width = cellSize.width;
                }
                if (textSize.height > expansionRect.height) {
                    expansionRect.height = textSize.height;
                } else {
                    NSRect contentRect = this.scrollView.contentView().bounds();
                    OS.NSIntersectionRect(contentRect, expansionRect, contentRect);
                    if (OS.NSEqualRects(expansionRect, contentRect)) {
                        return new NSRect();
                    }
                }
            }
            return expansionRect;
        }
        return new NSRect();
    }

    @Override
    Widget findTooltip(NSPoint pt) {
        long index;
        NSTableView widget = (NSTableView)this.view;
        NSTableHeaderView headerView = widget.headerView();
        if (headerView != null && (index = headerView.columnAtPoint(pt = headerView.convertPoint_fromView_(pt, null))) != -1L) {
            NSArray nsColumns = widget.tableColumns();
            id nsColumn = nsColumns.objectAtIndex(index);
            int i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                if (column.nsColumn.id == nsColumn.id) {
                    return column;
                }
                ++i;
            }
        }
        return super.findTooltip(pt);
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    @Override
    public Rectangle getClientArea() {
        NSTableHeaderView headerView;
        this.checkWidget();
        Rectangle rect = super.getClientArea();
        if (OS.VERSION < OS.VERSION(10, 11, 0) && (headerView = ((NSTableView)this.view).headerView()) != null) {
            int height = (int)headerView.bounds().height;
            rect.y -= height;
            rect.height += height;
        }
        return rect;
    }

    TreeColumn getColumn(id id2) {
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == id2.id) {
                return this.columns[i];
            }
            ++i;
        }
        return null;
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this.columns[i];
            int index = this.indexOf(column.nsColumn);
            if ((this.style & 0x20) != 0) {
                --index;
            }
            order[index] = i++;
        }
        return order;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] result = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.getHeaderBackgroundColor();
    }

    private Color getHeaderBackgroundColor() {
        return this.headerBackground != null ? Color.cocoa_new(this.display, this.headerBackground) : this.defaultBackground();
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.getHeaderForegroundColor();
    }

    Color getHeaderForegroundColor() {
        return this.headerForeground != null ? Color.cocoa_new(this.display, this.headerForeground) : this.defaultForeground();
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView headerView = ((NSOutlineView)this.view).headerView();
        if (headerView == null) {
            return 0;
        }
        return (int)headerView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).headerView() != null;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        int count = this.getItemCount();
        if (index < 0 || index >= count) {
            this.error(6);
        }
        return this._getItem(null, index, true);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.checkItems();
        NSOutlineView widget = (NSOutlineView)this.view;
        NSPoint pt = new NSPoint();
        pt.x = point.x;
        pt.y = point.y;
        int row = (int)widget.rowAtPoint(pt);
        if (row == -1) {
            return null;
        }
        NSRect rect = widget.frameOfOutlineCellAtRow(row);
        if (OS.NSPointInRect(pt, rect)) {
            return null;
        }
        id id2 = widget.itemAtRow(row);
        Widget item = this.display.getWidget(id2.id);
        if (item != null && item instanceof TreeItem) {
            return (TreeItem)item;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    int getItemCount(TreeItem item) {
        return item == null ? this.itemCount : item.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSOutlineView)this.view).rowHeight() + 1;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this._getItem(null, i, true);
            ++i;
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        NSOutlineView widget = (NSOutlineView)this.view;
        if (widget.numberOfSelectedRows() == 0L) {
            return new TreeItem[0];
        }
        NSIndexSet selection = widget.selectedRowIndexes();
        int count = (int)selection.count();
        long[] indexBuffer = new long[count];
        selection.getIndexes(indexBuffer, count, 0L);
        TreeItem[] result = new TreeItem[count];
        int i = 0;
        while (i < count) {
            id id2 = widget.itemAtRow(indexBuffer[i]);
            Widget item = this.display.getWidget(id2.id);
            if (item != null && item instanceof TreeItem) {
                result[i] = (TreeItem)item;
            }
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSOutlineView)this.view).numberOfSelectedRows();
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        NSOutlineView outlineView;
        long index;
        NSTableHeaderView headerView;
        this.checkWidget();
        NSRect rect = this.scrollView.documentVisibleRect();
        NSPoint point = new NSPoint();
        point.x = rect.x;
        point.y = rect.y;
        if (OS.VERSION >= OS.VERSION(10, 11, 0) && (headerView = ((NSTableView)this.view).headerView()) != null) {
            int height = (int)headerView.bounds().height;
            point.y += (double)height;
        }
        if ((index = (outlineView = (NSOutlineView)this.view).rowAtPoint(point)) == -1L) {
            return null;
        }
        id item = outlineView.itemAtRow(index);
        return (TreeItem)this.display.getWidget(item.id);
    }

    @Override
    NSRect headerRectOfColumn(long id2, long sel, long column) {
        if ((this.style & 0x20) == 0) {
            return this.callSuperRect(id2, sel, column);
        }
        if (column == 0L) {
            NSRect returnValue = this.callSuperRect(id2, sel, column);
            returnValue.width = 0.0;
            return returnValue;
        }
        if (column == 1L) {
            NSRect returnValue = this.callSuperRect(id2, sel, column);
            returnValue.width += this.checkColumn.width() + 1.0;
            returnValue.x -= this.checkColumn.width() + 1.0;
            return returnValue;
        }
        return this.callSuperRect(id2, sel, column);
    }

    @Override
    void highlightSelectionInClipRect(long id2, long sel, long rect) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect clipRect = new NSRect();
        OS.memmove(clipRect, rect, (long)NSRect.sizeof);
        this.callSuper(id2, sel, clipRect);
    }

    @Override
    long hitTestForEvent(long id2, long sel, long event, NSRect rect, long controlView) {
        return this.callSuper(id2, sel, event, rect, controlView);
    }

    @Override
    long image(long id2, long sel) {
        long[] image = new long[1];
        OS.object_getInstanceVariable(id2, Display.SWT_IMAGE, image);
        return image[0];
    }

    @Override
    NSRect imageRectForBounds(long id2, long sel, NSRect cellFrame) {
        NSImage image = new NSCell(id2).image();
        if (image != null) {
            cellFrame.x += 3.0;
            cellFrame.width = this.imageBounds.width;
            cellFrame.height = this.imageBounds.height;
        }
        return cellFrame;
    }

    int indexOf(NSTableColumn column) {
        return (int)((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(column);
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parentItem != null) {
            return -1;
        }
        int i = 0;
        while (i < this.itemCount) {
            if (item == this.items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    boolean isTransparent() {
        return true;
    }

    @Override
    boolean isTrim(NSView view) {
        if (super.isTrim(view)) {
            return true;
        }
        return view.id == this.headerView.id;
    }

    @Override
    void keyDown(long id2, long sel, long theEvent) {
        this.preventSelect = false;
        this.ignoreSelect = false;
        super.keyDown(id2, sel, theEvent);
    }

    @Override
    long menuForEvent(long id2, long sel, long theEvent) {
        if (this.display.lastHandledMenuForEventId == theEvent) {
            return 0L;
        }
        if (id2 != this.headerView.id) {
            NSPoint mousePoint;
            long row;
            NSEvent event = new NSEvent(theEvent);
            NSOutlineView tree = (NSOutlineView)this.view;
            NSIndexSet selectedRowIndexes = tree.selectedRowIndexes();
            if (!selectedRowIndexes.containsIndex(row = tree.rowAtPoint(mousePoint = this.view.convertPoint_fromView_(event.locationInWindow(), null)))) {
                NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
                set = set.initWithIndex(row);
                tree.selectRowIndexes(set, false);
                set.release();
            }
        }
        return super.menuForEvent(id2, sel, theEvent);
    }

    @Override
    void mouseDown(long id2, long sel, long theEvent) {
        NSEvent event;
        if (id2 == this.view.id && ((event = new NSEvent(theEvent)).modifierFlags() & 0x40000L) != 0L) {
            return;
        }
        super.mouseDown(id2, sel, theEvent);
    }

    @Override
    void mouseDownSuper(long id2, long sel, long theEvent) {
        NSRect rect;
        NSRect checkRect;
        int column;
        NSCell cell;
        this.preventSelect = false;
        this.ignoreSelect = false;
        boolean check = false;
        NSEvent nsEvent = new NSEvent(theEvent);
        NSOutlineView widget = (NSOutlineView)this.view;
        NSPoint pt = this.view.convertPoint_fromView_(nsEvent.locationInWindow(), null);
        int row = (int)widget.rowAtPoint(pt);
        NSObject itemID = null;
        if (row != -1) {
            itemID = new NSObject(widget.itemAtRow(row));
        }
        if (row != -1 && (this.style & 0x20) != 0 && (cell = widget.preparedCellAtColumn(column = (int)widget.columnAtPoint(pt), row)) != null && cell.isKindOfClass(OS.class_NSButtonCell) && cell.isEnabled() && OS.NSPointInRect(pt, checkRect = cell.imageRectForBounds(widget.frameOfCellAtColumn(column, row)))) {
            this.preventSelect = true;
            check = true;
        }
        if (!check && row != -1 && (nsEvent.modifierFlags() & 0xFFFF0000L) == 0L && nsEvent.clickCount() == 1L && widget.isRowSelected(row) && !OS.NSPointInRect(pt, rect = widget.frameOfOutlineCellAtRow(row))) {
            this.selectedRowIndex = row;
        }
        this.didSelect = false;
        if (itemID != null) {
            itemID.retain();
        }
        super.mouseDownSuper(id2, sel, theEvent);
        if (itemID != null) {
            itemID.release();
        }
        this.didSelect = false;
    }

    @Override
    boolean needsPanelToBecomeKey(long id2, long sel) {
        return false;
    }

    @Override
    long nextState(long id2, long sel) {
        NSOutlineView outlineView = (NSOutlineView)this.view;
        int index = (int)outlineView.clickedRow();
        if (index == -1) {
            index = (int)outlineView.selectedRow();
        }
        TreeItem item = (TreeItem)this.display.getWidget(outlineView.itemAtRow((long)((long)index)).id);
        if (item.grayed) {
            return item.checked ? 0 : -1;
        }
        return item.checked ? 0 : 1;
    }

    @Override
    long outlineView_child_ofItem(long id2, long sel, long outlineView, long index, long itemID) {
        TreeItem parent = (TreeItem)this.display.getWidget(itemID);
        TreeItem item = this._getItem(parent, (int)index, true);
        if (item != null && item.handle != null) {
            return item.handle.id;
        }
        return 0L;
    }

    @Override
    void outlineView_didClickTableColumn(long id2, long sel, long outlineView, long tableColumn) {
        TreeColumn column = this.getColumn(new id(tableColumn));
        if (column == null) {
            return;
        }
        column.sendSelectionEvent(13);
    }

    @Override
    long outlineView_objectValueForTableColumn_byItem(long id2, long sel, long outlineView, long tableColumn, long itemID) {
        TreeItem item = (TreeItem)this.display.getWidget(itemID);
        this.checkData(item);
        if (this.checkColumn != null && tableColumn == this.checkColumn.id) {
            NSNumber value = item.checked && item.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(item.checked ? 1 : 0);
            return value.id;
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == tableColumn) {
                return item.createString((int)i).id;
            }
            ++i;
        }
        return item.createString((int)0).id;
    }

    @Override
    boolean outlineView_isItemExpandable(long id2, long sel, long outlineView, long item) {
        if (item == 0L) {
            return true;
        }
        return ((TreeItem)this.display.getWidget((long)item)).itemCount != 0;
    }

    @Override
    long outlineView_numberOfChildrenOfItem(long id2, long sel, long outlineView, long item) {
        if (item == 0L) {
            return this.itemCount;
        }
        return ((TreeItem)this.display.getWidget((long)item)).itemCount;
    }

    @Override
    boolean outlineView_shouldExpandItem_item(long id2, long sel, long arg0, long arg1) {
        return this.shouldExpand;
    }

    @Override
    boolean outlineView_shouldReorderColumn_toColumn(long id2, long sel, long aTableView, long currentColIndex, long newColIndex) {
        if ((this.style & 0x20) != 0) {
            if (currentColIndex == 0L) {
                return false;
            }
            if (newColIndex == 0L) {
                return false;
            }
        }
        NSOutlineView widget = new NSOutlineView(aTableView);
        id nsColumn = widget.tableColumns().objectAtIndex(currentColIndex);
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == nsColumn.id) {
                return this.columns[i].movable;
            }
            ++i;
        }
        return true;
    }

    @Override
    boolean outlineView_shouldTrackCell_forTableColumn_item(long id2, long sel, long table, long cell, long tableColumn, long item) {
        if ((this.style & 0x20) != 0 && new NSCell(cell).isKindOfClass(OS.class_NSButtonCell)) {
            return true;
        }
        NSOutlineView widget = (NSOutlineView)this.view;
        long rowIndex = widget.rowForItem(new id(item));
        return widget.isRowSelected(rowIndex);
    }

    @Override
    void outlineView_willDisplayCell_forTableColumn_item(long id2, long sel, long outlineView, long cell, long tableColumn, long itemID) {
        Font font;
        NSColor color;
        if (this.checkColumn != null && tableColumn == this.checkColumn.id) {
            return;
        }
        TreeItem item = (TreeItem)this.display.getWidget(itemID);
        int index = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == tableColumn) {
                index = i;
                break;
            }
            ++i;
        }
        NSTextFieldCell textCell = new NSTextFieldCell(cell);
        OS.object_setInstanceVariable(cell, Display.SWT_ROW, itemID);
        OS.object_setInstanceVariable(cell, Display.SWT_COLUMN, tableColumn);
        Image image = index == 0 ? item.image : (item.images == null ? null : item.images[index]);
        textCell.setImage(image != null ? image.handle : null);
        if (textCell.isEnabled()) {
            if (textCell.isHighlighted()) {
                color = NSColor.selectedControlTextColor();
            } else {
                Color foreground;
                Color color2 = foreground = item.cellForeground != null ? item.cellForeground[index] : null;
                if (foreground == null) {
                    foreground = item.foreground;
                }
                if (foreground == null) {
                    foreground = this.getForegroundColor();
                }
                color = NSColor.colorWithDeviceRed(foreground.handle[0], foreground.handle[1], foreground.handle[2], 1.0);
            }
        } else {
            color = NSColor.disabledControlTextColor();
        }
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        int alignment = 0;
        if (this.columnCount > 0) {
            int style = this.columns[index].style;
            if ((style & 0x1000000) != 0) {
                alignment = 2;
            } else if ((style & 0x20000) != 0) {
                alignment = 1;
            }
        }
        Font font2 = font = item.cellFont != null ? item.cellFont[index] : null;
        if (font == null) {
            font = item.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
            dict.setObject(color, OS.NSForegroundColorAttributeName);
            dict.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(dict, font);
            NSMutableParagraphStyle paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            paragraphStyle.setLineBreakMode(2L);
            paragraphStyle.setAlignment(alignment);
            paragraphStyle.setBaseWritingDirection(direction);
            dict.setObject(paragraphStyle, OS.NSParagraphStyleAttributeName);
            paragraphStyle.release();
            NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(textCell.title(), dict);
            textCell.setAttributedStringValue(attribStr);
            attribStr.release();
            dict.release();
        } else {
            textCell.setFont(font.handle);
            textCell.setTextColor(color);
            textCell.setAlignment(alignment);
            textCell.setBaseWritingDirection(direction);
        }
    }

    @Override
    void outlineViewColumnDidMove(long id2, long sel, long aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSDictionary userInfo = notification.userInfo();
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString("NSOldColumn");
        id nsOldIndex = userInfo.valueForKey(nsstring);
        nsstring.release();
        nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString("NSNewColumn");
        id nsNewIndex = userInfo.valueForKey(nsstring);
        nsstring.release();
        int oldIndex = new NSNumber(nsOldIndex).intValue();
        int newIndex = new NSNumber(nsNewIndex).intValue();
        NSOutlineView outlineView = (NSOutlineView)this.view;
        int startIndex = Math.min(oldIndex, newIndex);
        int endIndex = Math.max(oldIndex, newIndex);
        NSArray nsColumns = outlineView.tableColumns();
        int i = startIndex;
        while (i <= endIndex) {
            id columnId = nsColumns.objectAtIndex(i);
            TreeColumn column = this.getColumn(columnId);
            if (column != null) {
                column.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++i;
        }
        this.headerView.setNeedsDisplay(true);
    }

    @Override
    void outlineViewColumnDidResize(long id2, long sel, long aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSDictionary userInfo = notification.userInfo();
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString("NSTableColumn");
        id columnId = userInfo.valueForKey(nsstring);
        nsstring.release();
        TreeColumn column = this.getColumn(columnId);
        if (column == null) {
            return;
        }
        column.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSOutlineView outlineView = (NSOutlineView)this.view;
        int index = this.indexOf(column.nsColumn);
        if (index == -1) {
            return;
        }
        NSArray nsColumns = outlineView.tableColumns();
        int columnCount = (int)outlineView.numberOfColumns();
        int i = index + 1;
        while (i < columnCount) {
            columnId = nsColumns.objectAtIndex(i);
            column = this.getColumn(columnId);
            if (column != null) {
                column.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++i;
        }
    }

    @Override
    void scrollClipViewToPoint(long id2, long sel, long clipView, NSPoint point) {
        if (this.shouldScroll) {
            super.scrollClipViewToPoint(id2, sel, clipView, point);
            if ((this.style & 0x20) != 0 && this.columnCount > 0 && ((NSOutlineView)this.view).headerView() != null && point.x <= (double)this.getCheckColumnWidth()) {
                this.headerView.setNeedsDisplayInRect(this.headerView.headerRectOfColumn(1L));
            }
        }
    }

    @Override
    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        NSOutlineView widget = (NSOutlineView)this.view;
        int row = (int)widget.selectedRow();
        if (row == -1) {
            this.sendSelectionEvent(13);
        } else {
            id _id = widget.itemAtRow(row);
            TreeItem item = (TreeItem)this.display.getWidget(_id.id);
            Event event = new Event();
            event.item = item;
            event.index = row;
            this.sendSelectionEvent(13, event, false);
        }
    }

    @Override
    void outlineViewSelectionDidChange(long id2, long sel, long notification) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    @Override
    void outlineViewSelectionIsChanging(long id2, long sel, long notification) {
        this.didSelect = true;
        this.sendSelection();
    }

    @Override
    void outlineView_setObjectValue_forTableColumn_byItem(long id2, long sel, long outlineView, long object, long tableColumn, long itemID) {
        if (this.checkColumn != null && tableColumn == this.checkColumn.id) {
            TreeItem item = (TreeItem)this.display.getWidget(itemID);
            item.checked = !item.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            this.sendSelectionEvent(13, event, false);
            item.redraw(-1);
        }
    }

    @Override
    boolean outlineView_writeItems_toPasteboard(long id2, long sel, long arg0, long arg1, long arg2) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.items = null;
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TreeColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.sortColumn = null;
    }

    public void removeAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.items.length) {
            TreeItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.items = new TreeItem[4];
        this.itemCount = 0;
        this.imageBounds = null;
        this.insertItem = null;
        this.ignoreSelect = true;
        ((NSOutlineView)this.view).reloadData();
        this.ignoreSelect = false;
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    @Override
    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.items.length) {
                TreeItem item = this.items[i];
                if (item != null) {
                    item.reskinChildren(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columns.length) {
                TreeColumn column = this.columns[i];
                if (column != null) {
                    column.reskinChildren(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void setImage(long id2, long sel, long arg0) {
        OS.object_setInstanceVariable(id2, Display.SWT_IMAGE, arg0);
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
        TreeItem oldMark = this.insertItem;
        this.insertItem = item;
        this.insertBefore = before;
        if (oldMark != null && !oldMark.isDisposed()) {
            oldMark.redraw(-1);
        }
        if (item != null) {
            item.redraw(-1);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.checkItems();
        NSOutlineView widget = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        widget.selectAll(null);
        this.ignoreSelect = false;
    }

    public void select(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(item);
        NSOutlineView outlineView = (NSOutlineView)this.view;
        long row = outlineView.rowForItem(item.handle);
        NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
        set = set.initWithIndex(row);
        this.ignoreSelect = true;
        outlineView.selectRowIndexes(set, (this.style & 2) != 0);
        this.ignoreSelect = false;
        set.release();
    }

    @Override
    void selectRowIndexes_byExtendingSelection(long id2, long sel, long indexes, boolean extend) {
        NSIndexSet set;
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && (set = new NSIndexSet(indexes)).count() == 0L) {
            return;
        }
        super.selectRowIndexes_byExtendingSelection(id2, sel, indexes, extend);
    }

    @Override
    void sendDoubleSelection() {
        NSOutlineView outlineView = (NSOutlineView)this.view;
        int rowIndex = (int)outlineView.clickedRow();
        if (rowIndex == -1) {
            rowIndex = (int)outlineView.selectedRow();
        }
        if (rowIndex != -1) {
            if ((this.style & 0x20) != 0) {
                NSArray columns = outlineView.tableColumns();
                int columnIndex = (int)outlineView.clickedColumn();
                if (columnIndex != -1) {
                    id column = columns.objectAtIndex(columnIndex);
                    if (column.id == this.checkColumn.id) {
                        return;
                    }
                }
            }
            TreeItem item = (TreeItem)this.display.getWidget(outlineView.itemAtRow((long)((long)rowIndex)).id);
            Event event = new Event();
            event.item = item;
            this.sendSelectionEvent(14, event, false);
        }
    }

    @Override
    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        short keyCode = nsEvent.keyCode();
        switch (keyCode) {
            case 36: 
            case 76: {
                this.sendDoubleSelection();
            }
        }
        return result;
    }

    void sendMeasureItem(TreeItem item, boolean selected, int columnIndex, NSSize size) {
        NSOutlineView widget = (NSOutlineView)this.view;
        int contentWidth = (int)Math.ceil(size.width);
        NSSize spacing = widget.intercellSpacing();
        int itemHeight = (int)Math.ceil(widget.rowHeight() + spacing.height);
        GCData data = new GCData();
        data.paintRect = widget.frame();
        GC gc = GC.cocoa_new(this, data);
        gc.setFont(item.getFont(columnIndex));
        Event event = new Event();
        event.item = item;
        event.gc = gc;
        event.index = columnIndex;
        event.width = contentWidth;
        event.height = itemHeight;
        if (selected && ((this.style & 0x8000) == 0 || this.hasFocus())) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        gc.dispose();
        if (!this.isDisposed() && !item.isDisposed()) {
            size.width = event.width;
            size.height = event.height;
            if (itemHeight < event.height) {
                widget.setRowHeight(event.height);
            }
            if (contentWidth != event.width && this.columnCount == 0 && columnIndex == 0) {
                item.width = event.width;
                item.width = (int)((double)item.width + widget.indentationPerLevel() * (double)(1L + widget.levelForItem(item.handle)));
                if (this.setScrollWidth(item)) {
                    widget.setNeedsDisplay(true);
                }
            }
        }
    }

    @Override
    boolean sendMouseEvent(NSEvent nsEvent, int type, boolean send) {
        if (type == 29) {
            this.dragDetected = true;
        } else if (type == 4) {
            if (!this.dragDetected && this.selectedRowIndex != -1) {
                Widget item;
                NSOutlineView widget = (NSOutlineView)this.view;
                NSIndexSet selectedRows = widget.selectedRowIndexes();
                int count = (int)selectedRows.count();
                long[] indexBuffer = new long[count];
                selectedRows.getIndexes(indexBuffer, count, 0L);
                int i = 0;
                while (i < count) {
                    if (indexBuffer[i] != (long)this.selectedRowIndex) {
                        this.ignoreSelect = true;
                        widget.deselectRow(indexBuffer[i]);
                        this.ignoreSelect = false;
                    }
                    ++i;
                }
                Event event = new Event();
                id itemID = widget.itemAtRow(this.selectedRowIndex);
                if (itemID != null && (item = this.display.getWidget(itemID.id)) != null && item instanceof TreeItem) {
                    event.item = this.display.getWidget(itemID.id);
                    this.sendSelectionEvent(13, event, false);
                }
                this.selectedRowIndex = -1;
                this.ignoreSelect = true;
            }
            this.dragDetected = false;
        }
        return super.sendMouseEvent(nsEvent, type, send);
    }

    void selectItems(TreeItem[] items, boolean ignoreDisposed) {
        NSOutlineView outlineView = (NSOutlineView)this.view;
        NSMutableIndexSet set = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int length = items.length;
        int i = 0;
        while (i < length) {
            block5: {
                block6: {
                    if (items[i] == null) break block5;
                    if (!items[i].isDisposed()) break block6;
                    if (ignoreDisposed) break block5;
                    this.error(5);
                }
                TreeItem item = items[i];
                if (!ignoreDisposed) {
                    this.showItem(items[i], false);
                }
                set.addIndex(outlineView.rowForItem(item.handle));
            }
            ++i;
        }
        this.ignoreSelect = true;
        outlineView.selectRowIndexes(set, false);
        this.ignoreSelect = false;
        set.release();
    }

    @Override
    NSRect titleRectForBounds(long id2, long sel, NSRect cellFrame) {
        NSImage image = new NSCell(id2).image();
        if (image != null) {
            int imageWidth = this.imageBounds.width + 3;
            cellFrame.x += (double)imageWidth;
            cellFrame.width -= (double)imageWidth;
        }
        return cellFrame;
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        ((NSTableView)this.view).setBackgroundColor(nsColor);
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = this.getColumnOrder();
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(5);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (order[i] != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            TreeColumn column;
            NSOutlineView outlineView = (NSOutlineView)this.view;
            int[] oldX = new int[oldOrder.length];
            int check = (this.style & 0x20) != 0 ? 1 : 0;
            int i2 = 0;
            while (i2 < oldOrder.length) {
                int index = oldOrder[i2];
                oldX[index] = (int)outlineView.rectOfColumn((long)((long)(i2 + check))).x;
                ++i2;
            }
            int[] newX = new int[order.length];
            int i3 = 0;
            while (i3 < order.length) {
                int index = order[i3];
                column = this.columns[index];
                int oldIndex = this.indexOf(column.nsColumn);
                int newIndex = i3 + check;
                outlineView.moveColumn(oldIndex, newIndex);
                newX[index] = (int)outlineView.rectOfColumn((long)((long)newIndex)).x;
                ++i3;
            }
            TreeColumn[] newColumns = new TreeColumn[this.columnCount];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            int i4 = 0;
            while (i4 < this.columnCount) {
                column = newColumns[i4];
                if (!column.isDisposed() && newX[i4] != oldX[i4]) {
                    column.sendEvent(10);
                }
                ++i4;
            }
        }
    }

    @Override
    void setFont(NSFont font) {
        super.setFont(font);
        int i = 0;
        while (i < this.columnCount) {
            this.columns[i].nsColumn.headerCell().setFont(font);
            ++i;
        }
        this.setItemHeight(null, font, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth();
    }

    public void setHeaderBackground(Color color) {
        double[] headerBackground;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray = headerBackground = color != null ? color.handle : null;
        if (this.equals(headerBackground, this.headerBackground)) {
            return;
        }
        this.headerBackground = headerBackground;
        if (this.getHeaderVisible()) {
            this.redrawWidget(this.headerView, false);
        }
    }

    public void setHeaderForeground(Color color) {
        double[] headerForeground;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray = headerForeground = color != null ? color.handle : null;
        if (this.equals(headerForeground, this.headerForeground)) {
            return;
        }
        this.headerForeground = headerForeground;
        if (this.getHeaderVisible()) {
            this.redrawWidget(this.headerView, false);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        ((NSOutlineView)this.view).setHeaderView(show ? this.headerView : null);
        this.scrollView.tile();
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.checkItems();
        count = Math.max(0, count);
        this.setItemCount(null, count);
    }

    void setItemCount(TreeItem parentItem, int count) {
        boolean expanded;
        int itemCount = this.getItemCount(parentItem);
        if (count == itemCount) {
            return;
        }
        NSOutlineView widget = (NSOutlineView)this.view;
        int length = Math.max(4, (count + 3) / 4 * 4);
        TreeItem[] children = parentItem == null ? this.items : parentItem.items;
        boolean bl = expanded = parentItem == null || parentItem.getExpanded();
        if (count < itemCount) {
            if (parentItem == null) {
                this.itemCount = count;
            } else {
                parentItem.itemCount = count;
            }
            TreeItem[] selectedItems = this.getSelection();
            widget.reloadItem(parentItem != null ? parentItem.handle : null, expanded);
            int index = count;
            while (index < itemCount) {
                TreeItem item = children[index];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++index;
            }
            this.selectItems(selectedItems, true);
            TreeItem[] newItems = new TreeItem[length];
            if (children != null) {
                System.arraycopy(children, 0, newItems, 0, count);
            }
            children = newItems;
            if (parentItem == null) {
                this.items = newItems;
            } else {
                parentItem.items = newItems;
            }
        } else if ((this.style & 0x10000000) == 0) {
            int i = itemCount;
            while (i < count) {
                new TreeItem(this, parentItem, 0, i, true);
                ++i;
            }
        } else {
            TreeItem[] newItems = new TreeItem[length];
            if (children != null) {
                System.arraycopy(children, 0, newItems, 0, itemCount);
            }
            children = newItems;
            if (parentItem == null) {
                this.items = newItems;
                this.itemCount = count;
            } else {
                parentItem.items = newItems;
                parentItem.itemCount = count;
            }
            TreeItem[] selectedItems = this.getSelection();
            widget.reloadItem(parentItem != null ? parentItem.handle : null, expanded);
            this.selectItems(selectedItems, true);
            if (parentItem != null && itemCount == 0 && parentItem.expanded) {
                this.ignoreExpand = true;
                widget.expandItem(parentItem.handle);
                this.ignoreExpand = false;
            }
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
        if (itemHeight == -1) {
            this.setItemHeight(null, null, true);
        } else {
            ((NSOutlineView)this.view).setRowHeight(itemHeight);
        }
    }

    void setItemHeight(Image image, NSFont font, boolean set) {
        Rectangle bounds;
        if (font == null) {
            font = this.getFont().handle;
        }
        double ascent = font.ascender();
        double descent = -font.descender() + font.leading();
        int height = (int)Math.ceil(ascent + descent) + 1;
        Rectangle rectangle = bounds = image != null ? image.getBounds() : this.imageBounds;
        if (bounds != null) {
            this.imageBounds = bounds;
            height = Math.max(height, bounds.height);
        }
        NSTableView widget = (NSTableView)this.view;
        if (set || widget.rowHeight() < (double)height) {
            widget.setRowHeight(height);
            if (this.headerView != null) {
                NSRect frame = this.headerView.frame();
                frame.height = height;
                this.headerView.setFrame(frame);
            }
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        ((NSOutlineView)this.view).setUsesAlternatingRowBackgroundColors(show);
        ((NSOutlineView)this.view).setGridStyleMask(show ? 1 : 0);
    }

    @Override
    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            this.checkItems();
            this.setScrollWidth();
        }
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(true, this.items, true);
    }

    boolean setScrollWidth(boolean set, TreeItem[] items, boolean recurse) {
        int oldWidth;
        if (items == null) {
            return false;
        }
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = this.calculateWidth(items, 0, gc, recurse);
        gc.dispose();
        if (!set && (oldWidth = (int)this.firstColumn.width()) >= newWidth) {
            return false;
        }
        this.firstColumn.setWidth(newWidth);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    boolean setScrollWidth(TreeItem item) {
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        TreeItem parentItem = item.parentItem;
        if (parentItem != null && !parentItem.getExpanded()) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = item.calculateWidth(0, gc);
        gc.dispose();
        int oldWidth = (int)this.firstColumn.width();
        if (oldWidth < newWidth) {
            this.firstColumn.setWidth(newWidth);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    @Override
    void setShouldExpandItem(long id2, long sel, boolean shouldExpand) {
        this.shouldExpand = shouldExpand;
    }

    @Override
    void setShouldScrollClipView(long id2, long sel, boolean shouldScroll) {
        this.shouldScroll = shouldScroll;
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.checkItems();
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.selectItems(items, false);
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                if (item != null) {
                    this.showItem(item, true);
                    break;
                }
                ++i;
            }
        }
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        this.setSort(column, this.sortDirection);
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        if (direction == this.sortDirection) {
            return;
        }
        this.setSort(this.sortColumn, direction);
    }

    void setSort(TreeColumn column, int direction) {
        NSImage image = null;
        NSTableColumn nsColumn = null;
        if (column != null) {
            nsColumn = column.nsColumn;
            if (direction == 1024) {
                image = NSImage.imageNamed(NSString.stringWith("NSDescendingSortIndicator"));
            }
            if (direction == 128) {
                image = NSImage.imageNamed(NSString.stringWith("NSAscendingSortIndicator"));
            }
        }
        NSTableView widget = (NSTableView)this.view;
        if (this.sortColumn != null && this.sortColumn != column) {
            widget.setIndicatorImage(null, this.sortColumn.nsColumn);
        }
        widget.setHighlightedTableColumn(nsColumn);
        widget.setIndicatorImage(image, nsColumn);
        this.sortDirection = direction;
        this.sortColumn = column;
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(item, false);
        NSOutlineView widget = (NSOutlineView)this.view;
        long row = widget.rowForItem(item.handle);
        if (row == -1L) {
            return;
        }
        NSPoint pt = new NSPoint();
        pt.x = this.scrollView.contentView().bounds().x;
        pt.y = widget.frameOfCellAtColumn((long)0L, (long)row).y;
        if (OS.VERSION >= OS.VERSION(10, 11, 0) && widget.headerView() != null) {
            NSRect headerRect = this.headerView.frame();
            pt.y -= headerRect.y + headerRect.height;
        }
        this.view.scrollPoint(pt);
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int index = this.indexOf(column.nsColumn);
        if (index < 0 || index >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSOutlineView)this.view).scrollColumnToVisible(index);
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(item, true);
    }

    void showItem(TreeItem item, boolean scroll) {
        TreeItem parentItem = item.parentItem;
        if (parentItem != null) {
            this.showItem(parentItem, false);
            if (!parentItem.getExpanded()) {
                parentItem.setExpanded(true);
                Event event = new Event();
                event.item = parentItem;
                this.sendEvent(17, event);
            }
        }
        if (scroll) {
            NSOutlineView outlineView = (NSOutlineView)this.view;
            outlineView.scrollRowToVisible(outlineView.rowForItem(item.handle));
        }
    }

    public void showSelection() {
        this.checkWidget();
        this.checkItems();
        TreeItem[] selection = this.getSelection();
        if (selection.length > 0) {
            this.checkData(selection[0]);
            this.showItem(selection[0], true);
        }
    }

    @Override
    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(enabled, this.headerView);
    }
}

