/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.keyboard;

import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.exception.TestFailureException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.keyboard.Keyboard;
import org.eclipse.reddeer.swt.keyboard.KeyboardFactory;
import org.eclipse.reddeer.swt.test.utils.ShellTestUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class KeyboardTest {
    protected static final String SHELL_TITLE = "Keyboard testing shell";
    private Text text;

    @After
    public void cleanup() {
        try {
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ShellTestUtils.closeShell(KeyboardTest.SHELL_TITLE);
                }
            });
        }
        catch (RedDeerException redDeerException) {}
    }

    @Test
    public void typingWithShiftTest() {
        this.openTestingShell();
        KeyboardFactory.getKeyboard().type("{@Test}");
        Assert.assertEquals((Object)"{@Test}", (Object)this.getText());
    }

    @Test
    public void typingTest() {
        this.openTestingShell();
        KeyboardFactory.getKeyboard().type("test123");
        Assert.assertEquals((Object)"test123", (Object)this.getText());
    }

    @Test(expected=TestFailureException.class)
    public void keyCombinationTest() {
        new DefaultShell();
        KeyboardFactory.getKeyboard().invokeKeyCombination(new int[]{262144, 104});
        try {
            new DefaultShell("Search").close();
        }
        catch (CoreLayerException ex) {
            throw new TestFailureException(ex.getMessage());
        }
    }

    @Test(expected=TestFailureException.class)
    public void selectionTest() {
        this.openTestingShell();
        KeyboardFactory.getKeyboard().type("test");
        KeyboardFactory.getKeyboard().select(2, true);
        KeyboardFactory.getKeyboard().type(127);
        try {
            Assert.assertEquals((Object)"te", (Object)this.getText());
        }
        catch (ComparisonFailure ex) {
            throw new TestFailureException(ex.getMessage());
        }
    }

    @Test(expected=TestFailureException.class)
    public void copyPasteTest() {
        this.openTestingShell();
        Keyboard keyboard = KeyboardFactory.getKeyboard();
        keyboard.type("test");
        keyboard.select(2, true);
        keyboard.writeToClipboard(false);
        keyboard.moveCursor(5, true);
        keyboard.pasteFromClipboard();
        try {
            Assert.assertEquals((Object)"sttest", (Object)this.getText());
        }
        catch (ComparisonFailure ex) {
            throw new TestFailureException(ex.getMessage());
        }
    }

    @Test(expected=TestFailureException.class)
    public void cutPasteTest() {
        this.openTestingShell();
        Keyboard keyboard = KeyboardFactory.getKeyboard();
        keyboard.type("test");
        keyboard.select(2, true);
        keyboard.writeToClipboard(true);
        keyboard.moveCursor(5, true);
        keyboard.pasteFromClipboard();
        try {
            Assert.assertEquals((Object)"stte", (Object)this.getText());
        }
        catch (ComparisonFailure ex) {
            throw new TestFailureException(ex.getMessage());
        }
    }

    private void openTestingShell() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell shell = ShellTestUtils.createShell(KeyboardTest.SHELL_TITLE);
                KeyboardTest.this.text = new Text((Composite)shell, 0);
                shell.layout();
            }
        });
        new DefaultShell(SHELL_TITLE);
        new DefaultText();
    }

    private String getText() {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return KeyboardTest.this.text.getText();
            }
        });
    }
}

