/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.osgi.util.NLS;

public class ChainElement {
    private final IBinding element;
    private ITypeBinding returnType;
    private int dimension;
    private ElementType elementType;
    private final boolean requireThis;

    public ChainElement(IBinding binding, boolean requireThis) {
        if (binding == null) {
            throw new IllegalArgumentException("???");
        }
        this.element = binding;
        this.requireThis = requireThis;
        this.initializeReturnType();
    }

    private void initializeReturnType() {
        switch (this.element.getKind()) {
            case 3: {
                IVariableBinding tmp = (IVariableBinding)this.element;
                this.returnType = tmp.getType();
                if (tmp.isField()) {
                    this.elementType = ElementType.FIELD;
                    break;
                }
                this.elementType = ElementType.LOCAL_VARIABLE;
                break;
            }
            case 4: {
                this.returnType = ((IMethodBinding)this.element).getReturnType();
                this.elementType = ElementType.METHOD;
                break;
            }
            case 2: {
                this.returnType = (ITypeBinding)this.element;
                this.elementType = ElementType.FIELD;
                break;
            }
            default: {
                JavaManipulationPlugin.logErrorMessage(NLS.bind((String)"Cannot handle {0} as return type.", (Object)this.element));
            }
        }
        this.dimension = this.returnType.getDimensions();
    }

    public <T extends IBinding> T getElementBinding() {
        return (T)this.element;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ITypeBinding getReturnType() {
        return this.returnType;
    }

    public int getReturnTypeDimension() {
        return this.dimension;
    }

    public boolean requiresThisForQualification() {
        return this.requireThis;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChainElement) {
            ChainElement other = (ChainElement)obj;
            return this.element.equals((Object)other.element);
        }
        return false;
    }

    public String toString() {
        if (this.elementType == ElementType.METHOD) {
            IMethodBinding m = (IMethodBinding)this.element;
            IJavaElement e = m.getJavaElement();
            StringBuilder ret = new StringBuilder(m.getName());
            if (e instanceof IMethod) {
                try {
                    return ret.append(((IMethod)e).getSignature()).toString();
                }
                catch (JavaModelException javaModelException) {
                    return ret.toString();
                }
            }
        }
        return this.element.toString();
    }

    public static enum ElementType {
        METHOD,
        FIELD,
        LOCAL_VARIABLE;

    }
}

