/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTableView;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    TableColumn sortColumn;
    TableItem currentItem;
    NSTableHeaderView headerView;
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    int columnCount;
    int itemCount;
    int lastIndexOf;
    int sortDirection;
    int selectedRowIndex = -1;
    boolean ignoreSelect;
    boolean fixScrollWidth;
    boolean drawExpansion;
    boolean didSelect;
    boolean preventSelect;
    boolean dragDetected;
    Rectangle imageBounds;
    double[] headerBackground;
    double[] headerForeground;
    boolean shouldScroll = true;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 5;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    @Override
    boolean acceptsFirstResponder(long id2, long sel) {
        return true;
    }

    @Override
    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        long superValue;
        long returnValue = 0L;
        NSString attributeName = new NSString(arg0);
        if ((attributeName.isEqualToString(OS.NSAccessibilityColumnsAttribute) || attributeName.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) && (this.style & 0x20) != 0 && (superValue = super.accessibilityAttributeValue(id2, sel, arg0)) != 0L) {
            NSArray columns = new NSArray(superValue);
            NSMutableArray columnsWithoutCheck = NSMutableArray.arrayWithCapacity(columns.count() - 1L);
            columnsWithoutCheck.addObjectsFromArray(columns);
            columnsWithoutCheck.removeObjectAtIndex(0L);
            returnValue = columnsWithoutCheck.id;
        }
        if (returnValue != 0L) {
            return returnValue;
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    @Override
    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        this.clearCachedWidth(this.items);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    TableItem _getItem(int index) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[index];
        }
        if (this.items[index] != null) {
            return this.items[index];
        }
        this.items[index] = new TableItem(this, 0, -1, false);
        return this.items[index];
    }

    int calculateWidth(TableItem[] items, int index, GC gc) {
        int width = 0;
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = items[i];
            if (item != null && item.cached) {
                width = Math.max(width, item.calculateWidth(index, gc, this.isSelected(index)));
            }
            ++i;
        }
        return width;
    }

    @Override
    NSSize cellSize(long id2, long sel) {
        NSSize size = super.cellSize(id2, sel);
        NSCell cell = new NSCell(id2);
        NSImage image = cell.image();
        if (image != null) {
            size.width += (double)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            long[] outValue = new long[1];
            OS.object_getInstanceVariable(id2, Display.SWT_ROW, outValue);
            long rowIndex = outValue[0];
            TableItem item = this._getItem((int)rowIndex);
            OS.object_getInstanceVariable(id2, Display.SWT_COLUMN, outValue);
            long tableColumn = outValue[0];
            int columnIndex = 0;
            int i = 0;
            while (i < this.columnCount) {
                if (this.columns[i].nsColumn.id == tableColumn) {
                    columnIndex = i;
                    break;
                }
                ++i;
            }
            this.sendMeasureItem(item, columnIndex, size, cell.isHighlighted());
        }
        return size;
    }

    @Override
    boolean canDragRowsWithIndexes_atPoint(long id2, long sel, long rowIndexes, NSPoint mouseDownPoint) {
        boolean drag;
        if (!super.canDragRowsWithIndexes_atPoint(id2, sel, rowIndexes, mouseDownPoint)) {
            return false;
        }
        NSTableView widget = (NSTableView)this.view;
        long row = widget.rowAtPoint(mouseDownPoint);
        long modifiers = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl = drag = (this.state & 0x40000) != 0 && this.hooks(29);
        if (drag && !widget.isRowSelected(row) && (modifiers & 0x1A0000L) == 0L) {
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndex(row);
            widget.selectRowIndexes(set, false);
            set.release();
        }
        return widget.isRowSelected(row) && drag || !this.hasFocus();
    }

    boolean checkData(TableItem item) {
        return this.checkData(item, this.indexOf(item));
    }

    boolean checkData(TableItem item, int index) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = this.indexOf(item);
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(item)) {
                item.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Table.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            if (this.currentItem != item) {
                item.clear();
            }
            if (this.currentItem == null) {
                item.redraw(-1);
            }
            this.setScrollWidth(item);
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.clearAll();
        } else {
            int i = start;
            while (i <= end) {
                this.clear(i);
                ++i;
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemCount) {
                this.error(6);
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            this.clear(indices[i]);
            ++i;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
        if (this.currentItem == null && this.isDrawing()) {
            this.view.setNeedsDisplay(true);
        }
        this.setScrollWidth(this.items, true);
    }

    void clearCachedWidth(TableItem[] items) {
        if (items == null) {
            return;
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] != null) {
                items[i].width = -1;
            }
            ++i;
        }
    }

    @Override
    long columnAtPoint(long id2, long sel, NSPoint point) {
        if ((this.style & 0x20) != 0 && point.x <= (double)this.getCheckColumnWidth() && point.y < this.headerView.frame().height) {
            return 1L;
        }
        return super.columnAtPoint(id2, sel, point);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            if (this.columnCount != 0) {
                int i = 0;
                while (i < this.columnCount) {
                    width += this.columns[i].getWidth();
                    ++i;
                }
            } else {
                GC gc = new GC(this);
                width += this.calculateWidth(this.items, 0, gc) + 1;
                gc.dispose();
            }
            if ((this.style & 0x20) != 0) {
                width += this.getCheckColumnWidth();
            }
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        height = hHint == -1 ? this.itemCount * this.getItemHeight() + this.getHeaderHeight() : hHint;
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new Point(rect.width, rect.height);
    }

    void createColumn(TableItem item, int index) {
        Font[] cellFont;
        Color[] cellForeground;
        Color[] cellBackground;
        Image[] images;
        String[] strings = item.strings;
        if (strings != null) {
            String[] temp = new String[this.columnCount];
            System.arraycopy(strings, 0, temp, 0, index);
            System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
            temp[index] = "";
            item.strings = temp;
        }
        if (index == 0) {
            item.text = "";
        }
        if ((images = item.images) != null) {
            Image[] temp = new Image[this.columnCount];
            System.arraycopy(images, 0, temp, 0, index);
            System.arraycopy(images, index, temp, index + 1, this.columnCount - index - 1);
            item.images = temp;
        }
        if (index == 0) {
            item.image = null;
        }
        if ((cellBackground = item.cellBackground) != null) {
            Color[] temp = new Color[this.columnCount];
            System.arraycopy(cellBackground, 0, temp, 0, index);
            System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index - 1);
            item.cellBackground = temp;
        }
        if ((cellForeground = item.cellForeground) != null) {
            Color[] temp = new Color[this.columnCount];
            System.arraycopy(cellForeground, 0, temp, 0, index);
            System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index - 1);
            item.cellForeground = temp;
        }
        if ((cellFont = item.cellFont) != null) {
            Font[] temp = new Font[this.columnCount];
            System.arraycopy(cellFont, 0, temp, 0, index);
            System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
            item.cellFont = temp;
        }
    }

    @Override
    void createHandle() {
        NSString nsstring;
        NSScrollView scrollWidget = (NSScrollView)new SWTScrollView().alloc();
        scrollWidget.init();
        scrollWidget.setHasHorizontalScroller((this.style & 0x100) != 0);
        scrollWidget.setHasVerticalScroller((this.style & 0x200) != 0);
        scrollWidget.setAutohidesScrollers(true);
        scrollWidget.setBorderType(this.hasBorder() ? 2 : 0);
        NSTableView widget = (NSTableView)new SWTTableView().alloc();
        widget.init();
        widget.setAllowsMultipleSelection((this.style & 2) != 0);
        widget.setDataSource(widget);
        widget.setDelegate(widget);
        widget.setColumnAutoresizingStyle(0L);
        NSSize spacing = new NSSize();
        spacing.height = 1.0;
        spacing.width = 1.0;
        widget.setIntercellSpacing(spacing);
        widget.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            widget.setFocusRingType(1L);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        widget.setHeaderView(null);
        NSString str = NSString.string();
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            nsstring = (NSString)new NSString().alloc();
            nsstring = nsstring.initWithString(String.valueOf(++NEXT_ID));
            this.checkColumn = this.checkColumn.initWithIdentifier(nsstring);
            nsstring.release();
            this.checkColumn.headerCell().setTitle(str);
            widget.addTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0L);
            this.checkColumn.setEditable(false);
            long cls = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(cls, 0L));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3L);
            this.buttonCell.setControlSize(1L);
            this.buttonCell.setImagePosition(1L);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString(String.valueOf(++NEXT_ID));
        this.firstColumn = this.firstColumn.initWithIdentifier(nsstring);
        nsstring.release();
        this.firstColumn.setMinWidth(5.0);
        this.firstColumn.setWidth(0.0);
        this.firstColumn.setResizingMask(0L);
        this.firstColumn.headerCell().setTitle(str);
        widget.addTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(4L);
        this.firstColumn.setDataCell(this.dataCell);
        widget.setHighlightedTableColumn(null);
        this.scrollView = scrollWidget;
        this.view = widget;
    }

    void createItem(TableColumn column, int index) {
        NSTableColumn nsColumn;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        if (this.columnCount == 0) {
            nsColumn = this.firstColumn;
            nsColumn.setMinWidth(0.0);
            nsColumn.setResizingMask(2L);
            this.firstColumn = null;
        } else {
            nsColumn = (NSTableColumn)new NSTableColumn().alloc();
            NSString nsstring = (NSString)new NSString().alloc();
            nsstring = nsstring.initWithString(String.valueOf(++NEXT_ID));
            nsColumn = nsColumn.initWithIdentifier(nsstring);
            nsstring.release();
            nsColumn.setMinWidth(0.0);
            ((NSTableView)this.view).addTableColumn(nsColumn);
            int checkColumn = (this.style & 0x20) != 0 ? 1 : 0;
            ((NSTableView)this.view).moveColumn(this.columnCount + checkColumn, index + checkColumn);
            nsColumn.setDataCell(this.dataCell);
        }
        column.createJNIRef();
        NSTableHeaderCell headerCell = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        if (this.font != null) {
            headerCell.setFont(this.font.handle);
        }
        nsColumn.setHeaderCell(headerCell);
        this.display.addWidget(headerCell, column);
        column.nsColumn = nsColumn;
        nsColumn.setWidth(0.0);
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null && this.columnCount > 1) {
                this.createColumn(item, index);
            }
            ++i;
        }
    }

    void createItem(TableItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            int length = this.getDrawing() ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        this.updateRowCount();
        if (index != this.itemCount) {
            this.fixSelection(index, true);
        }
    }

    @Override
    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
    }

    @Override
    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.tableViewFont;
    }

    @Override
    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    @Override
    void deselectAll(long id2, long sel, long sender) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() != -1L) {
            return;
        }
        super.deselectAll(id2, sel, sender);
    }

    @Override
    void deselectRow(long id2, long sel, long index) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() == index) {
            return;
        }
        super.deselectRow(id2, sel, index);
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.deselectRow(index);
            this.ignoreSelect = false;
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (end < 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(this.itemCount - 1, end);
        if (start == 0 && end == this.itemCount - 1) {
            this.deselectAll();
        } else {
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            int i = start;
            while (i <= end) {
                widget.deselectRow(i);
                ++i;
            }
            this.ignoreSelect = false;
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        int i = 0;
        while (i < indices.length) {
            widget.deselectRow(indices[i]);
            ++i;
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        widget.deselectAll(null);
        this.ignoreSelect = false;
    }

    void destroyItem(TableColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                if (this.columnCount <= 1) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[this.columnCount - 1];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, this.columnCount - 1 - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[this.columnCount - 1];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, this.columnCount - 1 - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        Color[] cellBackground = item.cellBackground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellBackground = temp;
                    }
                    if (item.cellForeground != null) {
                        Color[] cellForeground = item.cellForeground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellForeground = temp;
                    }
                    if (item.cellFont != null) {
                        Font[] cellFont = item.cellFont;
                        temp = new Font[this.columnCount - 1];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellFont = temp;
                    }
                }
            }
            ++i;
        }
        int oldIndex = this.indexOf(column.nsColumn);
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = column.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(5.0);
            this.firstColumn.setResizingMask(0L);
            this.setScrollWidth();
        } else {
            ((NSTableView)this.view).removeTableColumn(column.nsColumn);
        }
        NSArray array = ((NSTableView)this.view).tableColumns();
        int arraySize = (int)array.count();
        int i2 = oldIndex;
        while (i2 < arraySize) {
            long columnId = array.objectAtIndex((long)((long)i2)).id;
            int j = 0;
            while (j < this.columnCount) {
                if (this.columns[j].nsColumn.id == columnId) {
                    this.columns[j].sendEvent(10);
                    break;
                }
                ++j;
            }
            ++i2;
        }
    }

    void destroyItem(TableItem item) {
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (index != this.itemCount - 1) {
            this.fixSelection(index, false);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    @Override
    boolean dragDetect(int x, int y, boolean filter, boolean[] consume) {
        return false;
    }

    @Override
    void drawBackgroundInClipRect(long id2, long sel, NSRect rect) {
        super.drawViewBackgroundInRect(id2, sel, rect);
        if (id2 != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), rect, -1);
    }

    @Override
    void drawInteriorWithFrame_inView(long id2, long sel, NSRect rect, long view) {
        Object color;
        GC gc;
        GCData data;
        boolean isSelected;
        Color background;
        boolean hooksErase = this.hooks(40);
        boolean hooksPaint = this.hooks(42);
        boolean hooksMeasure = this.hooks(41);
        NSTextFieldCell cell = new NSTextFieldCell(id2);
        NSTableView widget = (NSTableView)this.view;
        long[] outValue = new long[1];
        OS.object_getInstanceVariable(id2, Display.SWT_ROW, outValue);
        long rowIndex = outValue[0];
        TableItem item = this._getItem((int)rowIndex);
        OS.object_getInstanceVariable(id2, Display.SWT_COLUMN, outValue);
        long tableColumn = outValue[0];
        long nsColumnIndex = widget.tableColumns().indexOfObjectIdenticalTo(new id(tableColumn));
        int columnIndex = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == tableColumn) {
                columnIndex = i;
                break;
            }
            ++i;
        }
        Color color2 = background = item.cellBackground != null ? item.cellBackground[columnIndex] : null;
        if (background == null) {
            background = item.background;
        }
        boolean drawBackground = background != null;
        boolean drawForeground = true;
        boolean drawSelection = isSelected = cell.isHighlighted();
        boolean hasFocus = this.hasFocus();
        Color selectionBackground = null;
        Color selectionForeground = null;
        if (isSelected && (hooksErase || hooksPaint)) {
            selectionForeground = Color.cocoa_new(this.display, hasFocus || Display.APPEARANCE.Dark == this.display.appAppearance ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            selectionBackground = Color.cocoa_new(this.display, hasFocus ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize contentSize = super.cellSize(id2, OS.sel_cellSize);
        NSImage image = cell.image();
        if (image != null) {
            contentSize.width += (double)(this.imageBounds.width + 3);
        }
        int contentWidth = (int)Math.ceil(contentSize.width);
        NSSize spacing = widget.intercellSpacing();
        int itemHeight = (int)Math.ceil(widget.rowHeight() + spacing.height);
        NSRect cellRect = widget.rectOfColumn(nsColumnIndex);
        cellRect.y = rect.y;
        cellRect.height = rect.height + spacing.height;
        if (this.columnCount == 0) {
            NSRect rowRect = widget.rectOfRow(rowIndex);
            cellRect.width = rowRect.width;
        }
        double offsetX = 0.0;
        double offsetY = 0.0;
        if (hooksPaint || hooksErase) {
            NSRect frameCell = widget.frameOfCellAtColumn(nsColumnIndex, rowIndex);
            offsetX = rect.x - frameCell.x;
            offsetY = rect.y - frameCell.y;
            if (this.drawExpansion) {
                offsetX -= 0.5;
                offsetY -= 0.5;
            }
        }
        int itemX = (int)(rect.x - offsetX);
        int itemY = (int)(rect.y - offsetY);
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        if (hooksMeasure) {
            this.sendMeasureItem(item, columnIndex, contentSize, isSelected);
        }
        Color userForeground = null;
        if (hooksErase) {
            Color fg;
            context.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(offsetX, offsetY);
            transform.concat();
            data = new GCData();
            data.paintRect = cellRect;
            gc = GC.cocoa_new(this, data);
            gc.setFont(item.getFont(columnIndex));
            if (isSelected && ((this.style & 0x8000) == 0 || hasFocus)) {
                fg = selectionForeground;
                gc.setBackground(selectionBackground);
            } else {
                fg = item.getForeground(columnIndex);
                gc.setBackground(item.getBackground(columnIndex));
            }
            gc.setForeground(fg);
            if (!this.drawExpansion) {
                gc.setClipping((int)(cellRect.x - offsetX), (int)(cellRect.y - offsetY), (int)cellRect.width, (int)cellRect.height);
            }
            Event event = new Event();
            event.item = item;
            event.gc = gc;
            event.index = columnIndex;
            event.detail = 16;
            if (drawBackground) {
                event.detail |= 8;
            }
            if (isSelected && ((this.style & 0x8000) == 0 || hasFocus)) {
                event.detail |= 2;
            }
            event.x = (int)cellRect.x;
            event.y = (int)cellRect.y;
            event.width = (int)cellRect.width;
            event.height = (int)cellRect.height;
            this.sendEvent(40, event);
            if (!event.doit) {
                drawSelection = false;
                drawBackground = false;
                drawForeground = false;
            } else {
                drawBackground = drawBackground && (event.detail & 8) != 0;
                drawForeground = (event.detail & 0x10) != 0;
                boolean bl = drawSelection = drawSelection && (event.detail & 2) != 0;
            }
            if (!drawSelection && isSelected) {
                userForeground = Color.cocoa_new(this.display, gc.getForeground().handle);
            }
            gc.dispose();
            context.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (item.isDisposed()) {
                return;
            }
            if (drawSelection) {
                cellRect.height -= spacing.height;
                this.callSuper(widget.id, OS.sel_highlightSelectionInClipRect_, cellRect);
                cellRect.height += spacing.height;
            }
        } else if (isSelected && (this.style & 0x8000) != 0 && !hasFocus) {
            userForeground = item.getForeground(columnIndex);
        }
        if (drawBackground && !drawSelection) {
            context.saveGraphicsState();
            double[] colorRGB = background.handle;
            color = NSColor.colorWithDeviceRed(colorRGB[0], colorRGB[1], colorRGB[2], 1.0);
            color.setFill();
            NSBezierPath.fillRect(cellRect);
            context.restoreGraphicsState();
        }
        if (drawForeground) {
            if ((!this.drawExpansion || hooksMeasure) && image != null) {
                NSRect destRect = new NSRect();
                destRect.x = rect.x + 3.0;
                destRect.y = rect.y + (double)((float)Math.ceil((rect.height - (double)this.imageBounds.height) / 2.0));
                destRect.width = this.imageBounds.width;
                destRect.height = this.imageBounds.height;
                context.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(rect).addClip();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.scaleXBy(1.0, -1.0);
                transform.translateXBy(0.0, -(destRect.height + 2.0 * destRect.y));
                transform.concat();
                image.drawInRect(destRect, new NSRect(), 2L, 1.0);
                context.restoreGraphicsState();
                int imageWidth = this.imageBounds.width + 3;
                rect.x += (double)imageWidth;
                rect.width -= (double)imageWidth;
            }
            cell.setHighlighted(false);
            boolean callSuper = false;
            if (userForeground != null) {
                color = userForeground.handle;
                if (color[0] == 0.0 && color[1] == 0.0 && color[2] == 0.0 && color[3] == 1.0) {
                    NSMutableAttributedString newStr = new NSMutableAttributedString(cell.attributedStringValue().mutableCopy());
                    NSRange range = new NSRange();
                    range.length = newStr.length();
                    newStr.removeAttribute(OS.NSForegroundColorAttributeName, range);
                    int alignment = this.columnCount == 0 ? 16384 : this.columns[columnIndex].style & 0x1024000;
                    NSSize size = newStr.size();
                    NSRect newRect = new NSRect();
                    newRect.x = rect.x + 2.0;
                    newRect.y = rect.y;
                    newRect.width = rect.width - 2.0;
                    switch (alignment) {
                        case 0x1000000: {
                            newRect.width -= 2.0;
                            break;
                        }
                        case 131072: {
                            if (!(rect.width > size.width)) break;
                            newRect.width -= 2.0;
                        }
                    }
                    newRect.height = rect.height;
                    if (newRect.height > size.height) {
                        newRect.y += (newRect.height - size.height) / 2.0;
                        newRect.height = size.height;
                    }
                    newStr.drawInRect(newRect);
                    newStr.release();
                } else {
                    NSColor nsColor = NSColor.colorWithDeviceRed((double)color[0], (double)color[1], (double)color[2], (double)color[3]);
                    cell.setTextColor(nsColor);
                    callSuper = true;
                }
            } else {
                callSuper = true;
            }
            if (callSuper) {
                NSAttributedString attrStr = cell.attributedStringValue();
                NSSize size = attrStr.size();
                if (rect.height > size.height) {
                    rect.y += (rect.height - size.height) / 2.0;
                    rect.height = size.height;
                }
                super.drawInteriorWithFrame_inView(id2, sel, rect, view);
            }
        }
        if (hooksPaint) {
            context.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(offsetX, offsetY);
            transform.concat();
            data = new GCData();
            data.paintRect = cellRect;
            gc = GC.cocoa_new(this, data);
            gc.setFont(item.getFont(columnIndex));
            if (drawSelection) {
                gc.setForeground(selectionForeground);
                gc.setBackground(selectionBackground);
            } else {
                gc.setForeground(userForeground != null ? userForeground : item.getForeground(columnIndex));
                gc.setBackground(item.getBackground(columnIndex));
            }
            if (!this.drawExpansion) {
                gc.setClipping((int)(cellRect.x - offsetX), (int)(cellRect.y - offsetY), (int)cellRect.width, (int)cellRect.height);
            }
            Event event = new Event();
            event.item = item;
            event.gc = gc;
            event.index = columnIndex;
            if (drawForeground) {
                event.detail |= 0x10;
            }
            if (drawBackground) {
                event.detail |= 8;
            }
            if (isSelected) {
                event.detail |= 2;
            }
            event.x = itemX;
            event.y = itemY;
            event.width = contentWidth;
            event.height = itemHeight;
            this.sendEvent(42, event);
            gc.dispose();
            context.restoreGraphicsState();
        }
    }

    @Override
    void drawWithExpansionFrame_inView(long id2, long sel, NSRect cellFrame, long view) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(id2, sel, cellFrame, view);
        this.drawExpansion = false;
    }

    @Override
    void drawRect(long id2, long sel, NSRect rect) {
        this.fixScrollWidth = false;
        super.drawRect(id2, sel, rect);
        if (this.isDisposed()) {
            return;
        }
        if (this.fixScrollWidth) {
            this.fixScrollWidth = false;
            if (this.setScrollWidth(this.items, true)) {
                this.view.setNeedsDisplay(true);
            }
        }
    }

    @Override
    NSRect expansionFrameWithFrame_inView(long id2, long sel, NSRect cellRect, long view) {
        if (this.toolTipText == null) {
            NSRect expansionRect;
            NSRect rect = super.expansionFrameWithFrame_inView(id2, sel, cellRect, view);
            NSCell cell = new NSCell(id2);
            NSAttributedString str = cell.attributedStringValue();
            NSSize textSize = str.size();
            if (rect.width != 0.0 && rect.height != 0.0) {
                if (this.hooks(41)) {
                    expansionRect = cellRect;
                    NSSize cellSize = cell.cellSize();
                    expansionRect.width = cellSize.width;
                } else {
                    expansionRect = rect;
                }
                if (textSize.height > expansionRect.height) {
                    expansionRect.height = textSize.height;
                }
            } else {
                NSSize cellSize;
                if (this.hooks(41)) {
                    expansionRect = cellRect;
                    cellSize = cell.cellSize();
                    expansionRect.width = cellSize.width;
                } else {
                    expansionRect = cell.titleRectForBounds(cellRect);
                    cellSize = super.cellSize(id2, OS.sel_cellSize);
                    expansionRect.width = cellSize.width;
                }
                if (textSize.height > expansionRect.height) {
                    expansionRect.height = textSize.height;
                } else {
                    NSRect contentRect = this.scrollView.contentView().bounds();
                    OS.NSIntersectionRect(contentRect, expansionRect, contentRect);
                    if (OS.NSEqualRects(expansionRect, contentRect)) {
                        return new NSRect();
                    }
                }
            }
            return expansionRect;
        }
        return new NSRect();
    }

    @Override
    Widget findTooltip(NSPoint pt) {
        long index;
        NSTableView widget = (NSTableView)this.view;
        NSTableHeaderView headerView = widget.headerView();
        if (headerView != null && (index = headerView.columnAtPoint(pt = headerView.convertPoint_fromView_(pt, null))) != -1L) {
            NSArray nsColumns = widget.tableColumns();
            id nsColumn = nsColumns.objectAtIndex(index);
            int i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (column.nsColumn.id == nsColumn.id) {
                    return column;
                }
                ++i;
            }
        }
        return super.findTooltip(pt);
    }

    void fixSelection(int index, boolean add) {
        int[] selection = this.getSelectionIndices();
        if (selection.length == 0) {
            return;
        }
        int newCount = 0;
        boolean fix = false;
        int i = 0;
        while (i < selection.length) {
            if (!add && selection[i] == index) {
                fix = true;
            } else {
                int newIndex = newCount++;
                selection[newIndex] = selection[i];
                if (selection[newIndex] >= index) {
                    int n = newIndex;
                    selection[n] = selection[n] + (add ? 1 : -1);
                    fix = true;
                }
            }
            ++i;
        }
        if (fix) {
            this.select(selection, newCount, true);
        }
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    @Override
    public Rectangle getClientArea() {
        NSTableHeaderView headerView;
        this.checkWidget();
        Rectangle rect = super.getClientArea();
        if (OS.VERSION < OS.VERSION(10, 11, 0) && (headerView = ((NSTableView)this.view).headerView()) != null) {
            int height = (int)headerView.bounds().height;
            rect.y -= height;
            rect.height += height;
        }
        return rect;
    }

    TableColumn getColumn(id id2) {
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == id2.id) {
                return this.columns[i];
            }
            ++i;
        }
        return null;
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int i = 0;
        while (i < this.columnCount) {
            TableColumn column = this.columns[i];
            int index = this.indexOf(column.nsColumn);
            if ((this.style & 0x20) != 0) {
                --index;
            }
            order[index] = i++;
        }
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public Color getHeaderBackground() {
        this.checkWidget();
        return this.getHeaderBackgroundColor();
    }

    private Color getHeaderBackgroundColor() {
        return this.headerBackground != null ? Color.cocoa_new(this.display, this.headerBackground) : this.defaultBackground();
    }

    public Color getHeaderForeground() {
        this.checkWidget();
        return this.getHeaderForegroundColor();
    }

    Color getHeaderForegroundColor() {
        return this.headerForeground != null ? Color.cocoa_new(this.display, this.headerForeground) : this.defaultForeground();
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView headerView = ((NSTableView)this.view).headerView();
        if (headerView == null) {
            return 0;
        }
        return (int)headerView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).headerView() != null;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(Point point) {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        NSPoint pt = new NSPoint();
        pt.x = point.x;
        pt.y = point.y;
        int row = (int)widget.rowAtPoint(pt);
        if (row == -1) {
            return null;
        }
        return this.items[row];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSTableView)this.view).rowHeight() + 1;
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSTableView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        if (widget.numberOfSelectedRows() == 0L) {
            return new TableItem[0];
        }
        NSIndexSet selection = widget.selectedRowIndexes();
        int count = (int)selection.count();
        long[] indexBuffer = new long[count];
        selection.getIndexes(indexBuffer, count, 0L);
        TableItem[] result = new TableItem[count];
        int i = 0;
        while (i < count) {
            result[i] = this._getItem((int)indexBuffer[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return (int)((NSTableView)this.view).numberOfSelectedRows();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        if (widget.numberOfSelectedRows() == 0L) {
            return -1;
        }
        NSIndexSet selection = widget.selectedRowIndexes();
        int count = (int)selection.count();
        long[] result = new long[count];
        selection.getIndexes(result, count, 0L);
        return (int)result[0];
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        if (widget.numberOfSelectedRows() == 0L) {
            return new int[0];
        }
        NSIndexSet selection = widget.selectedRowIndexes();
        int count = (int)selection.count();
        long[] indices = new long[count];
        selection.getIndexes(indices, count, 0L);
        int[] result = new int[count];
        int i = 0;
        while (i < indices.length) {
            result[i] = (int)indices[i];
            ++i;
        }
        return result;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        int rowAtPoint;
        NSTableHeaderView headerView;
        this.checkWidget();
        NSRect rect = this.scrollView.documentVisibleRect();
        NSPoint point = new NSPoint();
        point.x = rect.x;
        point.y = rect.y;
        if (OS.VERSION >= OS.VERSION(10, 11, 0) && (headerView = ((NSTableView)this.view).headerView()) != null) {
            int height = (int)headerView.bounds().height;
            point.y += (double)height;
        }
        if ((rowAtPoint = (int)((NSTableView)this.view).rowAtPoint(point)) == -1) {
            return 0;
        }
        return rowAtPoint;
    }

    @Override
    NSRect headerRectOfColumn(long id2, long sel, long column) {
        if ((this.style & 0x20) == 0) {
            return this.callSuperRect(id2, sel, column);
        }
        if (column == 0L) {
            NSRect returnValue = this.callSuperRect(id2, sel, column);
            returnValue.width = 0.0;
            return returnValue;
        }
        if (column == 1L) {
            NSRect returnValue = this.callSuperRect(id2, sel, column);
            returnValue.width += this.checkColumn.width() + 1.0;
            returnValue.x -= this.checkColumn.width() + 1.0;
            return returnValue;
        }
        return this.callSuperRect(id2, sel, column);
    }

    @Override
    void highlightSelectionInClipRect(long id2, long sel, long rect) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect clipRect = new NSRect();
        OS.memmove(clipRect, rect, (long)NSRect.sizeof);
        this.callSuper(id2, sel, clipRect);
    }

    @Override
    long hitTestForEvent(long id2, long sel, long event, NSRect rect, long controlView) {
        return this.callSuper(id2, sel, event, rect, controlView);
    }

    @Override
    long image(long id2, long sel) {
        long[] image = new long[1];
        OS.object_getInstanceVariable(id2, Display.SWT_IMAGE, image);
        return image[0];
    }

    @Override
    NSRect imageRectForBounds(long id2, long sel, NSRect cellFrame) {
        NSImage image = new NSCell(id2).image();
        if (image != null) {
            cellFrame.x += 3.0;
            cellFrame.width = this.imageBounds.width;
            cellFrame.height = this.imageBounds.height;
        }
        return cellFrame;
    }

    int indexOf(NSTableColumn column) {
        return (int)((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(column);
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = this.itemCount - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return false;
        }
        return ((NSTableView)this.view).isRowSelected(index);
    }

    @Override
    boolean isTransparent() {
        return true;
    }

    @Override
    void keyDown(long id2, long sel, long theEvent) {
        this.preventSelect = false;
        this.ignoreSelect = false;
        super.keyDown(id2, sel, theEvent);
    }

    @Override
    boolean isTrim(NSView view) {
        if (super.isTrim(view)) {
            return true;
        }
        return view.id == this.headerView.id;
    }

    @Override
    long menuForEvent(long id2, long sel, long theEvent) {
        if (this.display.lastHandledMenuForEventId == theEvent) {
            return 0L;
        }
        if (id2 != this.headerView.id) {
            NSPoint mousePoint;
            long row;
            NSEvent event = new NSEvent(theEvent);
            NSTableView table = (NSTableView)this.view;
            NSIndexSet selectedRowIndexes = table.selectedRowIndexes();
            if (!selectedRowIndexes.containsIndex(row = table.rowAtPoint(mousePoint = this.view.convertPoint_fromView_(event.locationInWindow(), null)))) {
                NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
                set = set.initWithIndex(row);
                table.selectRowIndexes(set, false);
                set.release();
            }
        }
        return super.menuForEvent(id2, sel, theEvent);
    }

    @Override
    void mouseDown(long id2, long sel, long theEvent) {
        NSEvent event;
        if (id2 == this.view.id && ((event = new NSEvent(theEvent)).modifierFlags() & 0x40000L) != 0L) {
            return;
        }
        super.mouseDown(id2, sel, theEvent);
    }

    @Override
    void mouseDownSuper(long id2, long sel, long theEvent) {
        NSRect checkRect;
        int column;
        NSCell cell;
        this.preventSelect = false;
        this.ignoreSelect = false;
        boolean check = false;
        NSTableView widget = (NSTableView)this.view;
        NSEvent nsEvent = new NSEvent(theEvent);
        NSPoint pt = this.view.convertPoint_fromView_(nsEvent.locationInWindow(), null);
        int row = (int)widget.rowAtPoint(pt);
        if (row != -1 && (this.style & 0x20) != 0 && (cell = widget.preparedCellAtColumn(column = (int)widget.columnAtPoint(pt), row)) != null && cell.isKindOfClass(OS.class_NSButtonCell) && cell.isEnabled() && OS.NSPointInRect(pt, checkRect = cell.imageRectForBounds(widget.frameOfCellAtColumn(column, row)))) {
            this.preventSelect = true;
            check = true;
        }
        if (!check && row != -1 && (nsEvent.modifierFlags() & 0xFFFF0000L) == 0L && nsEvent.clickCount() == 1L && widget.isRowSelected(row) && row >= 0 && row < this.itemCount) {
            this.selectedRowIndex = row;
        }
        this.didSelect = false;
        super.mouseDownSuper(id2, sel, theEvent);
        this.didSelect = false;
    }

    @Override
    boolean needsPanelToBecomeKey(long id2, long sel) {
        return false;
    }

    @Override
    long nextState(long id2, long sel) {
        NSTableView tableView = (NSTableView)this.view;
        int index = (int)tableView.clickedRow();
        if (index == -1) {
            index = (int)tableView.selectedRow();
        }
        TableItem item = this.items[index];
        if (item.grayed) {
            return item.checked ? 0 : -1;
        }
        return item.checked ? 0 : 1;
    }

    @Override
    long numberOfRowsInTableView(long id2, long sel, long aTableView) {
        return this.itemCount;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.currentItem = null;
        this.sortColumn = null;
    }

    public void remove(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.release(false);
        }
        if (index != this.itemCount - 1) {
            this.fixSelection(index, false);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.removeAll();
        } else {
            int numOfItemsRemoved = end - start + 1;
            int i = start;
            while (i <= end) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.release(false);
                }
                ++i;
            }
            int[] selection = this.getSelectionIndices();
            if (selection.length != 0) {
                int newCount = 0;
                boolean fix = false;
                int i2 = 0;
                while (i2 < selection.length) {
                    if (selection[i2] >= start && selection[i2] <= end) {
                        fix = true;
                    } else {
                        int newIndex = newCount++;
                        selection[newIndex] = selection[i2];
                        if (selection[newIndex] > end) {
                            int n = newIndex;
                            selection[n] = selection[n] - numOfItemsRemoved;
                            fix = true;
                        }
                    }
                    ++i2;
                }
                if (fix) {
                    this.select(selection, newCount, true);
                }
            }
            System.arraycopy(this.items, start + numOfItemsRemoved, this.items, start, this.itemCount - (start + numOfItemsRemoved));
            int i3 = this.itemCount - numOfItemsRemoved;
            while (i3 < this.itemCount) {
                this.items[i3] = null;
                ++i3;
            }
            this.itemCount -= numOfItemsRemoved;
            this.updateRowCount();
        }
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (index != last) {
                TableItem item = this.items[index];
                if (item != null) {
                    item.release(false);
                }
                if (index != this.itemCount - 1) {
                    this.fixSelection(index, false);
                }
                System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
                this.items[this.itemCount] = null;
                last = index;
            }
            ++i;
        }
        this.updateRowCount();
        if (this.itemCount == 0) {
            this.setTableEmpty();
        }
    }

    public void removeAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.setTableEmpty();
        this.updateRowCount();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (!column.isDisposed()) {
                    column.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    @Override
    void scrollClipViewToPoint(long id2, long sel, long clipView, NSPoint point) {
        if (this.shouldScroll) {
            super.scrollClipViewToPoint(id2, sel, clipView, point);
            if ((this.style & 0x20) != 0 && this.columnCount > 0 && ((NSTableView)this.view).headerView() != null && point.x <= (double)this.getCheckColumnWidth()) {
                this.headerView.setNeedsDisplayInRect(this.headerView.headerRectOfColumn(1L));
            }
        }
    }

    public void select(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndex(index);
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.selectRowIndexes(set, (this.style & 2) != 0);
            this.ignoreSelect = false;
            set.release();
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.selectAll();
        } else {
            start = Math.max(0, start);
            end = Math.min(end, this.itemCount - 1);
            NSRange range = new NSRange();
            range.location = start;
            range.length = end - start + 1;
            NSIndexSet set = (NSIndexSet)new NSIndexSet().alloc();
            set = set.initWithIndexesInRange(range);
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.selectRowIndexes(set, (this.style & 2) != 0);
            this.ignoreSelect = false;
            set.release();
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int count = 0;
        NSMutableIndexSet set = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < this.itemCount) {
                set.addIndex(indices[i]);
                ++count;
            }
            ++i;
        }
        if (count > 0) {
            NSTableView widget = (NSTableView)this.view;
            this.ignoreSelect = true;
            widget.selectRowIndexes(set, (this.style & 2) != 0);
            this.ignoreSelect = false;
        }
        set.release();
    }

    void select(int[] indices, int count, boolean clear) {
        NSMutableIndexSet set = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int i = 0;
        while (i < count) {
            set.addIndex(indices[i]);
            ++i;
        }
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        widget.selectRowIndexes(set, !clear);
        this.ignoreSelect = false;
        set.release();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        NSTableView widget = (NSTableView)this.view;
        this.ignoreSelect = true;
        widget.selectAll(null);
        this.ignoreSelect = false;
    }

    @Override
    void setBackgroundColor(NSColor nsColor) {
        ((NSTableView)this.view).setBackgroundColor(nsColor);
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = this.getColumnOrder();
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(5);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (order[i] != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            TableColumn column;
            NSTableView tableView = (NSTableView)this.view;
            int[] oldX = new int[oldOrder.length];
            int check = (this.style & 0x20) != 0 ? 1 : 0;
            int i2 = 0;
            while (i2 < oldOrder.length) {
                int index = oldOrder[i2];
                oldX[index] = (int)tableView.rectOfColumn((long)((long)(i2 + check))).x;
                ++i2;
            }
            int[] newX = new int[order.length];
            int i3 = 0;
            while (i3 < order.length) {
                int index = order[i3];
                column = this.columns[index];
                int oldIndex = this.indexOf(column.nsColumn);
                int newIndex = i3 + check;
                tableView.moveColumn(oldIndex, newIndex);
                newX[index] = (int)tableView.rectOfColumn((long)((long)newIndex)).x;
                ++i3;
            }
            TableColumn[] newColumns = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            int i4 = 0;
            while (i4 < this.columnCount) {
                column = newColumns[i4];
                if (!column.isDisposed() && newX[i4] != oldX[i4]) {
                    column.sendEvent(10);
                }
                ++i4;
            }
        }
    }

    @Override
    void setFont(NSFont font) {
        super.setFont(font);
        int i = 0;
        while (i < this.columnCount) {
            this.columns[i].nsColumn.headerCell().setFont(font);
            ++i;
        }
        this.setItemHeight(null, font, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth(this.items, true);
    }

    public void setHeaderBackground(Color color) {
        double[] headerBackground;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray = headerBackground = color != null ? color.handle : null;
        if (this.equals(headerBackground, this.headerBackground)) {
            return;
        }
        this.headerBackground = headerBackground;
        if (this.getHeaderVisible()) {
            this.redrawWidget(this.view, false);
        }
    }

    public void setHeaderForeground(Color color) {
        double[] headerForeground;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        double[] dArray = headerForeground = color != null ? color.handle : null;
        if (this.equals(headerForeground, this.headerForeground)) {
            return;
        }
        this.headerForeground = headerForeground;
        if (this.getHeaderVisible()) {
            this.redrawWidget(this.view, false);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        ((NSTableView)this.view).setHeaderView(show ? this.headerView : null);
        this.scrollView.tile();
    }

    @Override
    void setImage(long id2, long sel, long arg0) {
        OS.object_setInstanceVariable(id2, Display.SWT_IMAGE, arg0);
    }

    public void setItemCount(int count) {
        this.checkWidget();
        count = Math.max(0, count);
        if (count == this.itemCount) {
            return;
        }
        TableItem[] children = this.items;
        if (count < this.itemCount) {
            int index = count;
            while (index < this.itemCount) {
                TableItem item = children[index];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++index;
            }
        }
        if (count > this.itemCount && (this.getStyle() & 0x10000000) == 0) {
            int i = this.itemCount;
            while (i < count) {
                new TableItem(this, 0, i, true);
                ++i;
            }
            return;
        }
        int length = Math.max(4, (count + 3) / 4 * 4);
        TableItem[] newItems = new TableItem[length];
        if (children != null) {
            System.arraycopy(this.items, 0, newItems, 0, Math.min(count, this.itemCount));
        }
        children = newItems;
        this.items = newItems;
        this.itemCount = count;
        this.updateRowCount();
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
        if (itemHeight != -1) {
            ((NSTableView)this.view).setRowHeight(itemHeight);
        }
    }

    void setItemHeight(Image image, NSFont font, boolean set) {
        Rectangle bounds;
        if (font == null) {
            font = this.getFont().handle;
        }
        double ascent = font.ascender();
        double descent = -font.descender() + font.leading();
        int height = (int)Math.ceil(ascent + descent) + 1;
        Rectangle rectangle = bounds = image != null ? image.getBounds() : this.imageBounds;
        if (bounds != null) {
            this.imageBounds = bounds;
            height = Math.max(height, bounds.height);
        }
        NSTableView widget = (NSTableView)this.view;
        if (set || widget.rowHeight() < (double)height) {
            widget.setRowHeight(height);
            if (this.headerView != null) {
                NSRect frame = this.headerView.frame();
                frame.height = height;
                this.headerView.setFrame(frame);
            }
        }
    }

    @Override
    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            if (this.items.length > 4 && this.items.length - this.itemCount > 3) {
                int length = Math.max(4, (this.itemCount + 3) / 4 * 4);
                TableItem[] newItems = new TableItem[length];
                System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
                this.items = newItems;
            }
            this.setScrollWidth();
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        ((NSTableView)this.view).setUsesAlternatingRowBackgroundColors(show);
        ((NSTableView)this.view).setGridStyleMask(show ? 1 : 0);
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(this.items, true);
    }

    boolean setScrollWidth(TableItem item) {
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            if (this.currentItem != item) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        GC gc = new GC(this);
        int newWidth = item.calculateWidth(0, gc, this.isSelected(this.indexOf(item)));
        gc.dispose();
        int oldWidth = (int)this.firstColumn.width();
        if (oldWidth < newWidth) {
            this.firstColumn.setWidth(newWidth);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TableItem[] items, boolean set) {
        int oldWidth;
        if (items == null) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        if (this.currentItem != null) {
            this.fixScrollWidth = true;
            return false;
        }
        GC gc = new GC(this);
        int newWidth = 0;
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item != null) {
                newWidth = Math.max(newWidth, item.calculateWidth(0, gc, this.isSelected(this.indexOf(item))));
            }
            ++i;
        }
        gc.dispose();
        if (!set && (oldWidth = (int)this.firstColumn.width()) >= newWidth) {
            return false;
        }
        this.firstColumn.setWidth(newWidth);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.deselectAll();
        if (index >= 0 && index < this.itemCount) {
            this.select(index);
            this.showIndex(index);
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        this.select(start, end);
        this.showIndex(start);
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
        this.showIndex(indices[0]);
    }

    public void setSelection(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] indices = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = this.indexOf(items[length - i - 1]);
            if (index != -1) {
                indices[count++] = index;
            }
            ++i;
        }
        if (count > 0) {
            this.select(indices);
            this.showIndex(indices[0]);
        }
    }

    @Override
    void setShouldScrollClipView(long id2, long sel, boolean shouldScroll) {
        this.shouldScroll = shouldScroll;
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        this.setSort(column, this.sortDirection);
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        if (direction == this.sortDirection) {
            return;
        }
        this.setSort(this.sortColumn, direction);
    }

    void setSort(TableColumn column, int direction) {
        NSImage image = null;
        NSTableColumn nsColumn = null;
        if (column != null) {
            nsColumn = column.nsColumn;
            if (direction == 1024) {
                image = NSImage.imageNamed(NSString.stringWith("NSDescendingSortIndicator"));
            }
            if (direction == 128) {
                image = NSImage.imageNamed(NSString.stringWith("NSAscendingSortIndicator"));
            }
        }
        NSTableView widget = (NSTableView)this.view;
        if (this.sortColumn != null && this.sortColumn != column) {
            widget.setIndicatorImage(null, this.sortColumn.nsColumn);
        }
        widget.setHighlightedTableColumn(nsColumn);
        widget.setIndicatorImage(image, nsColumn);
        this.sortDirection = direction;
        this.sortColumn = column;
    }

    void setTableEmpty() {
        this.itemCount = 0;
        this.items = new TableItem[4];
        this.imageBounds = null;
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        NSTableView widget = (NSTableView)this.view;
        int row = Math.max(0, Math.min(index, this.itemCount));
        NSPoint pt = new NSPoint();
        pt.x = this.scrollView.contentView().bounds().x;
        pt.y = widget.frameOfCellAtColumn((long)0L, (long)((long)row)).y;
        if (OS.VERSION >= OS.VERSION(10, 11, 0) && widget.headerView() != null) {
            NSRect headerRect = this.headerView.frame();
            pt.y -= headerRect.y + headerRect.height;
        }
        this.view.scrollPoint(pt);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int index = this.indexOf(column.nsColumn);
        if (index < 0 || index >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSTableView)this.view).scrollColumnToVisible(index);
    }

    void showIndex(int index) {
        if (index >= 0 && index < this.itemCount) {
            ((NSTableView)this.view).scrollRowToVisible(index);
        }
    }

    public void showItem(TableItem item) {
        int index;
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((index = this.indexOf(item)) != -1) {
            this.showIndex(index);
        }
    }

    public void showSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index >= 0) {
            this.checkData(this._getItem(index));
            this.showIndex(index);
        }
    }

    @Override
    void selectRowIndexes_byExtendingSelection(long id2, long sel, long indexes, boolean extend) {
        NSIndexSet set;
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && (set = new NSIndexSet(indexes)).count() == 0L) {
            return;
        }
        super.selectRowIndexes_byExtendingSelection(id2, sel, indexes, extend);
    }

    @Override
    void sendDoubleSelection() {
        NSTableView tableView = (NSTableView)this.view;
        int rowIndex = (int)tableView.clickedRow();
        if (rowIndex == -1) {
            rowIndex = (int)tableView.selectedRow();
        }
        if (rowIndex != -1) {
            if ((this.style & 0x20) != 0) {
                NSArray columns = tableView.tableColumns();
                int columnIndex = (int)tableView.clickedColumn();
                if (columnIndex != -1) {
                    id column = columns.objectAtIndex(columnIndex);
                    if (column.id == this.checkColumn.id) {
                        return;
                    }
                }
            }
            Event event = new Event();
            event.item = this._getItem(rowIndex);
            this.sendSelectionEvent(14, event, false);
        }
    }

    @Override
    boolean sendKeyEvent(NSEvent nsEvent, int type) {
        boolean result = super.sendKeyEvent(nsEvent, type);
        if (!result) {
            return result;
        }
        if (type != 1) {
            return result;
        }
        short keyCode = nsEvent.keyCode();
        switch (keyCode) {
            case 36: 
            case 76: {
                this.sendDoubleSelection();
            }
        }
        return result;
    }

    void sendMeasureItem(TableItem item, int columnIndex, NSSize size, boolean isSelected) {
        NSTableView widget = (NSTableView)this.view;
        int contentWidth = (int)Math.ceil(size.width);
        NSSize spacing = widget.intercellSpacing();
        int itemHeight = (int)Math.ceil(widget.rowHeight() + spacing.height);
        GCData data = new GCData();
        data.paintRect = widget.frame();
        GC gc = GC.cocoa_new(this, data);
        gc.setFont(item.getFont(columnIndex));
        Event event = new Event();
        event.item = item;
        event.gc = gc;
        event.index = columnIndex;
        event.width = contentWidth;
        event.height = itemHeight;
        if (isSelected && ((this.style & 0x8000) == 0 || this.hasFocus())) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        gc.dispose();
        if (!this.isDisposed() && !item.isDisposed()) {
            size.width = event.width;
            size.height = event.height;
            if (itemHeight < event.height) {
                widget.setRowHeight(event.height);
            }
            if (contentWidth != event.width && this.columnCount == 0 && columnIndex == 0) {
                item.width = event.width;
                if (this.setScrollWidth(item)) {
                    widget.setNeedsDisplay(true);
                }
            }
        }
    }

    @Override
    void tableViewColumnDidMove(long id2, long sel, long aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSDictionary userInfo = notification.userInfo();
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString("NSOldColumn");
        id nsOldIndex = userInfo.valueForKey(nsstring);
        nsstring.release();
        nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString("NSNewColumn");
        id nsNewIndex = userInfo.valueForKey(nsstring);
        nsstring.release();
        int oldIndex = new NSNumber(nsOldIndex).intValue();
        int newIndex = new NSNumber(nsNewIndex).intValue();
        NSTableView tableView = (NSTableView)this.view;
        int startIndex = Math.min(oldIndex, newIndex);
        int endIndex = Math.max(oldIndex, newIndex);
        NSArray nsColumns = tableView.tableColumns();
        int i = startIndex;
        while (i <= endIndex) {
            id columnId = nsColumns.objectAtIndex(i);
            TableColumn column = this.getColumn(columnId);
            if (column != null) {
                column.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++i;
        }
        this.headerView.setNeedsDisplay(true);
    }

    @Override
    void tableViewColumnDidResize(long id2, long sel, long aNotification) {
        NSNotification notification = new NSNotification(aNotification);
        NSDictionary userInfo = notification.userInfo();
        NSString nsstring = (NSString)new NSString().alloc();
        nsstring = nsstring.initWithString("NSTableColumn");
        id columnId = userInfo.valueForKey(nsstring);
        nsstring.release();
        TableColumn column = this.getColumn(columnId);
        if (column == null) {
            return;
        }
        column.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSTableView tableView = (NSTableView)this.view;
        int index = this.indexOf(column.nsColumn);
        if (index == -1) {
            return;
        }
        NSArray nsColumns = tableView.tableColumns();
        int columnCount = (int)tableView.numberOfColumns();
        int i = index + 1;
        while (i < columnCount) {
            columnId = nsColumns.objectAtIndex(i);
            column = this.getColumn(columnId);
            if (column != null) {
                column.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            ++i;
        }
    }

    @Override
    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        NSTableView widget = (NSTableView)this.view;
        int row = (int)widget.selectedRow();
        if (row == -1) {
            this.sendSelectionEvent(13);
        } else {
            TableItem item = this._getItem(row);
            Event event = new Event();
            event.item = item;
            event.index = row;
            this.sendSelectionEvent(13, event, false);
        }
    }

    @Override
    void tableViewSelectionDidChange(long id2, long sel, long aNotification) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    @Override
    void tableViewSelectionIsChanging(long id2, long sel, long aNotification) {
        this.didSelect = true;
        this.sendSelection();
    }

    @Override
    void tableView_didClickTableColumn(long id2, long sel, long tableView, long tableColumn) {
        TableColumn column = this.getColumn(new id(tableColumn));
        if (column == null) {
            return;
        }
        column.sendSelectionEvent(13);
    }

    @Override
    long tableView_objectValueForTableColumn_row(long id2, long sel, long aTableView, long aTableColumn, long rowIndex) {
        int index = (int)rowIndex;
        TableItem item = this._getItem(index);
        this.checkData(item, index);
        if (this.checkColumn != null && aTableColumn == this.checkColumn.id) {
            NSNumber value = item.checked && item.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(item.checked ? 1 : 0);
            return value.id;
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == aTableColumn) {
                return item.createString((int)i).id;
            }
            ++i;
        }
        return item.createString((int)0).id;
    }

    @Override
    boolean tableView_shouldReorderColumn_toColumn(long id2, long sel, long aTableView, long currentColIndex, long newColIndex) {
        if ((this.style & 0x20) != 0) {
            if (currentColIndex == 0L) {
                return false;
            }
            if (newColIndex == 0L) {
                return false;
            }
        }
        NSTableView widget = new NSTableView(aTableView);
        id nsColumn = widget.tableColumns().objectAtIndex(currentColIndex);
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == nsColumn.id) {
                return this.columns[i].movable;
            }
            ++i;
        }
        return true;
    }

    @Override
    boolean tableView_shouldTrackCell_forTableColumn_row(long id2, long sel, long table, long cell, long tableColumn, long rowIndex) {
        if ((this.style & 0x20) != 0 && new NSCell(cell).isKindOfClass(OS.class_NSButtonCell)) {
            return true;
        }
        NSTableView widget = (NSTableView)this.view;
        return widget.isRowSelected(rowIndex);
    }

    @Override
    void tableView_setObjectValue_forTableColumn_row(long id2, long sel, long aTableView, long anObject, long aTableColumn, long rowIndex) {
        if (this.checkColumn != null && aTableColumn == this.checkColumn.id) {
            TableItem item = this.items[(int)rowIndex];
            item.checked = !item.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = item;
            event.index = (int)rowIndex;
            this.sendSelectionEvent(13, event, false);
            item.redraw(-1);
        }
    }

    @Override
    void tableView_willDisplayCell_forTableColumn_row(long id2, long sel, long aTableView, long cell, long tableColumn, long rowIndex) {
        Font font;
        NSColor color;
        if (this.checkColumn != null && tableColumn == this.checkColumn.id) {
            return;
        }
        TableItem item = this.items[(int)rowIndex];
        int index = 0;
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i].nsColumn.id == tableColumn) {
                index = i;
                break;
            }
            ++i;
        }
        NSTextFieldCell textCell = new NSTextFieldCell(cell);
        OS.object_setInstanceVariable(cell, Display.SWT_ROW, rowIndex);
        OS.object_setInstanceVariable(cell, Display.SWT_COLUMN, tableColumn);
        Image image = index == 0 ? item.image : (item.images == null ? null : item.images[index]);
        textCell.setImage(image != null ? image.handle : null);
        if (textCell.isEnabled()) {
            if (textCell.isHighlighted()) {
                color = NSColor.selectedControlTextColor();
            } else {
                Color foreground;
                Color color2 = foreground = item.cellForeground != null ? item.cellForeground[index] : null;
                if (foreground == null) {
                    foreground = item.foreground;
                }
                if (foreground == null) {
                    foreground = this.getForegroundColor();
                }
                color = NSColor.colorWithDeviceRed(foreground.handle[0], foreground.handle[1], foreground.handle[2], 1.0);
            }
        } else {
            color = NSColor.disabledControlTextColor();
        }
        int direction = (this.style & 0x4000000) != 0 ? 1 : 0;
        int alignment = 0;
        if (this.columnCount > 0) {
            int style = this.columns[index].style;
            if ((style & 0x1000000) != 0) {
                alignment = 2;
            } else if ((style & 0x20000) != 0) {
                alignment = 1;
            }
        }
        Font font2 = font = item.cellFont != null ? item.cellFont[index] : null;
        if (font == null) {
            font = item.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
            dict.setObject(color, OS.NSForegroundColorAttributeName);
            dict.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(dict, font);
            NSMutableParagraphStyle paragraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            paragraphStyle.setLineBreakMode(2L);
            paragraphStyle.setAlignment(alignment);
            paragraphStyle.setBaseWritingDirection(direction);
            dict.setObject(paragraphStyle, OS.NSParagraphStyleAttributeName);
            paragraphStyle.release();
            NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(textCell.title(), dict);
            textCell.setAttributedStringValue(attribStr);
            attribStr.release();
            dict.release();
        } else {
            textCell.setFont(font.handle);
            textCell.setTextColor(color);
            textCell.setAlignment(alignment);
            textCell.setBaseWritingDirection(direction);
        }
    }

    @Override
    boolean tableView_writeRowsWithIndexes_toPasteboard(long id2, long sel, long arg0, long arg1, long arg2) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    @Override
    boolean sendMouseEvent(NSEvent nsEvent, int type, boolean send) {
        if (type == 29) {
            this.dragDetected = true;
        } else if (type == 4) {
            if (!this.dragDetected && this.selectedRowIndex != -1) {
                NSTableView widget = (NSTableView)this.view;
                NSIndexSet selectedRows = widget.selectedRowIndexes();
                int count = (int)selectedRows.count();
                long[] indexBuffer = new long[count];
                selectedRows.getIndexes(indexBuffer, count, 0L);
                int i = 0;
                while (i < count) {
                    if (indexBuffer[i] != (long)this.selectedRowIndex) {
                        this.ignoreSelect = true;
                        widget.deselectRow(indexBuffer[i]);
                        this.ignoreSelect = false;
                    }
                    ++i;
                }
                Event event = new Event();
                event.item = this._getItem(this.selectedRowIndex);
                this.selectedRowIndex = -1;
                this.sendSelectionEvent(13, event, false);
                this.ignoreSelect = true;
            }
            this.dragDetected = false;
        }
        return super.sendMouseEvent(nsEvent, type, send);
    }

    @Override
    NSRect titleRectForBounds(long id2, long sel, NSRect cellFrame) {
        NSImage image = new NSCell(id2).image();
        if (image != null) {
            int imageWidth = this.imageBounds.width + 3;
            cellFrame.x += (double)imageWidth;
            cellFrame.width -= (double)imageWidth;
        }
        return cellFrame;
    }

    @Override
    void updateCursorRects(boolean enabled) {
        super.updateCursorRects(enabled);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(enabled, this.headerView);
    }

    void updateRowCount() {
        NSTableView widget = (NSTableView)this.view;
        this.setRedraw(false);
        this.ignoreSelect = true;
        widget.noteNumberOfRowsChanged();
        this.ignoreSelect = false;
        widget.tile();
        this.setRedraw(true);
    }
}

