/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.AbstractJavaWizardPage;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.hamcrest.Matcher;

public class NewInterfaceCreationWizardPage
extends AbstractJavaWizardPage {
    public NewInterfaceCreationWizardPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public void addExtendedInterface(String interfaceName) {
        new PushButton("Add...").click();
        new DefaultShell("Extended Interfaces Selection");
        new DefaultText(0, new Matcher[0]).setText(interfaceName);
        switch (new DefaultTable(0, new Matcher[0]).getItems().size()) {
            case 0: {
                throw new RedDeerException("No item was found for given interface name '" + interfaceName + "'.");
            }
            case 1: {
                new PushButton("OK").click();
                break;
            }
            default: {
                throw new RedDeerException("More than 1 item was found for given interface name '" + interfaceName + "'.");
            }
        }
    }

    public void removeExtendedInterface(String interfaceName) {
        DefaultTable table = new DefaultTable(0, new Matcher[0]);
        table.getItem(interfaceName).select();
        new PushButton("Remove").click();
    }

    public ArrayList<String> getExtendedInterfaces() {
        DefaultTable table = new DefaultTable(0, new Matcher[0]);
        List tableItems = table.getItems();
        ArrayList<String> tableItemNames = new ArrayList<String>();
        for (TableItem item : tableItems) {
            tableItemNames.add(item.getText());
        }
        return tableItemNames;
    }
}

