/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.FieldValueHitQueue;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MultiLeafFieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FutureObjects;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class TopFieldCollector
extends TopDocsCollector<FieldValueHitQueue.Entry> {
    private static final ScoreDoc[] EMPTY_SCOREDOCS = new ScoreDoc[0];
    final int numHits;
    final int totalHitsThreshold;
    final FieldComparator.RelevanceComparator firstComparator;
    final boolean canSetMinScore;
    final int numComparators;
    FieldValueHitQueue.Entry bottom = null;
    boolean queueFull;
    int docBase;
    final boolean needsScores;
    final ScoreMode scoreMode;

    static boolean canEarlyTerminate(Sort searchSort, Sort indexSort) {
        return TopFieldCollector.canEarlyTerminateOnDocId(searchSort) || TopFieldCollector.canEarlyTerminateOnPrefix(searchSort, indexSort);
    }

    private static boolean canEarlyTerminateOnDocId(Sort searchSort) {
        SortField[] fields1 = searchSort.getSort();
        return SortField.FIELD_DOC.equals(fields1[0]);
    }

    private static boolean canEarlyTerminateOnPrefix(Sort searchSort, Sort indexSort) {
        if (indexSort != null) {
            SortField[] fields2;
            SortField[] fields1 = searchSort.getSort();
            if (fields1.length > (fields2 = indexSort.getSort()).length) {
                return false;
            }
            return Arrays.asList(fields1).equals(Arrays.asList(fields2).subList(0, fields1.length));
        }
        return false;
    }

    private TopFieldCollector(FieldValueHitQueue<FieldValueHitQueue.Entry> pq, int numHits, int totalHitsThreshold, boolean needsScores) {
        super(pq);
        this.needsScores = needsScores;
        this.numHits = numHits;
        this.totalHitsThreshold = totalHitsThreshold;
        this.numComparators = pq.getComparators().length;
        FieldComparator<?> fieldComparator = pq.getComparators()[0];
        int reverseMul = pq.reverseMul[0];
        if (fieldComparator.getClass().equals(FieldComparator.RelevanceComparator.class) && reverseMul == 1 && totalHitsThreshold != Integer.MAX_VALUE) {
            this.firstComparator = (FieldComparator.RelevanceComparator)fieldComparator;
            this.scoreMode = ScoreMode.TOP_SCORES;
            this.canSetMinScore = true;
        } else {
            this.firstComparator = null;
            this.scoreMode = needsScores ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
            this.canSetMinScore = false;
        }
    }

    @Override
    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    protected void updateMinCompetitiveScore(Scorable scorer) throws IOException {
        if (this.canSetMinScore && this.totalHits > this.totalHitsThreshold && this.queueFull) {
            assert (this.bottom != null && this.firstComparator != null);
            float minScore = this.firstComparator.value(this.bottom.slot).floatValue();
            scorer.setMinCompetitiveScore(minScore);
            this.totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
        }
    }

    public static TopFieldCollector create(Sort sort, int numHits, int totalHitsThreshold) {
        return TopFieldCollector.create(sort, numHits, null, totalHitsThreshold);
    }

    public static TopFieldCollector create(Sort sort, int numHits, FieldDoc after, int totalHitsThreshold) {
        if (sort.fields.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (numHits <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (totalHitsThreshold < 0) {
            throw new IllegalArgumentException("totalHitsThreshold must be >= 0, got " + totalHitsThreshold);
        }
        FieldValueHitQueue<FieldValueHitQueue.Entry> queue = FieldValueHitQueue.create(sort.fields, numHits);
        if (after == null) {
            return new SimpleFieldCollector(sort, queue, numHits, totalHitsThreshold);
        }
        if (after.fields == null) {
            throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
        }
        if (after.fields.length != sort.getSort().length) {
            throw new IllegalArgumentException("after.fields has " + after.fields.length + " values but sort has " + sort.getSort().length);
        }
        return new PagingFieldCollector(sort, queue, after, numHits, totalHitsThreshold);
    }

    public static void populateScores(ScoreDoc[] topDocs, IndexSearcher searcher, Query query) throws IOException {
        topDocs = (ScoreDoc[])topDocs.clone();
        Arrays.sort(topDocs, Comparator.comparingInt(scoreDoc -> scoreDoc.doc));
        Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE, 1.0f);
        List<LeafReaderContext> contexts = searcher.getIndexReader().leaves();
        LeafReaderContext currentContext = null;
        Scorer currentScorer = null;
        for (ScoreDoc scoreDoc2 : topDocs) {
            if (currentContext == null || scoreDoc2.doc >= currentContext.docBase + currentContext.reader().maxDoc()) {
                FutureObjects.checkIndex(scoreDoc2.doc, searcher.getIndexReader().maxDoc());
                int newContextIndex = ReaderUtil.subIndex(scoreDoc2.doc, contexts);
                currentContext = contexts.get(newContextIndex);
                ScorerSupplier scorerSupplier = weight.scorerSupplier(currentContext);
                if (scorerSupplier == null) {
                    throw new IllegalArgumentException("Doc id " + scoreDoc2.doc + " doesn't match the query");
                }
                currentScorer = scorerSupplier.get(1L);
            }
            int leafDoc = scoreDoc2.doc - currentContext.docBase;
            assert (leafDoc >= 0);
            int advanced = currentScorer.iterator().advance(leafDoc);
            if (leafDoc != advanced) {
                throw new IllegalArgumentException("Doc id " + scoreDoc2.doc + " doesn't match the query");
            }
            scoreDoc2.score = currentScorer.score();
        }
    }

    final void add(int slot, int doc) {
        this.bottom = this.pq.add(new FieldValueHitQueue.Entry(slot, this.docBase + doc));
        this.queueFull = this.totalHits == this.numHits;
    }

    final void updateBottom(int doc) {
        this.bottom.doc = this.docBase + doc;
        this.bottom = (FieldValueHitQueue.Entry)this.pq.updateTop();
    }

    @Override
    protected void populateResults(ScoreDoc[] results, int howMany) {
        FieldValueHitQueue queue = (FieldValueHitQueue)this.pq;
        for (int i = howMany - 1; i >= 0; --i) {
            results[i] = queue.fillFields((FieldValueHitQueue.Entry)queue.pop());
        }
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        if (results == null) {
            results = EMPTY_SCOREDOCS;
        }
        return new TopFieldDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results, ((FieldValueHitQueue)this.pq).getFields());
    }

    @Override
    public TopFieldDocs topDocs() {
        return (TopFieldDocs)super.topDocs();
    }

    public boolean isEarlyTerminated() {
        return this.totalHitsRelation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
    }

    private static abstract class MultiComparatorLeafCollector
    implements LeafCollector {
        final LeafFieldComparator comparator;
        final int reverseMul;
        Scorable scorer;

        MultiComparatorLeafCollector(LeafFieldComparator[] comparators, int[] reverseMul) {
            if (comparators.length == 1) {
                this.reverseMul = reverseMul[0];
                this.comparator = comparators[0];
            } else {
                this.reverseMul = 1;
                this.comparator = new MultiLeafFieldComparator(comparators, reverseMul);
            }
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.comparator.setScorer(scorer);
            this.scorer = scorer;
        }
    }

    private static final class PagingFieldCollector
    extends TopFieldCollector {
        final Sort sort;
        int collectedHits;
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;
        final FieldDoc after;
        final int totalHitsThreshold;

        public PagingFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, FieldDoc after, int numHits, int totalHitsThreshold) {
            super(queue, numHits, totalHitsThreshold, sort.needsScores());
            this.sort = sort;
            this.queue = queue;
            this.after = after;
            this.totalHitsThreshold = totalHitsThreshold;
            FieldComparator<?>[] comparators = queue.comparators;
            for (int i = 0; i < comparators.length; ++i) {
                FieldComparator<?> comparator = comparators[i];
                comparator.setTopValue(after.fields[i]);
            }
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            final int afterDoc = this.after.doc - this.docBase;
            Sort indexSort = context.reader().getMetaData().getSort();
            final boolean canEarlyTerminate = PagingFieldCollector.canEarlyTerminate(this.sort, indexSort);
            return new MultiComparatorLeafCollector(this.queue.getComparators(context), this.queue.getReverseMul()){
                boolean collectedAllCompetitiveHits;
                {
                    super(comparators, reverseMul);
                    this.collectedAllCompetitiveHits = false;
                }

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer(scorer);
                    this.updateMinCompetitiveScore(scorer);
                }

                @Override
                public void collect(int doc) throws IOException {
                    ++totalHits;
                    if (queueFull && (this.collectedAllCompetitiveHits || this.reverseMul * this.comparator.compareBottom(doc) <= 0)) {
                        if (canEarlyTerminate) {
                            if (totalHits > totalHitsThreshold) {
                                totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                                throw new CollectionTerminatedException();
                            }
                            this.collectedAllCompetitiveHits = true;
                        } else if (totalHitsRelation == TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO) {
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                        return;
                    }
                    int topCmp = this.reverseMul * this.comparator.compareTop(doc);
                    if (topCmp > 0 || topCmp == 0 && doc <= afterDoc) {
                        return;
                    }
                    if (queueFull) {
                        this.comparator.copy(bottom.slot, doc);
                        this.updateBottom(doc);
                        this.comparator.setBottom(bottom.slot);
                        this.updateMinCompetitiveScore(this.scorer);
                    } else {
                        ++collectedHits;
                        int slot = collectedHits - 1;
                        this.comparator.copy(slot, doc);
                        bottom = pq.add(new FieldValueHitQueue.Entry(slot, docBase + doc));
                        boolean bl = queueFull = collectedHits == numHits;
                        if (queueFull) {
                            this.comparator.setBottom(bottom.slot);
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                    }
                }
            };
        }
    }

    private static class SimpleFieldCollector
    extends TopFieldCollector {
        final Sort sort;
        final FieldValueHitQueue<FieldValueHitQueue.Entry> queue;

        public SimpleFieldCollector(Sort sort, FieldValueHitQueue<FieldValueHitQueue.Entry> queue, int numHits, int totalHitsThreshold) {
            super(queue, numHits, totalHitsThreshold, sort.needsScores());
            this.sort = sort;
            this.queue = queue;
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            this.docBase = context.docBase;
            LeafFieldComparator[] comparators = this.queue.getComparators(context);
            int[] reverseMul = this.queue.getReverseMul();
            Sort indexSort = context.reader().getMetaData().getSort();
            final boolean canEarlyTerminate = SimpleFieldCollector.canEarlyTerminate(this.sort, indexSort);
            return new MultiComparatorLeafCollector(comparators, reverseMul){
                boolean collectedAllCompetitiveHits;
                {
                    super(comparators, reverseMul);
                    this.collectedAllCompetitiveHits = false;
                }

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer(scorer);
                    this.updateMinCompetitiveScore(scorer);
                }

                @Override
                public void collect(int doc) throws IOException {
                    ++totalHits;
                    if (queueFull) {
                        if (this.collectedAllCompetitiveHits || this.reverseMul * this.comparator.compareBottom(doc) <= 0) {
                            if (canEarlyTerminate) {
                                if (totalHits > totalHitsThreshold) {
                                    totalHitsRelation = TotalHits.Relation.GREATER_THAN_OR_EQUAL_TO;
                                    throw new CollectionTerminatedException();
                                }
                                this.collectedAllCompetitiveHits = true;
                            } else if (totalHitsRelation == TotalHits.Relation.EQUAL_TO) {
                                this.updateMinCompetitiveScore(this.scorer);
                            }
                            return;
                        }
                        this.comparator.copy(bottom.slot, doc);
                        this.updateBottom(doc);
                        this.comparator.setBottom(bottom.slot);
                        this.updateMinCompetitiveScore(this.scorer);
                    } else {
                        int slot = totalHits - 1;
                        this.comparator.copy(slot, doc);
                        this.add(slot, doc);
                        if (queueFull) {
                            this.comparator.setBottom(bottom.slot);
                            this.updateMinCompetitiveScore(this.scorer);
                        }
                    }
                }
            };
        }
    }
}

