/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;

public class CheckMissingNaturesListener
implements IResourceChangeListener,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String MARKER_TYPE = String.valueOf(ResourcesPlugin.getPlugin().getBundle().getSymbolicName()) + ".unknownNature";
    public static final String NATURE_ID_ATTRIBUTE = "natureId";

    @Override
    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getDelta() == null) {
            return;
        }
        try {
            HashSet<IProject> modifiedProjects = new HashSet<IProject>();
            event.getDelta().accept(delta -> {
                if (delta.getResource() != null && delta.getResource().getType() == 4 && (delta.getKind() == 1 || delta.getKind() == 4)) {
                    modifiedProjects.add((IProject)delta.getResource());
                }
                return delta.getResource() == null || delta.getResource().getType() == 8;
            });
            this.updateMarkers(modifiedProjects);
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, ResourcesPlugin.getPlugin().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    int getMissingNatureSeverity(IProject project) {
        int severity = 1;
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.core.resources");
        if (node != null) {
            severity = node.getInt("missingNatureMarkerSeverity", 1);
        }
        return severity;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("missingNatureMarkerSeverity".equals(event.getKey())) {
            int oldSeverity;
            int newSeverity = event.getNewValue() != null ? Integer.parseInt((String)event.getNewValue()) : 1;
            int n = oldSeverity = event.getOldValue() != null ? Integer.parseInt((String)event.getOldValue()) : 1;
            if (newSeverity < 0) {
                this.removeAllMarkers(ResourcesPlugin.getWorkspace().getRoot());
            } else if (oldSeverity < 0 && newSeverity >= 0) {
                this.updateMarkers(Arrays.asList(ResourcesPlugin.getWorkspace().getRoot().getProjects()));
            } else {
                this.updateExistingMarkersSeverity(ResourcesPlugin.getWorkspace().getRoot(), newSeverity);
            }
        }
    }

    private void removeAllMarkers(IContainer workspaceRootOrProject) {
        final Collection<IMarker> markers = this.getRelatedMarkers(workspaceRootOrProject);
        if (markers.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(Messages.updateUnknownNatureMarkers){

            @Override
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (IMarker marker : markers) {
                    if (!marker.exists() || !marker.getResource().isAccessible()) continue;
                    marker.delete();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return super.belongsTo(family) || MARKER_TYPE.equals(family);
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(50);
        job.setRule(workspaceRootOrProject);
        job.schedule();
    }

    private void updateExistingMarkersSeverity(IContainer workspaceRootOrProject, final int newSeverity) {
        final Collection<IMarker> markers = this.getRelatedMarkers(workspaceRootOrProject);
        if (markers.isEmpty()) {
            return;
        }
        WorkspaceJob job = new WorkspaceJob(Messages.updateUnknownNatureMarkers){

            @Override
            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (IMarker marker : markers) {
                    if (!marker.exists() || !marker.getResource().isAccessible()) continue;
                    marker.setAttribute("severity", newSeverity);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return super.belongsTo(family) || MARKER_TYPE.equals(family);
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.setPriority(50);
        job.setRule(workspaceRootOrProject);
        job.schedule();
    }

    private void updateMarkers(Collection<IProject> projects) {
        for (final IProject project : projects) {
            if (!project.isAccessible()) continue;
            int severity = this.getMissingNatureSeverity(project);
            try {
                if (severity < 0) {
                    this.removeAllMarkers(project);
                    continue;
                }
                final HashSet<String> missingNatures = new HashSet<String>();
                String[] stringArray = project.getDescription().getNatureIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String natureId = stringArray[n2];
                    if (project.getWorkspace().getNatureDescriptor(natureId) == null) {
                        missingNatures.add(natureId);
                    }
                    ++n2;
                }
                final HashSet<IMarker> toRemove = new HashSet<IMarker>();
                for (IMarker existingMarker : this.getRelatedProjectMarkers(project)) {
                    String markerNature = existingMarker.getAttribute(NATURE_ID_ATTRIBUTE, "");
                    if (!missingNatures.contains(markerNature)) {
                        toRemove.add(existingMarker);
                        continue;
                    }
                    missingNatures.remove(markerNature);
                }
                if (toRemove.isEmpty() && missingNatures.isEmpty()) continue;
                WorkspaceJob workspaceJob = new WorkspaceJob(Messages.updateUnknownNatureMarkers){

                    @Override
                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        for (IMarker marker : toRemove) {
                            marker.delete();
                        }
                        IResource targetResource = project.getFile(".project");
                        if (!targetResource.isAccessible()) {
                            targetResource = project;
                        }
                        for (String natureId : missingNatures) {
                            IMarker marker = targetResource.createMarker(MARKER_TYPE);
                            marker.setAttribute("severity", CheckMissingNaturesListener.this.getMissingNatureSeverity(project));
                            marker.setAttribute("message", NLS.bind((String)Messages.natures_missingNature, (Object)natureId));
                            marker.setAttribute(CheckMissingNaturesListener.NATURE_ID_ATTRIBUTE, natureId);
                            if (targetResource.getType() != 1) continue;
                            CheckMissingNaturesListener.this.updateRange(marker, natureId, (IFile)targetResource);
                        }
                        return Status.OK_STATUS;
                    }

                    public boolean belongsTo(Object family) {
                        return super.belongsTo(family) || MARKER_TYPE.equals(family);
                    }
                };
                workspaceJob.setRule(project);
                workspaceJob.setUser(false);
                workspaceJob.setSystem(true);
                workspaceJob.setPriority(50);
                workspaceJob.schedule();
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.core.resources", e.getMessage(), (Throwable)e));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void updateRange(IMarker marker, String natureId, IFile file) {
        if (!file.isAccessible()) {
            return;
        }
        Pattern pattern = Pattern.compile(".*<nature>\\s*(" + natureId.replace(".", "\\.") + ")\\s*</" + "nature" + ">.*", 32);
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try {
                InputStream input = file.getContents();
                try {
                    try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                        IPath path = file.getLocation();
                        if (path == null) {
                            path = file.getFullPath();
                        }
                        FileUtil.transferStreams(input, output, path.toString(), (IProgressMonitor)new NullProgressMonitor());
                        String content = output.toString();
                        Matcher matcher = pattern.matcher(content);
                        if (matcher.matches() && matcher.groupCount() > 0) {
                            marker.setAttribute("charStart", matcher.start(1));
                            marker.setAttribute("charEnd", matcher.end(1));
                        }
                    }
                    if (input == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (input == null) throw throwable;
                    input.close();
                    throw throwable;
                }
                input.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.core.resources", e.getMessage(), (Throwable)e));
            return;
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.core.resources", e.getMessage(), (Throwable)e));
        }
    }

    protected Collection<IMarker> getRelatedMarkers(IContainer rootOrProject) {
        switch (rootOrProject.getType()) {
            case 8: {
                return this.getRelatedRootMarkers((IWorkspaceRoot)rootOrProject);
            }
            case 4: {
                return this.getRelatedProjectMarkers((IProject)rootOrProject);
            }
        }
        return Collections.emptyList();
    }

    protected Collection<IMarker> getRelatedRootMarkers(IWorkspaceRoot root) {
        if (!root.isAccessible()) {
            return Collections.emptyList();
        }
        HashSet<IMarker> res = new HashSet<IMarker>();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            res.addAll(this.getRelatedProjectMarkers(project));
            ++n2;
        }
        return res;
    }

    protected Collection<IMarker> getRelatedProjectMarkers(IProject project) {
        if (!project.isAccessible()) {
            return Collections.emptyList();
        }
        try {
            return Arrays.asList(project.findMarkers(MARKER_TYPE, true, 1));
        }
        catch (CoreException e) {
            ResourcesPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.core.resources", e.getMessage(), (Throwable)e));
            return Collections.emptyList();
        }
    }
}

