/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.update;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.update.DebugEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.DebugTargetEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.EventHandlerModelProxy;
import org.eclipse.debug.internal.ui.viewers.update.StackFrameEventHandler;
import org.eclipse.debug.internal.ui.viewers.update.ThreadEventHandler;
import org.eclipse.jface.viewers.Viewer;

public class DebugTargetProxy
extends EventHandlerModelProxy {
    private IDebugTarget fDebugTarget;

    public DebugTargetProxy(IDebugTarget target) {
        this.fDebugTarget = target;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        this.fDebugTarget = null;
    }

    @Override
    protected boolean containsEvent(DebugEvent event) {
        IDebugTarget debugTarget;
        Object source = event.getSource();
        if (source instanceof IDebugElement && (debugTarget = ((IDebugElement)source).getDebugTarget()) != null) {
            return debugTarget.equals(this.fDebugTarget);
        }
        return false;
    }

    @Override
    protected DebugEventHandler[] createEventHandlers() {
        ThreadEventHandler threadEventHandler = new ThreadEventHandler(this);
        return new DebugEventHandler[]{new DebugTargetEventHandler(this), threadEventHandler, new StackFrameEventHandler(this, threadEventHandler)};
    }

    @Override
    public void installed(Viewer viewer) {
        IDebugTarget target = this.fDebugTarget;
        if (target != null) {
            ModelDelta delta = this.getNextSuspendedThreadDelta(null, false);
            if (delta == null) {
                try {
                    ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunch launch = target.getLaunch();
                    int launchIndex = this.getLaunchIndex(launch);
                    int targetIndex = this.getTargetIndex(target);
                    delta = new ModelDelta(manager, 0);
                    ModelDelta node = delta.addNode(launch, launchIndex, 0, target.getLaunch().getChildren().length);
                    node = node.addNode(target, targetIndex, 0x300000, target.getThreads().length);
                }
                catch (DebugException debugException) {
                    return;
                }
            }
            this.fireModelChanged(delta);
        }
    }

    protected ModelDelta getNextSuspendedThreadDelta(IThread currentThread, boolean reverse) {
        IDebugTarget target = this.fDebugTarget;
        if (target != null) {
            try {
                IStackFrame frame;
                IThread[] threads = target.getThreads();
                IThread chosen = null;
                int threadIndex = -1;
                boolean takeNext = currentThread == null;
                int startIdx = reverse ? threads.length - 1 : 0;
                int endIdx = reverse ? -1 : threads.length;
                int increment = reverse ? -1 : 1;
                int i = startIdx;
                while (i != endIdx) {
                    IThread thread = threads[i];
                    if (takeNext && thread.isSuspended()) {
                        IBreakpoint[] bps = thread.getBreakpoints();
                        if (bps != null && bps.length > 0) {
                            chosen = thread;
                            threadIndex = i;
                            break;
                        }
                        if (chosen == null) {
                            chosen = thread;
                            threadIndex = i;
                        }
                    }
                    takeNext = takeNext || thread.equals(currentThread);
                    i += increment;
                }
                if (chosen != null && (frame = chosen.getTopStackFrame()) != null) {
                    ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
                    ILaunch launch = target.getLaunch();
                    int launchIndex = this.getLaunchIndex(launch);
                    int targetIndex = this.getTargetIndex(target);
                    int stackFrameIndex = this.getStackFrameIndex(frame);
                    ModelDelta delta = new ModelDelta(manager, 0);
                    ModelDelta node = delta.addNode(launch, launchIndex, 0, target.getLaunch().getChildren().length);
                    node = node.addNode(target, targetIndex, 0, threads.length);
                    node = node.addNode(chosen, threadIndex, 0x100000, chosen.getStackFrames().length);
                    node = node.addNode(frame, stackFrameIndex, 0x200000, 0);
                    return delta;
                }
            }
            catch (DebugException debugException) {}
        }
        return null;
    }

    protected int getLaunchIndex(ILaunch launch) {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        return this.indexOf(manager.getLaunches(), launch);
    }

    protected int getTargetIndex(IDebugTarget target) {
        return this.indexOf(target.getLaunch().getChildren(), target);
    }

    protected int getStackFrameIndex(IStackFrame stackFrame) {
        return 0;
    }
}

