/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.FindInRecentScopeActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class FindInProjectActionDelegate
extends FindInRecentScopeActionDelegate {
    private IEditorPart fEditor = null;

    public FindInProjectActionDelegate() {
        super(SearchMessages.FindInProjectActionDelegate_text);
        this.setActionDefinitionId("org.eclipse.search.ui.performTextSearchProject");
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        IEditorPart editor;
        IWorkbenchPart part;
        this.fEditor = null;
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page != null && (part = page.getActivePart()) instanceof IEditorPart && (editor = (IEditorPart)part).getEditorInput() instanceof IFileEditorInput) {
            this.fEditor = editor;
        }
        action.setEnabled(this.fEditor != null);
    }

    @Override
    public void setActiveEditor(IAction action, IEditorPart editor) {
        this.fEditor = editor != null && editor.getEditorInput() instanceof IFileEditorInput ? editor : null;
        super.setActiveEditor(action, this.fEditor);
    }

    protected IProject getCurrentProject() {
        IEditorInput ei;
        if (this.fEditor != null && (ei = this.fEditor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)ei).getFile().getProject();
        }
        return null;
    }

    @Override
    protected ISearchQuery createQuery(TextSearchQueryProvider provider, String searchForString) throws CoreException {
        IProject proj = this.getCurrentProject();
        if (proj != null) {
            return provider.createQuery(searchForString, new IResource[]{this.getCurrentProject()});
        }
        return provider.createQuery(searchForString);
    }
}

