/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.text.Chain;
import org.eclipse.jdt.internal.ui.text.ChainElement;
import org.eclipse.jdt.internal.ui.text.ChainElementAnalyzer;
import org.eclipse.jdt.internal.ui.text.ChainType;

public class ChainFinder {
    private final List<ChainType> expectedTypes;
    private final List<String> excludedTypes;
    private final IType receiverType;
    private final List<Chain> chains = new LinkedList<Chain>();
    private final Map<IJavaElement, ChainElement> edgeCache = new HashMap<IJavaElement, ChainElement>();
    private final Map<String, List<IJavaElement>> fieldsAndMethodsCache = new HashMap<String, List<IJavaElement>>();
    private final Map<String, Boolean> assignableCache = new HashMap<String, Boolean>();

    public ChainFinder(List<ChainType> expectedTypes, List<String> excludedTypes, IType receiverType) {
        this.expectedTypes = expectedTypes;
        this.excludedTypes = excludedTypes;
        this.receiverType = receiverType;
    }

    public void startChainSearch(List<ChainElement> entrypoints, int maxChains, int minDepth, int maxDepth) {
        for (ChainType expected : this.expectedTypes) {
            if (expected == null || ChainFinder.isFromExcludedType(this.excludedTypes, expected)) continue;
            ChainType expectedType = expected;
            int expectedDimension = 0;
            if (expectedType.getDimension() > 0) {
                expectedDimension = expectedType.getDimension();
            }
            this.searchChainsForExpectedType(expectedType, expectedDimension, entrypoints, maxChains, minDepth, maxDepth);
        }
    }

    private void searchChainsForExpectedType(ChainType expectedType, int expectedDimensions, List<ChainElement> entrypoints, int maxChains, int minDepth, int maxDepth) {
        LinkedList<LinkedList<ChainElement>> incompleteChains = ChainFinder.prepareQueue(entrypoints);
        while (!incompleteChains.isEmpty()) {
            LinkedList<ChainElement> chain = incompleteChains.poll();
            ChainElement edge = chain.getLast();
            if (this.isValidEndOfChain(edge, expectedType, expectedDimensions)) {
                if (chain.size() < minDepth) continue;
                this.chains.add(new Chain(chain, expectedDimensions));
                if (this.chains.size() != maxChains) continue;
                break;
            }
            if (chain.size() >= maxDepth || incompleteChains.size() > 50000) continue;
            this.searchDeeper(chain, incompleteChains, edge.getReturnType());
        }
    }

    public List<Chain> getChains() {
        return this.chains;
    }

    private static LinkedList<LinkedList<ChainElement>> prepareQueue(List<ChainElement> entrypoints) {
        LinkedList<LinkedList<ChainElement>> incompleteChains = new LinkedList<LinkedList<ChainElement>>();
        for (ChainElement entrypoint : entrypoints) {
            LinkedList<ChainElement> chain = new LinkedList<ChainElement>();
            chain.add(entrypoint);
            incompleteChains.add(chain);
        }
        return incompleteChains;
    }

    public static boolean isFromExcludedType(List<String> excluded, IJavaElement element) {
        if (element instanceof IType) {
            return excluded.contains(((IType)element).getFullyQualifiedName());
        }
        return excluded.contains(element.getElementName());
    }

    public static boolean isFromExcludedType(List<String> excluded, ChainType element) {
        if (element.getType() != null) {
            return ChainFinder.isFromExcludedType(excluded, (IJavaElement)element.getType());
        }
        return excluded.contains(element.getPrimitiveType());
    }

    private boolean isValidEndOfChain(ChainElement edge, ChainType expectedType, int expectedDimension) {
        if (edge.getElementType() == ChainElement.ElementType.TYPE) {
            return false;
        }
        if (edge.getReturnType().getPrimitiveType() != null) {
            return edge.getReturnType().getPrimitiveType().equals(expectedType.getPrimitiveType());
        }
        if (expectedType.getPrimitiveType() != null) {
            return expectedType.getPrimitiveType().equals(edge.getReturnType().getPrimitiveType());
        }
        Boolean isAssignable = this.assignableCache.get(String.valueOf(edge.toString()) + expectedType.toString());
        if (isAssignable == null) {
            isAssignable = ChainElementAnalyzer.isAssignable(edge, expectedType.getType(), expectedDimension);
            this.assignableCache.put(String.valueOf(edge.toString()) + expectedType.toString(), isAssignable);
        }
        return isAssignable;
    }

    private void searchDeeper(LinkedList<ChainElement> chain, List<LinkedList<ChainElement>> incompleteChains, ChainType currentlyVisitedType) {
        boolean staticOnly = false;
        if (chain.getLast().getElementType() == ChainElement.ElementType.TYPE) {
            staticOnly = true;
        }
        for (IJavaElement element : this.findAllFieldsAndMethods(currentlyVisitedType, staticOnly)) {
            ChainElement newEdge = this.createEdge(element);
            if (chain.contains(newEdge)) continue;
            incompleteChains.add(ChainFinder.cloneChainAndAppendEdge(chain, newEdge));
        }
    }

    private List<IJavaElement> findAllFieldsAndMethods(ChainType chainElementType, boolean staticOnly) {
        List<IJavaElement> cached = this.fieldsAndMethodsCache.get(String.valueOf(chainElementType.toString()) + Boolean.toString(staticOnly));
        if (cached == null) {
            cached = new LinkedList<IJavaElement>();
            Collection<IJavaElement> candidates = staticOnly ? ChainElementAnalyzer.findAllPublicStaticFieldsAndNonVoidNonPrimitiveStaticMethods(chainElementType, new ChainType(this.receiverType)) : ChainElementAnalyzer.findVisibleInstanceFieldsAndRelevantInstanceMethods(chainElementType, new ChainType(this.receiverType));
            for (IJavaElement e : candidates) {
                if (ChainFinder.isFromExcludedType(this.excludedTypes, e)) continue;
                cached.add(e);
            }
            this.fieldsAndMethodsCache.put(String.valueOf(chainElementType.toString()) + Boolean.toString(staticOnly), cached);
        }
        return cached;
    }

    private ChainElement createEdge(IJavaElement member) {
        ChainElement cached = this.edgeCache.get(member);
        if (cached == null) {
            cached = new ChainElement(member, false);
            this.edgeCache.put(member, cached);
        }
        return cached;
    }

    private static LinkedList<ChainElement> cloneChainAndAppendEdge(LinkedList<ChainElement> chain, ChainElement newEdge) {
        LinkedList chainCopy = (LinkedList)chain.clone();
        chainCopy.add(newEdge);
        return chainCopy;
    }
}

