/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.builder;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MethodBuilder
implements Comparable<MethodBuilder> {
    private static final String SPACE = " ";
    private static final String COMMA = ",";
    private static final String TAB = "\t";
    private static final String NEW_LINE = "\n";
    private String name = "foo";
    private String visibility = "public";
    private String returnType = "void";
    private String type = "";
    private String rule = "";
    private List<String> parameters = new ArrayList<String>();
    private List<String> commands = new ArrayList<String>();

    public static MethodBuilder method() {
        return new MethodBuilder();
    }

    public static MethodBuilder constructor(String name) {
        return new MethodBuilder().returnType("").name(name);
    }

    public MethodBuilder visibility(String visibility) {
        this.visibility = visibility;
        return this;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public MethodBuilder returnType(String type) {
        this.returnType = type;
        return this;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public MethodBuilder rule(String rule) {
        this.rule = rule;
        return this;
    }

    public String getRule() {
        return this.rule;
    }

    public MethodBuilder type(String type) {
        this.type = type;
        return this;
    }

    public String getMethodType() {
        return this.type;
    }

    public MethodBuilder name(String name) {
        this.name = this.methodNameMask(name).replaceAll("\\W", "");
        return this;
    }

    public MethodBuilder get(String name) {
        return this.name("get " + name);
    }

    public MethodBuilder set(String name) {
        return this.name("set " + name);
    }

    public MethodBuilder parameter(String parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public MethodBuilder command(String command) {
        if (!command.endsWith(";")) {
            command = String.valueOf(command) + ";";
        }
        this.commands.add(command);
        return this;
    }

    public MethodBuilder returnCommand(String command) {
        return this.command("return " + command);
    }

    public String getName() {
        return this.name;
    }

    private String methodNameMask(String name) {
        String[] words = name.replaceAll("[\\d\\'\\+\\-\\:\\;\\(\\)\\[\\]\\{\\}\\~\\^\\*\\&\\#\\@\\$\\<\\>\\,\\_\\.\\\"]", "").split(SPACE);
        String forReturn = words[0];
        int i = 1;
        while (i < words.length) {
            if (!words[i].isEmpty()) {
                forReturn = Character.isDigit(words[i].charAt(0)) ? String.valueOf(forReturn) + words[i] : String.valueOf(forReturn) + words[i].replaceFirst(String.valueOf(words[i].charAt(0)), String.valueOf(words[i].charAt(0)).toUpperCase());
            }
            ++i;
        }
        return forReturn;
    }

    public String toString() {
        StringBuffer code = new StringBuffer();
        if (this.returnType.isEmpty()) {
            code.append(TAB).append(this.visibility).append(SPACE).append(this.name).append("(");
        } else {
            code.append(TAB).append(this.visibility).append(SPACE).append(this.returnType).append(SPACE).append(this.name).append("(");
        }
        Iterator<String> parameterIterator = this.parameters.iterator();
        while (parameterIterator.hasNext()) {
            code.append(parameterIterator.next());
            if (!parameterIterator.hasNext()) continue;
            code.append(COMMA).append(SPACE);
        }
        code.append(")").append(SPACE).append("{").append(NEW_LINE);
        for (String command : this.commands) {
            code.append(TAB).append(TAB).append(command).append(NEW_LINE);
        }
        code.append(TAB).append("}");
        return code.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodBuilder other = (MethodBuilder)obj;
        if (this.commands == null) {
            if (other.commands != null) {
                return false;
            }
        } else if (this.commands.equals(other.commands)) {
            return true;
        }
        return this.name == other.name;
    }

    @Override
    public int compareTo(MethodBuilder o) {
        if (this.name.charAt(0) < o.name.charAt(0)) {
            return -1;
        }
        if (this.name.charAt(0) > o.name.charAt(0)) {
            return 1;
        }
        return 0;
    }
}

