/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.rules.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.reddeer.codegen.CodeGen;
import org.eclipse.reddeer.codegen.builder.MethodBuilder;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.ComboRule;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ComboCodeGenRule
extends ComboRule
implements CodeGen {
    private Event event;
    private List<String> forReturn = new ArrayList<String>();

    public boolean appliesTo(Event ev) {
        this.event = ev;
        this.event.type = 24;
        if (this.event.widget instanceof Combo) {
            try {
                return !WidgetUtils.cleanText((String)WidgetUtils.getLabel((Control)((Combo)this.event.widget))).isEmpty();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    @Override
    public MethodBuilder constructor(Control control) {
        String type = "LabeledCombo";
        String label = this.getLabel();
        if (label == null || label.isEmpty()) {
            type = "DefaultCombo";
            label = String.valueOf(this.getIndex());
        } else {
            label = "\"" + label + "\"";
        }
        String ref = RedDeerUtils.getReferencedCompositeString((List)this.getComposites());
        return MethodBuilder.method().returnType(type).get(String.valueOf(label) + "CMB").returnCommand("new " + type + "(" + ref + WidgetUtils.cleanText((String)label) + ")").type("Getter").rule("CMB");
    }

    @Override
    public MethodBuilder get(Control control) {
        String label = this.getLabel();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        return MethodBuilder.method().returnType("String").get("Text " + label).returnCommand(this.getCommand("get")).type("Getter").rule("CMB");
    }

    public MethodBuilder getSelection(Control control) {
        String label = this.getLabel();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        return MethodBuilder.method().returnType("String").get("Selection" + label).returnCommand(this.getCommand("getSelection")).type("Getter").rule("CMB");
    }

    public MethodBuilder getItems(Control control) {
        String label = this.getLabel();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        return MethodBuilder.method().returnType("List<String>").get("Items" + label).returnCommand(this.getCommand("items")).type("Getter").rule("CMB");
    }

    public MethodBuilder setSelection(Control control) {
        String label = this.getLabel();
        label = label == null || label.isEmpty() ? String.valueOf(this.getIndex()) : "\"" + label + "\"";
        return MethodBuilder.method().name("setSelection " + label).parameter("String str").command(this.getCommand("setSelection")).type("Setter").rule("CMB");
    }

    public Map<String, String> getSelectionList(Control control) {
        Combo combo = (Combo)control;
        TreeMap<String, String> items = new TreeMap<String, String>();
        if (combo.getItemCount() > 0) {
            String[] stringArray = combo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                String key = this.constantMask(WidgetUtils.cleanText((String)item).toUpperCase().replaceAll("\\W", " "));
                items.put(key, item);
                ++n2;
            }
            return items;
        }
        return null;
    }

    public List<String> getImports() {
        this.forReturn = super.getImports();
        this.forReturn.add("java.util.List");
        return this.forReturn;
    }

    @Override
    public List<MethodBuilder> getActionMethods(Control control) {
        ArrayList<MethodBuilder> forReturn = new ArrayList<MethodBuilder>();
        forReturn.add(this.constructor(control));
        forReturn.add(this.get(control));
        forReturn.add(this.getSelection(control));
        forReturn.add(this.getItems(control));
        forReturn.add(this.setSelection(control));
        return forReturn;
    }

    public String getCommand(String type) {
        StringBuffer sb = new StringBuffer();
        String label = this.getLabel();
        if (label != null) {
            sb.append("new LabeledCombo(");
            sb.append(RedDeerUtils.getReferencedCompositeString((List)this.getComposites()));
            sb.append("\"" + WidgetUtils.cleanText((String)label) + "\"");
        } else {
            sb.append("new DefaultCombo(");
            sb.append(RedDeerUtils.getReferencedCompositeString((List)this.getComposites()));
            sb.append(this.getIndex());
        }
        if (type.equals("setSelection")) {
            sb.append(").setSelection(str)");
        } else if (type.equals("get")) {
            sb.append(").getText()");
        } else if (type.equals("getSelection")) {
            sb.append(").getSelection()");
        } else if (type.equals("items")) {
            sb.append(").getItems()");
        }
        return sb.toString();
    }

    private String constantMask(String str) {
        ArrayList<String> list = new ArrayList<String>();
        String group = "";
        try {
            group = WidgetUtils.getGroup((Control)((Combo)this.event.widget)).replaceAll("\\W", " ");
        }
        catch (Exception exception) {
            group = this.getLabel().replaceAll("\\W", " ");
        }
        String[] s1 = group.split(" ");
        int i = 0;
        while (i < s1.length) {
            if (!s1[i].isEmpty()) {
                list.add(s1[i].trim().toUpperCase());
            }
            ++i;
        }
        String[] s2 = str.split(" ");
        int i2 = 0;
        while (i2 < s2.length) {
            if (!s2[i2].isEmpty()) {
                list.add(s2[i2].trim().toUpperCase());
            }
            ++i2;
        }
        return String.join((CharSequence)"_", list);
    }
}

