/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.test.condition;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.condition.WidgetIsFound;
import org.eclipse.reddeer.core.matcher.ClassMatcher;
import org.eclipse.reddeer.core.test.condition.matchers.TableItemWithRegExpMatcher;
import org.eclipse.reddeer.core.test.condition.shells.TableShell;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WidgetIsFoundTest {
    private TableShell table;

    @Before
    public void setUp() {
        this.table = new TableShell();
    }

    @Test
    public void testSimple() {
        WidgetIsFound isFound = new WidgetIsFound(TableItem.class);
        Assert.assertTrue((boolean)isFound.test());
    }

    @Test
    public void testMatcher() {
        int searchIndex = 3;
        String regExp = "[\\s.]*line " + searchIndex + " in nowhere[\\s.]*";
        WidgetIsFound isFound = new WidgetIsFound(TableItem.class, new Matcher[]{new TableItemWithRegExpMatcher(regExp)});
        Assert.assertTrue((boolean)isFound.test());
    }

    @Test
    public void testParent() {
        for (DefaultTable table : new ArrayList<DefaultTable>(Arrays.asList(new DefaultTable(0, new Matcher[0]), new DefaultTable(1, new Matcher[0]), new DefaultTable(2, new Matcher[0])))) {
            WidgetIsFound isFound = new WidgetIsFound(TableItem.class, table.getControl(), new Matcher[]{new ClassMatcher(TableItem.class)});
            Assert.assertTrue((boolean)isFound.test());
            this.assertFoundInCorrectTable(isFound, table);
        }
    }

    @Test
    public void testIndex() {
        int testedIndex = 0;
        int testMax = 5;
        while (testedIndex < testMax) {
            WidgetIsFound isFound = new WidgetIsFound(TableItem.class, new DefaultShell().getControl(), testedIndex, new Matcher[]{new ClassMatcher(TableItem.class)});
            Assert.assertTrue((boolean)isFound.test());
            this.assertIndexMatch(testedIndex, isFound);
            ++testedIndex;
        }
    }

    @Test
    public void testNotFoundAfterClose() {
        ArrayList<WidgetIsFound> conditions = new ArrayList<WidgetIsFound>();
        int testedIndex = 0;
        int testMax = 5;
        while (testedIndex < testMax) {
            WidgetIsFound isFound = new WidgetIsFound(TableItem.class, new DefaultShell().getControl(), testedIndex, new Matcher[]{new ClassMatcher(TableItem.class)});
            conditions.add(testedIndex, isFound);
            ++testedIndex;
        }
        this.closeTable();
        for (WidgetIsFound condition : conditions) {
            Assert.assertFalse((boolean)condition.test());
        }
    }

    @Test
    public void testGetResult() {
        WidgetIsFound isFound = new WidgetIsFound(TableItem.class);
        Assert.assertTrue((boolean)isFound.test());
        Assert.assertThat((Object)isFound.getResult(), (Matcher)CoreMatchers.instanceOf(TableItem.class));
        this.closeTable();
        Assert.assertFalse((boolean)isFound.test());
        Assert.assertNull((Object)isFound.getResult());
    }

    @After
    public void closeTable() {
        if (this.table != null) {
            this.table.close();
            this.table = null;
        }
    }

    private void assertFoundInCorrectTable(WidgetIsFound isFound, DefaultTable table) {
        Table containingTable = this.getParent((TableItem)isFound.getResult());
        int actual = this.getTableStyle(containingTable);
        int expected = this.getTableStyle((Table)table.getSWTWidget());
        Assert.assertEquals((long)expected, (long)actual);
    }

    private Table getParent(TableItem item) {
        return (Table)Display.syncExec(() -> ((TableItem)item).getParent());
    }

    private int getTableStyle(Table table) {
        return (Integer)Display.syncExec(() -> ((Table)table).getStyle());
    }

    private void assertIndexMatch(int expectedIndex, WidgetIsFound isFound) {
        String indexCell = TableShell.getIndexCell((TableItem)isFound.getResult());
        Assert.assertTrue((boolean)indexCell.contains(String.valueOf(expectedIndex)));
    }
}

