/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.direct.test.preferences;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.direct.preferences.Preferences;
import org.eclipse.reddeer.eclipse.m2e.core.ui.preferences.MavenSettingsPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@CleanWorkspaceRequirement.CleanWorkspace
@RunWith(value=RedDeerSuite.class)
public class PreferencesTest {
    public static final String M2E_PLUGIN = "org.eclipse.m2e.core";
    public static final String M2E_USER_SETTINGS = "eclipse.m2.userSettingsFile";

    @Before
    @After
    public void restoreToDefault() {
        Preferences.setDefault((String)M2E_PLUGIN, (String)M2E_USER_SETTINGS);
    }

    @Test
    public void getPreferenceTest() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        MavenSettingsPreferencePage page = new MavenSettingsPreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)page);
        String location = page.getUserSettingsLocation();
        dialog.ok();
        Assert.assertEquals((Object)location, (Object)Preferences.get((String)M2E_PLUGIN, (String)M2E_USER_SETTINGS));
        dialog.open();
        dialog.select((PreferencePage)page);
        String newLocation = location.replaceFirst(".xml", "_new.xml");
        page.setUserSettingsLocation(newLocation);
        dialog.ok();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        Assert.assertEquals((Object)newLocation, (Object)Preferences.get((String)M2E_PLUGIN, (String)M2E_USER_SETTINGS));
    }

    @Test
    public void getNonExistingPreferenceTest() {
        Assert.assertNull((Object)Preferences.get((String)M2E_PLUGIN, (String)"nonExistingKey"));
    }

    @Test
    public void setPreferenceTest() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        MavenSettingsPreferencePage page = new MavenSettingsPreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)page);
        String location = page.getUserSettingsLocation();
        dialog.ok();
        String newLocation = location.replaceFirst(".xml", "_new.xml");
        Preferences.set((String)M2E_PLUGIN, (String)M2E_USER_SETTINGS, (String)newLocation);
        dialog.open();
        dialog.select((PreferencePage)page);
        location = page.getUserSettingsLocation();
        dialog.ok();
        Assert.assertEquals((Object)newLocation, (Object)location);
    }

    @Test
    public void setDefaultPreferenceTest() {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        MavenSettingsPreferencePage page = new MavenSettingsPreferencePage((ReferencedComposite)dialog);
        dialog.open();
        dialog.select((PreferencePage)page);
        String location = page.getUserSettingsLocation();
        page.setUserSettingsLocation(location.replaceFirst(".xml", "_new.xml"));
        dialog.ok();
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.DEFAULT);
        Preferences.setDefault((String)M2E_PLUGIN, (String)M2E_USER_SETTINGS);
        dialog.open();
        dialog.select((PreferencePage)page);
        String newLocation = page.getUserSettingsLocation();
        dialog.ok();
        Assert.assertEquals((Object)newLocation, (Object)location);
    }

    @Test
    public void getDefaultPreferenceTest() {
        String defaultValue = Preferences.getDefault((String)M2E_PLUGIN, (String)M2E_USER_SETTINGS);
        Assert.assertEquals((Object)"/tmp/settings.xml", (Object)defaultValue);
    }
}

