/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.jdt.ui.preferences;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.ClasspathVariablesPreferencePage;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.framework.Bundle;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class ClasspathVariablesPreferencePageTest {
    @Test
    public void getVariables() {
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        preferencesDialog.open();
        ClasspathVariablesPreferencePage classpathVariablesPreferencePage = new ClasspathVariablesPreferencePage((ReferencedComposite)preferencesDialog);
        preferencesDialog.select((PreferencePage)classpathVariablesPreferencePage);
        List variables = classpathVariablesPreferencePage.getVariables();
        preferencesDialog.cancel();
        Assert.assertTrue((String)"Classpath variables caonnot be empty", (!variables.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void addRemoveVariable() {
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        preferencesDialog.open();
        ClasspathVariablesPreferencePage classpathVariablesPreferencePage = new ClasspathVariablesPreferencePage((ReferencedComposite)preferencesDialog);
        preferencesDialog.select((PreferencePage)classpathVariablesPreferencePage);
        String addedVariableLabel = classpathVariablesPreferencePage.addVariable("VN", this.getJarVariableLocation(), true);
        List variables = classpathVariablesPreferencePage.getVariables();
        preferencesDialog.ok();
        Assert.assertTrue((String)("Variables has to contain item:'" + addedVariableLabel + "'"), (boolean)variables.contains(addedVariableLabel));
        preferencesDialog.open();
        preferencesDialog.select((PreferencePage)classpathVariablesPreferencePage);
        classpathVariablesPreferencePage.removeVariable(addedVariableLabel);
        variables = classpathVariablesPreferencePage.getVariables();
        preferencesDialog.ok();
        Assert.assertFalse((String)("Variables should not contain item:'" + addedVariableLabel + "'"), (boolean)variables.contains(addedVariableLabel));
    }

    private String getJarVariableLocation() {
        try {
            File jarFileRoot = new File(FileLocator.resolve((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.reddeer.eclipse.test"), (IPath)new Path("target"), null)).getFile());
            File[] jarFiles = jarFileRoot.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (jarFiles == null || jarFiles.length == 0) {
                jarFiles = new File(jarFileRoot, "plugins").listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
            }
            return jarFiles[0].getAbsolutePath();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

