/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.condition;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.eclipse.condition.BrowserHasURL;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.ui.browser.BrowserEditor;
import org.eclipse.reddeer.eclipse.ui.browser.WebBrowserView;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class BrowserHasURLTest {
    private WebBrowserView browser;
    private BrowserEditor browserEditor;
    private static final String BAD_URL = "https://www.redhat.com/en";
    private static final String URL = "http://www.w3.org/";
    private static final String URL_SECURE = "https://www.w3.org/";
    private static final String REG_EXP_URL = ".*(www.w3.org).*";

    @After
    public void tearDown() {
        if (this.browser != null) {
            this.browser.close();
            this.browser = null;
        }
        if (this.browserEditor != null) {
            this.browserEditor.close();
            this.browserEditor = null;
        }
    }

    public void openBrowserEditor() {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getBrowserSupport().createBrowser(38, null, "browser", "browser").openURL(new URL(BrowserHasURLTest.URL));
                }
                catch (PartInitException pie) {
                    throw new EclipseLayerException("Unable to create browser editor", (Throwable)pie);
                }
                catch (MalformedURLException mue) {
                    throw new EclipseLayerException("URL opening in browser is malformed", (Throwable)mue);
                }
            }
        });
        this.browserEditor = new BrowserEditor("browser");
        this.browserEditor.openPageURL(URL);
    }

    public void openInternalBrowserViaMenu() {
        this.browser = new WebBrowserView();
        this.browser.open();
        this.browser.openPageURL(URL);
    }

    @Test
    public void testBrowserEditor() {
        this.openBrowserEditor();
        BrowserHasURL condition = new BrowserHasURL(this.browserEditor, URL);
        BrowserHasURL conditionSecure = new BrowserHasURL(this.browserEditor, URL_SECURE);
        Assert.assertTrue((String)("Expected URL: http://www.w3.org/ but was: " + this.browserEditor.getPageURL()), (condition.test() || conditionSecure.test() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Browser url and one obtained from getResult are not the same", (URL.equals(condition.getResult()) || URL_SECURE.equals(conditionSecure.getResult()) ? 1 : 0) != 0);
        condition = new BrowserHasURL(this.browserEditor, (Matcher)new RegexMatcher(REG_EXP_URL));
        Assert.assertTrue((boolean)condition.test());
        Assert.assertEquals((String)"Browser url and one obtained from getResult are not the same", (Object)URL, (Object)condition.getResult());
        condition = new BrowserHasURL(this.browserEditor, BAD_URL);
        Assert.assertFalse((boolean)condition.test());
        Assert.assertNotEquals((Object)BAD_URL, (Object)condition.getResult());
        condition = new BrowserHasURL(this.browserEditor, (Matcher)new WithTextMatcher(BAD_URL));
        Assert.assertFalse((boolean)condition.test());
        Assert.assertNotEquals((Object)BAD_URL, (Object)condition.getResult());
    }

    @Test
    public void testWebBrowserView() {
        this.openInternalBrowserViaMenu();
        BrowserHasURL condition = new BrowserHasURL(this.browser, URL);
        BrowserHasURL conditionSecure = new BrowserHasURL(this.browserEditor, URL_SECURE);
        Assert.assertTrue((String)("Expected URL:http://www.w3.org/ but was: " + this.browser.getPageURL()), (condition.test() || conditionSecure.test() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Browser url and one obtained from getResult are not the same", (URL.equals(condition.getResult()) || URL_SECURE.equals(conditionSecure.getResult()) ? 1 : 0) != 0);
        condition = new BrowserHasURL(this.browser, (Matcher)new RegexMatcher(REG_EXP_URL));
        Assert.assertTrue((boolean)condition.test());
        Assert.assertEquals((String)"Browser url and one obtained from getResult are not the same", (Object)URL, (Object)condition.getResult());
        condition = new BrowserHasURL(this.browser, BAD_URL);
        Assert.assertFalse((boolean)condition.test());
        Assert.assertNotEquals((Object)BAD_URL, (Object)condition.getResult());
        condition = new BrowserHasURL(this.browser, (Matcher)new WithTextMatcher(BAD_URL));
        Assert.assertFalse((boolean)condition.test());
        Assert.assertNotEquals((Object)BAD_URL, (Object)condition.getResult());
    }
}

