/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.datatools.ui;

import java.io.File;
import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.dialogs.DriverDialog;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.dse.views.DataSourceExplorerView;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.preferences.DriverPreferences;
import org.eclipse.reddeer.eclipse.datatools.connectivity.ui.wizards.NewCPWizard;
import org.eclipse.reddeer.eclipse.datatools.ui.DatabaseProfile;
import org.eclipse.reddeer.eclipse.datatools.ui.DriverDefinition;
import org.eclipse.reddeer.eclipse.datatools.ui.DriverTemplate;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.button.YesButton;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.table.DefaultTableItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class GenericConnectionProfileTest {
    private String fileName = "h2-1.4.178.jar";

    @Before
    public void prepare() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        DriverPreferences preferencePage = new DriverPreferences((ReferencedComposite)preferenceDialog);
        preferenceDialog.select((PreferencePage)preferencePage);
        List items = new DefaultTable().getItems();
        int i = 0;
        while (i < items.size()) {
            new DefaultTableItem(0, new Matcher[0]).select();
            new PushButton("Remove").click();
            DefaultShell removalShell = new DefaultShell("Confirm Driver Removal");
            new YesButton().click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)removalShell));
            new DefaultShell("Preferences");
            ++i;
        }
        preferenceDialog.ok();
        new WaitWhile((WaitCondition)new JobIsRunning());
        DataSourceExplorerView dse = new DataSourceExplorerView();
        dse.open();
        DefaultTreeItem item = new DefaultTreeItem(new String[]{"Database Connections"});
        item.expand(TimePeriod.DEFAULT);
        List cpitems = item.getItems();
        for (TreeItem i2 : cpitems) {
            i2.select();
            new ContextMenuItem(new String[]{"Delete"}).select();
            DefaultShell deleteShell = new DefaultShell("Delete confirmation");
            new YesButton().click();
            new WaitWhile((WaitCondition)new ShellIsAvailable((Shell)deleteShell));
        }
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    @Test
    public void genericConnectionProfileTest() {
        File drvFile = new File("target" + File.separator + this.fileName);
        DriverTemplate dt = new DriverTemplate("Generic JDBC Driver", "1.0");
        DriverDefinition dd = new DriverDefinition();
        dd.setDriverClass("org.h2.Driver");
        dd.setDriverLibrary(drvFile.getAbsolutePath());
        dd.setDriverName("Test H2 Driver");
        dd.setDriverTemplate(dt);
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        DriverPreferences preferencePage = new DriverPreferences((ReferencedComposite)dialog);
        dialog.select((PreferencePage)preferencePage);
        DriverDialog wizard = preferencePage.addDriverDefinition();
        wizard.selectDriverTemplate("Generic JDBC Driver", "1.0");
        wizard.setName("Test H2 Driver");
        wizard.addDriverLibrary(drvFile.getAbsolutePath());
        wizard.setDriverClass("org.h2.Driver");
        wizard.ok();
        dialog.ok();
        String profile = "myDBProfile";
        DatabaseProfile dbProfile = new DatabaseProfile();
        dbProfile.setDatabase("sakila");
        dbProfile.setDatabase(profile);
        dbProfile.setDriverDefinition(dd);
        dbProfile.setHostname("jdbc:h2:tcp://localhost/sakila");
        dbProfile.setName("myDBProfile");
        dbProfile.setPassword("");
        dbProfile.setPort("8082");
        dbProfile.setUsername("sa");
        dbProfile.setVendor("Generic JDBC");
        NewCPWizard w = new NewCPWizard();
        w.open();
        w.createDatabaseProfile(dbProfile);
        DataSourceExplorerView dataSourceExplorer = new DataSourceExplorerView();
        dataSourceExplorer.open();
        List dbSources = dataSourceExplorer.getDatabaseConnections();
        Assert.assertTrue((String)("Profile '" + profile + "' isn't available"), (boolean)dbSources.contains(profile));
    }
}

