/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.ui.console;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.GroupWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitProvider;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.common.wait.WaitWrapper;
import org.eclipse.reddeer.core.matcher.WithTextMatchers;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasLabel;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasLaunch;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.eclipse.reddeer.eclipse.condition.ConsoleHasText;
import org.eclipse.reddeer.eclipse.condition.ConsoleIsTerminated;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.eclipse.ui.console.ConsoleView;
import org.eclipse.reddeer.eclipse.ui.markers.matcher.AbstractMarkerMatcher;
import org.eclipse.reddeer.eclipse.ui.perspectives.JavaPerspective;
import org.eclipse.reddeer.eclipse.ui.problems.Problem;
import org.eclipse.reddeer.eclipse.ui.views.markers.ProblemsView;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.swt.api.Menu;
import org.eclipse.reddeer.swt.api.MenuItem;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.styledtext.DefaultStyledText;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.eclipse.reddeer.workbench.impl.editor.DefaultEditor;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@OpenPerspectiveRequirement.OpenPerspective(value=JavaPerspective.class)
public class ConsoleViewTest {
    private static ConsoleView consoleView;
    private static final String TEST_PROJECT_NAME = "Project";
    private static final String TEST_CLASS_NAME = "TestClass";
    private static final String TEST_CLASS_NAME1 = "TestClass1";
    private static final String TEST_CLASS_NAME2 = "TestClass2";
    private static final String TEST_CLASS_LOOP_NAME = "TestLoopClass";
    private static final String TEST_CLASS_LOOP2_NAME = "TestLoopClass2";

    @BeforeClass
    public static void setupClass() {
        ConsoleViewTest.createTestProject();
        consoleView = new ConsoleView();
        if (consoleView.isOpen()) {
            consoleView.close();
        }
    }

    @AfterClass
    public static void tearDownClass() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)explorer.getProject(TEST_PROJECT_NAME), (boolean)true);
    }

    private void runTestClassAndWaitToFinish() {
        ConsoleViewTest.runTestClass(TEST_CLASS_NAME);
        new WaitUntil((WaitCondition)new ConsoleIsTerminated());
    }

    @Test
    public void testConsoleHasAnyText() {
        consoleView = new ConsoleView();
        while (consoleView.consoleHasLaunch()) {
            consoleView.terminateConsole();
            consoleView.removeLaunch();
        }
        Assert.assertFalse((String)"ConsoleHasText wait condition should be false, because there is no text in console", (boolean)new ConsoleHasText().test());
    }

    @Test
    public void testConsoleSwitching() {
        consoleView = new ConsoleView();
        consoleView.open();
        ConsoleViewTest.runTestClass(TEST_CLASS_NAME1);
        consoleView.toggleShowConsoleOnStandardOutChange(false);
        ConsoleViewTest.runTestClass(TEST_CLASS_NAME2);
        consoleView.switchConsole((Matcher)new RegexMatcher(".*TestClass1.*"));
        Assert.assertThat((Object)consoleView.getConsoleText(), (Matcher)IsEqual.equalTo((Object)"Hello World1"));
        consoleView.switchConsole((Matcher)new RegexMatcher(".*TestClass2.*"));
        Assert.assertThat((Object)consoleView.getConsoleText(), (Matcher)IsEqual.equalTo((Object)"Hello World2"));
        consoleView.toggleShowConsoleOnStandardOutChange(true);
    }

    @Test
    public void testConsoleView() {
        this.runTestClassAndWaitToFinish();
        this.testGettingConsoleTest();
        this.testClearConsole();
    }

    @Test
    public void testRemoveLaunch() {
        this.runTestClassAndWaitToFinish();
        consoleView = new ConsoleView();
        consoleView.open();
        new WaitUntil((WaitCondition)new ConsoleHasLaunch());
        consoleView.removeLaunch();
        new WaitWhile((WaitCondition)new ConsoleHasLaunch());
        Assert.assertFalse((String)"Some launches remain", (boolean)consoleView.consoleHasLaunch());
    }

    @Test
    public void testRemoveAllTerminatedLaunches() {
        this.runTestClassAndWaitToFinish();
        consoleView = new ConsoleView();
        consoleView.open();
        new WaitUntil((WaitCondition)new ConsoleHasLaunch());
        consoleView.removeAllTerminatedLaunches();
        Assert.assertFalse((String)"Some launches remain", (boolean)consoleView.consoleHasLaunch());
    }

    @Test
    public void testTerminateConsole() {
        ConsoleViewTest.runTestClass(TEST_CLASS_LOOP_NAME);
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        consoleView = new ConsoleView();
        consoleView.open();
        consoleView.terminateConsole();
        String text = consoleView.getConsoleText();
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        String text2 = consoleView.getConsoleText();
        Assert.assertFalse((boolean)text.trim().isEmpty());
        Assert.assertEquals((Object)text, (Object)text2);
        DefaultToolItem terminate = new DefaultToolItem("Terminate");
        Assert.assertFalse((boolean)terminate.isEnabled());
    }

    @Test
    public void consoleHasNoChangeTest() {
        ConsoleViewTest.runTestClass(TEST_CLASS_LOOP2_NAME);
        new GroupWait(TimePeriod.LONG, new WaitWrapper[]{WaitProvider.waitUntil((WaitCondition)new ConsoleHasText("Start")), WaitProvider.waitUntil((WaitCondition)new ConsoleHasNoChange(TimePeriod.getCustom((long)11L)))});
        consoleView.open();
        consoleView.terminateConsole();
        Assert.assertEquals((Object)"StartHelloApplication", (Object)consoleView.getConsoleText().replaceAll("\\s", ""));
    }

    @Test
    public void toggleShowConsoleOnStandardOutChange() {
        this.runTestClassAndWaitToFinish();
        consoleView = new ConsoleView();
        consoleView.open();
        consoleView.toggleShowConsoleOnStandardOutChange(true);
        consoleView.toggleShowConsoleOnStandardOutChange(false);
    }

    @Test
    public void getContextMenuTest() {
        ConsoleView consoleView = new ConsoleView();
        consoleView.open();
        ConsoleViewTest.runTestClass(TEST_CLASS_NAME);
        AbstractWait.sleep((TimePeriod)TimePeriod.SHORT);
        Menu contextMenu = consoleView.getContextMenu();
        MenuItem clear = contextMenu.getItem(new String[]{"Clear"});
        Assert.assertNotNull((Object)clear);
    }

    @After
    public void tearDown() {
        consoleView = new ConsoleView();
        consoleView.open();
        while (consoleView.consoleHasLaunch()) {
            consoleView.toggleShowConsoleOnStandardOutChange(true);
            consoleView.terminateConsole();
            consoleView.removeLaunch();
        }
    }

    private void testGettingConsoleTest() {
        consoleView = new ConsoleView();
        consoleView.open();
        String text = consoleView.getConsoleText();
        Assert.assertThat((Object)text, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)text, (Matcher)IsEqual.equalTo((Object)"Hello World"));
    }

    private void testClearConsole() {
        consoleView = new ConsoleView();
        consoleView.open();
        consoleView.clearConsole();
        String text = consoleView.getConsoleText();
        Assert.assertThat((Object)text, (Matcher)IsEqual.equalTo((Object)""));
    }

    private static void createTestProject() {
        PackageExplorerPart packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
        if (!packageExplorer.containsProject(TEST_PROJECT_NAME)) {
            ConsoleViewTest.createJavaProject();
            ConsoleViewTest.createJavaClass(TEST_CLASS_NAME, "System.out.print(\"Hello World\");");
            ConsoleViewTest.createJavaClass(TEST_CLASS_LOOP_NAME, "int i = 0; while (true) {System.out.println(i++);}");
            ConsoleViewTest.createJavaClass(TEST_CLASS_LOOP2_NAME, "try {System.out.println(\"Start\");\nThread.sleep(10 * 1000);\nSystem.out.println(\"Hello Application\");\nThread.sleep(20 * 1000);\nSystem.out.println(\"Finish\");\n} catch (InterruptedException e) {e.printStackTrace();}");
            ConsoleViewTest.createJavaClass(TEST_CLASS_NAME1, "System.out.print(\"Hello World1\");\ntry {\nThread.sleep(15*1000);\n} catch (InterruptedException e) {e.printStackTrace();}");
            ConsoleViewTest.createJavaClass(TEST_CLASS_NAME2, "System.out.print(\"Hello World2\");\ntry {\nThread.sleep(15*1000);\n} catch (InterruptedException e) {e.printStackTrace();}");
        }
        packageExplorer.getProject(TEST_PROJECT_NAME).select();
    }

    private static void createJavaProject() {
        JavaProjectWizard javaProject = new JavaProjectWizard();
        javaProject.open();
        NewJavaProjectWizardPageOne javaWizardPage = new NewJavaProjectWizardPageOne((ReferencedComposite)javaProject);
        javaWizardPage.setProjectName(TEST_PROJECT_NAME);
        javaProject.finish();
    }

    private static void createJavaClass(String name, String text) {
        NewClassCreationWizard javaClassDialog = new NewClassCreationWizard();
        javaClassDialog.open();
        NewClassWizardPage wizardPage = new NewClassWizardPage((ReferencedComposite)javaClassDialog);
        wizardPage.setName(name);
        wizardPage.setPackage("test");
        wizardPage.setStaticMainMethod(true);
        javaClassDialog.finish();
        DefaultStyledText dst = new DefaultStyledText();
        dst.insertText(7, 0, text);
        new DefaultEditor().save();
    }

    private static void runTestClass(String name) {
        ProblemsView view = new ProblemsView();
        view.open();
        List problems = view.getProblems(ProblemsView.ProblemType.ALL, new AbstractMarkerMatcher[0]);
        if (!problems.isEmpty()) {
            System.out.println("### There are problems in problems view");
            for (Problem problem : problems) {
                System.out.println(problem.getProblemType() + " " + problem.getResource() + " " + problem.getDescription());
            }
        }
        try {
            ScreenshotCapturer.getInstance().captureScreenshot("Problems" + ConsoleViewTest.class.getName());
        }
        catch (CaptureScreenshotException e) {
            e.printStackTrace();
        }
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        explorer.getProject(TEST_PROJECT_NAME).getProjectItem(new String[]{"src", "test", String.valueOf(name) + ".java"}).select();
        RegexMatcher[] array = new RegexMatcher[]{new RegexMatcher("Run.*"), new RegexMatcher("Run As.*"), new RegexMatcher(".*Java Application.*")};
        WithTextMatchers m = new WithTextMatchers((Matcher[])array);
        new ShellMenuItem(m.getMatchers()).select();
        new GroupWait(TimePeriod.getCustom((long)20L), new WaitWrapper[]{WaitProvider.waitUntil((WaitCondition)new ConsoleHasLabel((Matcher)new RegexMatcher(".*" + name + ".*"))), WaitProvider.waitWhile((WaitCondition)new JobIsRunning())});
    }
}

