/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.common.project.facet.ui;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTestCase;
import org.eclipse.reddeer.eclipse.ui.dialogs.PropertyDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.eclipse.wst.common.project.facet.ui.FacetsPropertyPage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class FacetsPropertyPageTest {
    private static final String PROJECT = "server-project";
    private static final String FACET1 = "Java";
    private static final String FACET1_VERSION = "1.7";

    @Before
    public void createProject() {
        ExternalProjectImportWizardDialog wizard = new ExternalProjectImportWizardDialog();
        wizard.open();
        WizardProjectsImportPage wizardPage = new WizardProjectsImportPage((ReferencedComposite)wizard);
        wizardPage.setArchiveFile(ServersViewTestCase.ZIP_FILE.getAbsolutePath());
        wizardPage.selectProjects(new String[]{PROJECT});
        wizard.finish();
        PackageExplorerPart packageExplorer = new PackageExplorerPart();
        packageExplorer.open();
    }

    @After
    public void cleanup() {
        PropertyDialog dialog = new PropertyDialog(PROJECT);
        if (dialog.isOpen()) {
            dialog.cancel();
        }
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)explorer.getProject(PROJECT), (boolean)true);
    }

    @Test
    public void selectFacet() {
        PropertyDialog dialog = new PackageExplorerPart().getProject(PROJECT).openProperties();
        FacetsPropertyPage facetsPage = new FacetsPropertyPage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)facetsPage);
        facetsPage.selectFacet(FACET1);
        facetsPage.apply();
        dialog.ok();
        dialog = new PackageExplorerPart().getProject(PROJECT).openProperties();
        facetsPage = new FacetsPropertyPage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)facetsPage);
        MatcherAssert.assertThat((Object)((TreeItem)facetsPage.getSelectedFacets().get(0)).getText(), (Matcher)Is.is((Object)FACET1));
        dialog.ok();
    }

    @Test
    public void selectVersion() {
        PropertyDialog dialog = new PackageExplorerPart().getProject(PROJECT).openProperties();
        FacetsPropertyPage facetsPage = new FacetsPropertyPage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)facetsPage);
        facetsPage.selectFacet(FACET1);
        facetsPage.selectVersion(FACET1, FACET1_VERSION);
        facetsPage.apply();
        dialog.ok();
        dialog = new PackageExplorerPart().getProject(PROJECT).openProperties();
        facetsPage = new FacetsPropertyPage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)facetsPage);
        MatcherAssert.assertThat((Object)facetsPage.getSelectedVersion(FACET1), (Matcher)Is.is((Object)FACET1_VERSION));
        dialog.ok();
    }
}

