/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.common.project.facet.ui;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTestCase;
import org.eclipse.reddeer.eclipse.ui.dialogs.PropertyDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.eclipse.wst.common.project.facet.ui.RuntimesPropertyPage;
import org.eclipse.reddeer.eclipse.wst.server.ui.RuntimePreferencePage;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewRuntimeWizardDialog;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewRuntimeWizardPage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class RuntimesPropertyPageTest {
    private static final String PROJECT = "server-project";
    private PropertyDialog dialog;
    private DefaultProject project;

    @Before
    public void createProject() {
        ExternalProjectImportWizardDialog wizard = new ExternalProjectImportWizardDialog();
        wizard.open();
        WizardProjectsImportPage wizardPage = new WizardProjectsImportPage((ReferencedComposite)wizard);
        wizardPage.setArchiveFile(ServersViewTestCase.ZIP_FILE.getAbsolutePath());
        wizardPage.selectProjects(new String[]{PROJECT});
        wizard.finish();
    }

    @Before
    public void createRuntime() {
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        RuntimePreferencePage runtimePreference = new RuntimePreferencePage((ReferencedComposite)preferencesDialog);
        preferencesDialog.open();
        preferencesDialog.select((PreferencePage)runtimePreference);
        NewRuntimeWizardDialog dialog = runtimePreference.addRuntime();
        NewRuntimeWizardPage page = new NewRuntimeWizardPage((ReferencedComposite)dialog);
        page.selectType(new String[]{"Basic", "Test runtime"});
        dialog.finish();
        preferencesDialog.ok();
    }

    @After
    public void cleanup() {
        if (this.dialog != null && this.dialog.isOpen()) {
            this.dialog.cancel();
        }
        DeleteUtils.forceProjectDeletion((DefaultProject)this.getProject(), (boolean)true);
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        RuntimePreferencePage runtimePreference = new RuntimePreferencePage((ReferencedComposite)preferencesDialog);
        preferencesDialog.open();
        preferencesDialog.select((PreferencePage)runtimePreference);
        runtimePreference.removeAllRuntimes();
        preferencesDialog.cancel();
    }

    @Test
    public void selectRuntime() {
        this.dialog = this.getProject().openProperties();
        RuntimesPropertyPage propertyPage = new RuntimesPropertyPage((ReferencedComposite)this.dialog);
        this.dialog.select((PreferencePage)propertyPage);
        propertyPage.selectRuntime("Test runtime");
        Assert.assertTrue((boolean)propertyPage.getSelectedRuntimes().contains("Test runtime"));
        this.dialog.ok();
        this.dialog = this.getProject().openProperties();
        propertyPage = new RuntimesPropertyPage((ReferencedComposite)this.dialog);
        this.dialog.select((PreferencePage)propertyPage);
        MatcherAssert.assertThat((Object)((String)propertyPage.getSelectedRuntimes().get(0)), (Matcher)Is.is((Object)"Test runtime"));
    }

    public DefaultProject getProject() {
        if (this.project == null) {
            PackageExplorerPart packageExplorer = new PackageExplorerPart();
            packageExplorer.open();
            this.project = packageExplorer.getProject(PROJECT);
        }
        return this.project;
    }
}

