/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.view;

import java.io.File;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.ServerExists;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTest;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.ExternalProjectImportWizardDialog;
import org.eclipse.reddeer.eclipse.ui.wizards.datatransfer.WizardProjectsImportPage;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersView2;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewServerWizard;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewServerWizardPage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ServersViewTestCase {
    public static final File ZIP_FILE = new File(Activator.getTestResourcesLocation(ServersViewTest.class), "server-project.zip");
    protected static final String PROJECT_1 = "server-project";
    protected static final String PROJECT_2 = "server-project-2";
    protected static final String PROJECT_3 = "server-project-3";
    private static ServersView2 serversView;
    protected static NewServerWizard wizardDialog;

    @After
    public void tearDown() {
        if (wizardDialog != null && "New Server".equals(new DefaultShell().getText())) {
            wizardDialog.cancel();
        }
    }

    @AfterClass
    public static void deleteServers() {
        for (Server server : ServersViewTestCase.getServersView().getServers()) {
            server.delete(false);
        }
    }

    public static ServersView2 getServersView() {
        serversView = new ServersView2();
        serversView.open();
        return serversView;
    }

    protected static void createServer(String name) {
        wizardDialog = ServersViewTestCase.getServersView().newServer();
        NewServerWizardPage newServerPage = new NewServerWizardPage((ReferencedComposite)wizardDialog);
        newServerPage.selectType(new String[]{"Basic", "Test server"});
        newServerPage.setName(name);
        wizardDialog.finish();
        new WaitUntil((WaitCondition)new ServerExists(name));
    }

    protected static void importProjects() {
        ExternalProjectImportWizardDialog wizard = new ExternalProjectImportWizardDialog();
        wizard.open();
        WizardProjectsImportPage wizardPage = new WizardProjectsImportPage((ReferencedComposite)wizard);
        wizardPage.setArchiveFile(ZIP_FILE.getAbsolutePath());
        wizardPage.selectProjects(new String[]{PROJECT_1, PROJECT_2, PROJECT_3});
        wizard.finish();
    }
}

