/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.m2e.core.ui.wizard;

import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.jface.wizard.WizardPage;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.LabeledCombo;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;

public class MavenImportWizardPage
extends WizardPage {
    public static final String TITLE = "Import Maven Projects";

    public MavenImportWizardPage(ReferencedComposite referencedComposite) {
        super(referencedComposite);
    }

    public MavenImportWizardPage activate() {
        new DefaultShell(TITLE);
        return this;
    }

    public MavenImportWizardPage setRootDirectory(String path) {
        this.activate();
        new LabeledCombo((ReferencedComposite)this, "Root Directory:").setText(path);
        return this;
    }

    public MavenImportWizardPage refresh() {
        this.activate();
        new PushButton((ReferencedComposite)this, "Refresh").click();
        return this;
    }

    public MavenImportWizardPage waitUntilProjectIsLoaded(TimePeriod timeout) {
        this.activate();
        new WaitUntil((WaitCondition)new ProjectsIsLoaded(), timeout);
        return this;
    }

    private class ProjectsIsLoaded
    extends AbstractWaitCondition {
        private ProjectsIsLoaded() {
        }

        public boolean test() {
            return new PushButton((ReferencedComposite)MavenImportWizardPage.this, "Finish").isEnabled() || new PushButton((ReferencedComposite)MavenImportWizardPage.this, "Next >").isEnabled();
        }

        public String description() {
            return "The project is still not loaded.";
        }
    }
}

