/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.extension.before.test.impl;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.junit.extensionpoint.IBeforeTest;
import org.eclipse.reddeer.workbench.core.lookup.WorkbenchPartLookup;
import org.eclipse.ui.IViewReference;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class CloseWelcomeScreenExt
implements IBeforeTest {
    private static final Logger log = Logger.getLogger(CloseWelcomeScreenExt.class);
    private static final boolean CLOSE_WELCOME_SCREEN = RedDeerProperties.CLOSE_WELCOME_SCREEN.getBooleanValue();

    public void runBeforeTestClass(String config, TestClass testClass) {
        this.closeWelcomeScreen();
    }

    public void runBeforeTest(String config, Object target, FrameworkMethod method) {
    }

    private void closeWelcomeScreen() {
        log.debug("Trying to close Welcome Screen");
        IViewReference[] iViewReferenceArray = WorkbenchPartLookup.getInstance().findAllViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference viewReference = iViewReferenceArray[n2];
            if (viewReference.getPartName().equals("Welcome")) {
                final IViewReference iViewReference = viewReference;
                Display.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        iViewReference.getPage().hideView(iViewReference);
                    }
                });
                log.debug("Welcome Screen closed");
                break;
            }
            ++n2;
        }
    }

    public boolean hasToRun() {
        return CLOSE_WELCOME_SCREEN;
    }

    public long getPriority() {
        return 1000000L;
    }
}

