/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.integration.runner.order;

import java.util.Iterator;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.eclipse.reddeer.junit.internal.configuration.SuiteConfiguration;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.test.integration.runner.order.TestSequence;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public abstract class TestSequenceRedDeerSuite
extends RedDeerSuite {
    public TestSequenceRedDeerSuite(Class<?> clazz, RunnerBuilder builder) throws InitializationError {
        super(clazz, builder);
    }

    protected TestSequenceRedDeerSuite(Class<?> clazz, RunnerBuilder builder, SuiteConfiguration config) throws InitializationError {
        super(clazz, builder, config);
    }

    protected abstract List<?> getExpectedSequence();

    public void run(RunNotifier notifier) {
        TestSequence.getRealSequence().clear();
        super.run(notifier);
        if (!this.getExpectedSequence().equals(TestSequence.getRealSequence())) {
            notifier.fireTestFailure(new Failure(Description.createSuiteDescription(((Object)((Object)this)).getClass()), this.createException()));
        }
    }

    private Throwable createException() {
        List<?> realList = TestSequence.getRealSequence();
        List<?> expectedList = this.getExpectedSequence();
        Iterator<?> realSequenceIterator = realList.iterator();
        Iterator<?> expectedSequenceIterator = expectedList.iterator();
        int i = 0;
        while (realSequenceIterator.hasNext() && expectedSequenceIterator.hasNext()) {
            Object expected;
            Object real = realSequenceIterator.next();
            if (!real.equals(expected = expectedSequenceIterator.next())) {
                return new AssertionFailedError("Expected and real sequence differ at index " + i + ".  Expected: " + expected + ", real: " + real + "\n" + "Whole sequences: \n" + "REAL:" + realList + "\n" + "EXPECTED:" + expectedList);
            }
            ++i;
        }
        if (realSequenceIterator.hasNext()) {
            return new AssertionFailedError("Real sequence contains more items than the expected one");
        }
        return new AssertionFailedError("Expected sequence contains more items than the real one");
    }
}

