/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.internal.configuration.reader;

import java.io.File;
import java.util.List;
import org.eclipse.reddeer.junit.configuration.RedDeerConfigurationException;
import org.eclipse.reddeer.junit.internal.configuration.reader.JSONConfigurationReader;
import org.eclipse.reddeer.junit.requirement.RequirementException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JSONConfigurationReaderTest {
    private static final String RESOURCES_DIR = "." + File.separator + "resources" + File.separator;
    public static final String CONFIG_FILE = String.valueOf(RESOURCES_DIR) + "SimpleAndComplexTestConfigurations.json";
    public static final String CONFIG_FILE_YAML = String.valueOf(RESOURCES_DIR) + "SimpleAndComplexTestConfigurations.yaml";
    public static final String NONEXISTING_FILE = String.valueOf(RESOURCES_DIR) + "nada.json";
    public static final String INVALID_FILE = String.valueOf(RESOURCES_DIR) + "InvalidTestConfiguration.json";
    public static final String NOT_REGISTERED_FILE = String.valueOf(RESOURCES_DIR) + "reddeersuitetest-config-missing-extension.json";
    private JSONConfigurationReader reader;

    @Before
    public void setup() {
        this.reader = new JSONConfigurationReader();
    }

    @Test(expected=RedDeerConfigurationException.class)
    public void testLoadConfigsFromNonexistingFile() {
        this.reader.loadConfigurations(new File(NONEXISTING_FILE));
    }

    @Test(expected=RedDeerConfigurationException.class)
    public void testLoadConfigsFromInvalidJSONFile() {
        this.reader.loadConfigurations(new File(INVALID_FILE));
    }

    public void testLoadConfigsReqNotRegisteredViaExtension() {
        try {
            this.reader.loadConfigurations(new File(NOT_REGISTERED_FILE));
        }
        catch (RequirementException e) {
            Assert.assertEquals((Object)"org.eclipse.reddeer.junit.test.internal.requirement.NotRegisteredViaExtension is not registered via extension point org.eclipse.reddeer.junit.requirement", (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"loading configuration should have failed because requirement is not registered via extension point");
    }

    @Test
    public void testLoadConfigFromFile() {
        List configs = this.reader.loadConfigurations(new File(CONFIG_FILE));
        Assert.assertTrue((String)"There should be 8 configs in configuration file", (configs.size() == 8 ? 1 : 0) != 0);
    }
}

