/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.internal.requirement;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.reddeer.junit.internal.requirement.Requirements;
import org.eclipse.reddeer.junit.requirement.Requirement;
import org.eclipse.reddeer.junit.test.internal.requirement.TestRequirementA;
import org.eclipse.reddeer.junit.test.internal.requirement.TestRequirementB;
import org.eclipse.reddeer.junit.test.internal.requirement.TestRequirementC;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RequirementsTest {
    private Requirements requirements;

    @Test(expected=IllegalArgumentException.class)
    public void constructor_nullList() {
        new Requirements(null, null, null);
    }

    @Test
    public void size() {
        Requirement requirement1 = (Requirement)Mockito.mock(Requirement.class);
        Requirement requirement2 = (Requirement)Mockito.mock(Requirement.class);
        this.requirements = new Requirements(this.asList(requirement1, requirement2), String.class, null);
        MatcherAssert.assertThat((Object)this.requirements.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void iterator() {
        Requirement requirement1 = (Requirement)Mockito.mock(Requirement.class);
        Requirement requirement2 = (Requirement)Mockito.mock(Requirement.class);
        this.requirements = new Requirements(this.asList(requirement1, requirement2), String.class, null);
        Iterator iterator = this.requirements.iterator();
        Assert.assertSame((Object)requirement1, iterator.next());
        Assert.assertSame((Object)requirement2, iterator.next());
    }

    @Test
    public void fulfill() {
        Requirement requirement1 = (Requirement)Mockito.mock(Requirement.class);
        Requirement requirement2 = (Requirement)Mockito.mock(Requirement.class);
        this.requirements = new Requirements(this.asList(requirement1, requirement2), String.class, null);
        this.requirements.fulfill();
        ((Requirement)Mockito.verify((Object)requirement1)).fulfill();
        ((Requirement)Mockito.verify((Object)requirement2)).fulfill();
    }

    @Test
    public void cleanup() {
        Requirement requirement1 = (Requirement)Mockito.mock(Requirement.class);
        Requirement requirement2 = (Requirement)Mockito.mock(Requirement.class);
        this.requirements = new Requirements(this.asList(requirement1, requirement2), String.class, null);
        this.requirements.cleanUp();
        ((Requirement)Mockito.verify((Object)requirement1)).cleanUp();
        ((Requirement)Mockito.verify((Object)requirement2)).cleanUp();
    }

    @Test
    public void sortByPriority() {
        TestRequirementA requirement1 = new TestRequirementA();
        TestRequirementB requirement2 = new TestRequirementB();
        TestRequirementC requirement3 = new TestRequirementC();
        Requirements requirements = new Requirements(this.asList(requirement1, requirement2, requirement3), String.class, null);
        Iterator iterator = requirements.iterator();
        Assert.assertSame((String)"TestRequirementC was expected", (Object)requirement3, iterator.next());
        Assert.assertSame((String)"TestRequirementB was expected", (Object)requirement2, iterator.next());
        Assert.assertSame((String)"TestRequirementA was expected", (Object)requirement1, iterator.next());
    }

    private List<Requirement<?>> asList(Requirement<?> ... requirements) {
        return Arrays.asList(requirements);
    }
}

