/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.runner;

import org.eclipse.reddeer.junit.internal.runner.EmptySuite;
import org.eclipse.reddeer.junit.internal.runner.TestWithoutExecutionRunner;
import org.eclipse.reddeer.junit.internal.runner.TestsExecutionManager;
import org.junit.runner.Runner;
import org.junit.runners.Suite;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class TestsWithoutExecutionSuite
extends Suite {
    public TestsWithoutExecutionSuite(Class<?> clazz, TestsExecutionManager testsManager) throws InitializationError {
        super(clazz, (RunnerBuilder)new TestsWithoutRunRunnerBuilder(testsManager));
    }

    public TestsWithoutExecutionSuite(Class<?>[] classes, TestsExecutionManager testsManager) throws InitializationError {
        super((RunnerBuilder)new TestsWithoutRunRunnerBuilder(testsManager), EmptySuite.class, (Class[])classes);
    }

    public String getName() {
        return "NOT EXECUTED TESTS";
    }

    public String toString() {
        return "Suite '" + ((Object)((Object)this)).getClass().getName() + "' " + "showing tests without a single run";
    }

    private static class TestsWithoutRunRunnerBuilder
    extends RunnerBuilder {
        private TestsExecutionManager testsRunManager;

        public TestsWithoutRunRunnerBuilder(TestsExecutionManager testsManager) {
            this.testsRunManager = testsManager;
        }

        public Runner runnerForClass(Class<?> clazz) throws Throwable {
            if (this.testsRunManager.isExecuted(clazz)) {
                return null;
            }
            return new TestWithoutExecutionRunner(clazz);
        }
    }
}

