/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class LinkRule
extends AbstractSimpleRedDeerRule {
    private String text;
    private int index;
    private List<ReferencedComposite> composites;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Link && event.type == 3;
    }

    public void initializeForEvent(Event event) {
        Link link = (Link)event.widget;
        this.widget = link;
        this.setIndex(WidgetUtils.getIndex((Control)link));
        if (link.getText() != null) {
            String[] split1 = link.getText().split(".*<[aA]>");
            String[] split2 = split1[split1.length - 1].split("</[aA]>.*");
            this.setText(split2[0]);
        }
        this.setComposites(RedDeerUtils.getComposites((Control)link));
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder list = new StringBuilder();
        list.append("new DefaultLink(");
        list.append(RedDeerUtils.getReferencedCompositeString(this.composites));
        if (this.text != null) {
            list.append("\"" + this.text + "\"");
        } else {
            list.append(this.index);
        }
        list.append(").click()");
        toReturn.add(list.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("org.eclipse.reddeer.swt.impl.link.DefaultLink");
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        return toReturn;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<ReferencedComposite> getComposites() {
        return this.composites;
    }

    public void setComposites(List<ReferencedComposite> composites) {
        this.composites = composites;
    }
}

