/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.scale;

import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.swt.impl.scale.DefaultScale;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ScaleTest
extends SWTLayerTestCase {
    private static final int[] SCALE_MAXIMUM = new int[]{100, 200};
    private static final int[] SCALE_MINIMUM = new int[]{10, 110};
    private static final int[] SCALE_INIT_VALUE = new int[]{50, 150};
    private org.eclipse.reddeer.swt.api.Text selectionText = null;
    private SelectionListener selectionListener;
    private Text txSelection;

    @Override
    protected void createControls(Shell shell) {
        this.selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Scale selectedScale = (Scale)arg0.widget;
                ScaleTest.this.txSelection.setText(String.valueOf(selectedScale.getSelection()));
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        };
        int index = 0;
        while (index < SCALE_INIT_VALUE.length) {
            Scale scale = new Scale((Composite)shell, 2048);
            scale.setMaximum(SCALE_MAXIMUM[index]);
            scale.setMinimum(SCALE_MINIMUM[index]);
            scale.setIncrement(1);
            scale.setSelection(SCALE_INIT_VALUE[index]);
            scale.addSelectionListener(this.selectionListener);
            ++index;
        }
        this.txSelection = new Text((Composite)shell, 2048);
        this.txSelection.setText("<value of selected scale>");
    }

    @Test
    public void findScaleByIndex() {
        int index = 1;
        DefaultScale scale = new DefaultScale(index, new Matcher[0]);
        Assert.assertTrue((String)"Wrong scale widget was found", (scale.getMinimum() == SCALE_MINIMUM[index] ? 1 : 0) != 0);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingScaleByIndex() {
        int index = 4;
        new DefaultScale(index, new Matcher[0]);
    }

    @Test
    public void getMinimum() {
        int index = 0;
        DefaultScale scale = new DefaultScale(index, new Matcher[0]);
        int minimum = scale.getMinimum();
        Assert.assertTrue((String)("Wrong scale minimum value. Was " + minimum + " expected was " + SCALE_MINIMUM[index]), (minimum == SCALE_MINIMUM[index] ? 1 : 0) != 0);
    }

    @Test
    public void getMaximum() {
        int index = 1;
        DefaultScale scale = new DefaultScale(index, new Matcher[0]);
        int maximum = scale.getMaximum();
        Assert.assertTrue((String)("Wrong scale maximum value. Was " + maximum + " expected was " + SCALE_MINIMUM[index]), (maximum == SCALE_MAXIMUM[index] ? 1 : 0) != 0);
    }

    @Test
    public void getSelection() {
        int index = 1;
        DefaultScale scale = new DefaultScale(index, new Matcher[0]);
        int selection = scale.getSelection();
        Assert.assertTrue((String)("Wrong scale selection value. Was " + selection + " expected was " + SCALE_INIT_VALUE[index]), (selection == SCALE_INIT_VALUE[index] ? 1 : 0) != 0);
    }

    @Test
    public void setSelection() {
        DefaultScale scale = new DefaultScale();
        int newSelection = 80;
        scale.setSelection(newSelection);
        int selection = scale.getSelection();
        Assert.assertTrue((String)("Scale selection value was not set. It was " + selection + " expected was " + newSelection), (selection == newSelection ? 1 : 0) != 0);
        Assert.assertTrue((String)"Selection Event was not fired properly", (boolean)this.getSelectionText().getText().equals(String.valueOf(newSelection)));
    }

    private org.eclipse.reddeer.swt.api.Text getSelectionText() {
        if (this.selectionText == null) {
            this.selectionText = new DefaultText(0, new Matcher[0]);
        }
        return this.selectionText;
    }
}

