/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.button;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.ButtonHandler;
import org.eclipse.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.impl.button.AbstractButton;
import org.eclipse.swt.widgets.Button;
import org.hamcrest.Matcher;

public class ToggleButton
extends AbstractButton {
    private static final Logger log = Logger.getLogger(ToggleButton.class);

    public ToggleButton() {
        this((ReferencedComposite)null);
    }

    public ToggleButton(Button widget) {
        super(widget);
    }

    public ToggleButton(ReferencedComposite referencedComposite) {
        this(referencedComposite, 0, new Matcher[0]);
    }

    public ToggleButton(String text) {
        this(null, text);
    }

    public ToggleButton(ReferencedComposite referencedComposite, String text) {
        this(referencedComposite, 0, new Matcher[]{new WithMnemonicTextMatcher(text)});
    }

    public ToggleButton(Matcher<?> ... matchers) {
        this((ReferencedComposite)null, matchers);
    }

    public ToggleButton(ReferencedComposite referencedComposite, Matcher<?> ... matchers) {
        this(referencedComposite, 0, matchers);
    }

    public ToggleButton(int index, Matcher<?> ... matchers) {
        this(null, index, matchers);
    }

    public ToggleButton(ReferencedComposite referencedComposite, int index, Matcher<?> ... matchers) {
        super(referencedComposite, index, 2, matchers);
    }

    public boolean isSelected() {
        return ButtonHandler.getInstance().isSelected((Button)this.swtWidget);
    }

    public void toggle(boolean checked) {
        if (checked) {
            if (this.isSelected()) {
                log.debug("Toggle Button " + this.getDescriptiveText() + " already checked, no action performed");
                return;
            }
            log.info("Checking Toggle Button " + this.getDescriptiveText());
            this.click();
        } else if (this.isSelected()) {
            log.info("Unchecking Toggle Button " + this.getDescriptiveText());
            this.click();
        } else {
            log.debug("Toggle Button " + this.getDescriptiveText() + " already unchecked, no action performed");
            return;
        }
    }
}

