/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.util.ArrayList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.renderings.RenderingsUtil;

public class TableRenderingLine
extends PlatformObject {
    private String fAddress;
    private String fStrRep;
    private MemoryByte[] fBytes;
    private byte[] fByteArray;
    private int fTableIndex = -1;
    private String fPaddedString;
    public boolean isMonitored;
    public static final String P_ADDRESS = "address";
    private static final int numCharPerByteForHex = 2;

    public TableRenderingLine(String address, MemoryByte[] bytes, int tableIndex, String paddedString) {
        this.fAddress = address;
        this.fBytes = bytes;
        this.fTableIndex = tableIndex;
        this.fPaddedString = paddedString;
    }

    public String getAddress() {
        return this.fAddress;
    }

    public void setAddress(String address) {
        this.fAddress = address;
    }

    public MemoryByte[] getBytes() {
        return this.fBytes;
    }

    public MemoryByte getByte(int offset) {
        if (this.fBytes == null) {
            return null;
        }
        if (offset < this.fBytes.length) {
            return this.fBytes[offset];
        }
        return null;
    }

    public MemoryByte[] getBytes(int start, int end) {
        ArrayList<MemoryByte> ret = new ArrayList<MemoryByte>();
        int i = start;
        while (i < end) {
            ret.add(this.fBytes[i]);
            ++i;
        }
        return ret.toArray(new MemoryByte[ret.size()]);
    }

    public String getRawMemoryString() {
        if (this.fStrRep == null) {
            StringBuilder buffer = new StringBuilder();
            this.fStrRep = RenderingsUtil.convertByteArrayToHexString(this.getByteArray());
            this.fStrRep = this.fStrRep.toUpperCase();
            buffer = buffer.append(this.fStrRep);
            String paddedString = null;
            int bufferCounter = 0;
            int i = 0;
            while (i < this.fBytes.length) {
                if (!this.fBytes[i].isReadable()) {
                    if (paddedString == null && (paddedString = this.fPaddedString).length() > 2) {
                        paddedString = paddedString.substring(0, 2);
                    }
                    buffer.replace(bufferCounter, bufferCounter + 2, paddedString);
                }
                bufferCounter += 2;
                ++i;
            }
            this.fStrRep = buffer.toString();
        }
        return this.fStrRep;
    }

    public boolean isAvailable(int start, int end) {
        boolean available = true;
        int i = start;
        while (i < end) {
            if (!this.fBytes[i].isReadable()) {
                available = false;
                break;
            }
            ++i;
        }
        return available;
    }

    public byte[] getByteArray() {
        if (this.fByteArray == null) {
            this.fByteArray = new byte[this.fBytes.length];
            int i = 0;
            while (i < this.fBytes.length) {
                this.fByteArray[i] = this.fBytes[i].getValue();
                ++i;
            }
        }
        return this.fByteArray;
    }

    public byte[] getByteArray(int start, int end) {
        byte[] ret = new byte[end - start];
        int j = 0;
        int i = start;
        while (i < end) {
            ret[j] = this.fBytes[i].getValue();
            ++j;
            ++i;
        }
        return ret;
    }

    public void markDeltas(TableRenderingLine oldData) {
        if (oldData == null) {
            return;
        }
        if (!oldData.getAddress().equals(this.getAddress())) {
            return;
        }
        if (oldData.getRawMemoryString().equals(this.getRawMemoryString())) {
            int i = 0;
            while (i < this.fBytes.length) {
                this.fBytes[i].setHistoryKnown(true);
                ++i;
            }
            return;
        }
        MemoryByte[] oldMemory = oldData.getBytes();
        if (oldMemory.length != this.fBytes.length) {
            return;
        }
        int i = 0;
        while (i < this.fBytes.length) {
            this.fBytes[i].setHistoryKnown(true);
            if ((this.fBytes[i].getFlags() & 2) != (oldMemory[i].getFlags() & 2)) {
                this.fBytes[i].setChanged(true);
            } else if (this.fBytes[i].isReadable() && oldMemory[i].isReadable() && this.fBytes[i].getValue() != oldMemory[i].getValue()) {
                this.fBytes[i].setChanged(true);
            }
            ++i;
        }
    }

    public void copyDeltas(TableRenderingLine oldData) {
        if (oldData == null) {
            return;
        }
        if (!oldData.getAddress().equals(this.getAddress())) {
            return;
        }
        MemoryByte[] oldMemory = oldData.getBytes();
        if (oldMemory.length != this.fBytes.length) {
            return;
        }
        int i = 0;
        while (i < this.fBytes.length) {
            this.fBytes[i].setFlags(oldMemory[i].getFlags());
            ++i;
        }
    }

    public boolean isLineChanged(TableRenderingLine oldData) {
        if (oldData == null) {
            return false;
        }
        if (!oldData.getAddress().equals(this.getAddress())) {
            return false;
        }
        return !oldData.getRawMemoryString().equals(this.getRawMemoryString());
    }

    public boolean isRangeChange(int offset, int endOffset) {
        boolean allBytesKnown = true;
        boolean allBytesUnchanged = true;
        int i = offset;
        while (i <= endOffset) {
            if (!this.fBytes[i].isHistoryKnown()) {
                allBytesKnown = false;
            }
            if (this.fBytes[i].isChanged()) {
                allBytesUnchanged = false;
            }
            ++i;
        }
        return allBytesKnown && !allBytesUnchanged;
    }

    public void unmarkDeltas() {
        int i = 0;
        while (i < this.fBytes.length) {
            if (this.fBytes[i].isChanged()) {
                this.fBytes[i].setChanged(false);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getAddress());
        buf.append(": ");
        buf.append(this.getRawMemoryString());
        return buf.toString();
    }

    public int getTableIndex() {
        return this.fTableIndex;
    }

    public int getLength() {
        return this.fBytes.length;
    }
}

