/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.DriverInstancePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class DriverPropertySourceProvider
implements IPropertySourceProvider,
ChangeListener {
    private DriverInstance di = null;
    private DriverInstancePropertySource dips = null;
    private static ListenerList changeListeners = new ListenerList();

    public DriverPropertySourceProvider() {
    }

    public DriverPropertySourceProvider(IPropertySet propSet, TemplateDescriptor descriptor) {
        this();
        this.di = new DriverInstance(descriptor, propSet);
        this.dips = new DriverInstancePropertySource(this.di);
    }

    public IPropertySource getPropertySource(Object object) {
        if (object instanceof DriverInstance) {
            this.dips.removeChangeListener(this);
            this.dips.setDriverInstance((DriverInstance)object);
            this.dips.addChangeListener(this);
            return this.dips;
        }
        if (object instanceof IPropertySet) {
            this.dips.removeChangeListener(this);
            this.dips.setDriverInstance(this.di);
            this.dips.addChangeListener(this);
            return this.dips;
        }
        return null;
    }

    private void fireChangedEvent(Object source) {
        ChangeEvent e = new ChangeEvent(source);
        Object[] listeners = changeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ChangeListener)listeners[i]).stateChanged(e);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        changeListeners.add((Object)listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        changeListeners.remove((Object)listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChangedEvent(this);
    }
}

