/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.internal.console.IOConsolePartition;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;

public class IOConsolePartitioner
implements IConsoleDocumentPartitioner,
IDocumentPartitionerExtension {
    private static final boolean ASSERT = false;
    private static final Comparator<IRegion> CMP_REGION_BY_OFFSET = Comparator.comparing(IRegion::getOffset);
    private PendingPartition consoleClosedPartition;
    private IDocument document;
    private ArrayList<IOConsolePartition> partitions;
    private ArrayList<PendingPartition> pendingPartitions;
    private ArrayList<PendingPartition> updatePartitions;
    private QueueProcessingJob queueJob;
    private TrimJob trimJob = new TrimJob();
    private IOConsoleInputStream inputStream;
    private boolean updateInProgress;
    private ArrayList<IOConsolePartition> inputPartitions;
    private int firstOffset;
    private String[] lld;
    private int highWaterMark = -1;
    private int lowWaterMark = -1;
    private boolean connected = false;
    private IOConsole console;
    private Object overflowLock = new Object();
    private int fBuffer;

    public IOConsolePartitioner(IOConsoleInputStream inputStream, IOConsole console) {
        this.inputStream = inputStream;
        this.console = console;
        this.trimJob.setRule(console.getSchedulingRule());
    }

    public IDocument getDocument() {
        return this.document;
    }

    public void connect(IDocument doc) {
        this.document = doc;
        this.document.setDocumentPartitioner((IDocumentPartitioner)this);
        this.lld = this.document.getLegalLineDelimiters();
        this.partitions = new ArrayList();
        this.pendingPartitions = new ArrayList();
        this.inputPartitions = new ArrayList();
        this.queueJob = new QueueProcessingJob();
        this.queueJob.setSystem(true);
        this.queueJob.setPriority(10);
        this.queueJob.setRule(this.console.getSchedulingRule());
        this.connected = true;
    }

    public int getHighWaterMark() {
        return this.highWaterMark;
    }

    public int getLowWaterMark() {
        return this.lowWaterMark;
    }

    public void setWaterMarks(int low, int high) {
        this.lowWaterMark = low;
        this.highWaterMark = high;
        ConsolePlugin.getStandardDisplay().asyncExec(this::checkBufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamsClosed() {
        this.consoleClosedPartition = new PendingPartition(null, null);
        ArrayList<PendingPartition> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            this.pendingPartitions.add(this.consoleClosedPartition);
        }
        this.queueJob.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.document = null;
            this.partitions.clear();
            this.connected = false;
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{IOConsolePartition.OUTPUT_PARTITION_TYPE, IOConsolePartition.INPUT_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        return this.getPartition(offset).getType();
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        return this.computeIOPartitioning(offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOConsolePartition[] computeIOPartitioning(int offset, int length) {
        ArrayList<IOConsolePartition> result = new ArrayList<IOConsolePartition>();
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            int index = this.findPartitionCandidate(offset);
            if (index < 0) {
                index = 0;
            }
            int end = offset + length;
            while (index < this.partitions.size()) {
                IOConsolePartition partition = this.partitions.get(index);
                if (partition.getOffset() >= end) break;
                result.add(partition);
                ++index;
            }
        }
        return result.toArray(new IOConsolePartition[0]);
    }

    public ITypedRegion getPartition(int offset) {
        IOConsolePartition partition = this.getIOPartition(offset);
        return partition != null ? partition : new TypedRegion(offset, 0, IOConsolePartition.INPUT_PARTITION_TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IOConsolePartition getIOPartition(int offset) {
        ArrayList<IOConsolePartition> arrayList = this.partitions;
        synchronized (arrayList) {
            IOConsolePartition partition;
            int index = this.findPartitionCandidate(offset);
            if (index >= 0 && (partition = this.partitions.get(index)).getOffset() + partition.getLength() > offset) {
                return partition;
            }
            return null;
        }
    }

    private int findPartitionCandidate(int offset) {
        Region target = new Region(offset, 0);
        int index = Collections.binarySearch(this.partitions, target, CMP_REGION_BY_OFFSET);
        if (index >= 0) {
            return index;
        }
        return -index - 2;
    }

    private void checkBufferSize() {
        int length;
        if (this.document != null && this.highWaterMark > 0 && (length = this.document.getLength()) > this.highWaterMark && this.trimJob.getState() == 0) {
            this.trimJob.setOffset(length - this.lowWaterMark);
            this.trimJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBuffer() {
        Object object = this.overflowLock;
        synchronized (object) {
            this.trimJob.setOffset(-1);
            this.trimJob.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion documentChanged2(DocumentEvent event) {
        if (this.document == null) {
            return null;
        }
        if (this.document.getLength() == 0) {
            ArrayList<IOConsolePartition> arrayList = this.partitions;
            synchronized (arrayList) {
                this.partitions.clear();
                this.inputPartitions.clear();
            }
            return new Region(0, 0);
        }
        if (this.updateInProgress) {
            ArrayList<IOConsolePartition> arrayList = this.partitions;
            synchronized (arrayList) {
                if (this.updatePartitions != null) {
                    IOConsolePartition lastPartition = this.getPartitionByIndex(this.partitions.size() - 1);
                    for (PendingPartition pp : this.updatePartitions) {
                        if (pp == this.consoleClosedPartition) continue;
                        int ppLen = pp.text.length();
                        if (lastPartition != null && lastPartition.getOutputStream() == pp.stream) {
                            int len = lastPartition.getLength();
                            lastPartition.setLength(len + ppLen);
                        } else {
                            IOConsolePartition partition = new IOConsolePartition(this.firstOffset, pp.stream);
                            partition.setLength(ppLen);
                            lastPartition = partition;
                            this.partitions.add(partition);
                        }
                        this.firstOffset += ppLen;
                    }
                }
            }
        } else {
            ArrayList<IOConsolePartition> arrayList = this.partitions;
            synchronized (arrayList) {
                return this.applyUserInput(event);
            }
        }
        return new Region(event.fOffset, event.fText.length());
    }

    private IRegion applyUserInput(DocumentEvent event) {
        IOConsolePartition partition;
        int eventPartitionIndex;
        int eventTextLength = event.getText() != null ? event.getText().length() : 0;
        int offset = event.getOffset();
        int amountDeleted = event.getLength();
        if (amountDeleted == 0 && eventTextLength == 0) {
            return null;
        }
        int lastPartitionWithValidOffset = eventPartitionIndex = this.findPartitionCandidate(offset);
        if (amountDeleted > 0 && eventPartitionIndex >= 0) {
            int toDelete = amountDeleted;
            int i = eventPartitionIndex;
            while (i < this.partitions.size() && toDelete > 0) {
                partition = this.partitions.get(i);
                int removeLength = Math.min(partition.getLength(), toDelete);
                partition.setLength(partition.getLength() - removeLength);
                toDelete -= removeLength;
                ++i;
            }
            --lastPartitionWithValidOffset;
        }
        if (eventTextLength > 0) {
            int inputPartitionIndex = eventPartitionIndex;
            IOConsolePartition inputPartition = this.getPartitionByIndex(inputPartitionIndex);
            if (inputPartition != null && inputPartition.isReadOnly() && offset == inputPartition.getOffset()) {
                --lastPartitionWithValidOffset;
                inputPartition = this.getPartitionByIndex(--inputPartitionIndex);
            }
            int textOffset = 0;
            while (textOffset < eventTextLength) {
                int[] result = TextUtilities.indexOf((String[])this.lld, (String)event.getText(), (int)textOffset);
                boolean foundNewline = result[1] >= 0;
                int newTextOffset = foundNewline ? result[0] + this.lld[result[1]].length() : eventTextLength;
                int inputLength = newTextOffset - textOffset;
                if (inputPartition == null || inputPartition.isReadOnly()) {
                    int inputOffset = offset + textOffset;
                    if (inputPartition != null && inputOffset < inputPartition.getOffset() + inputPartition.getLength()) {
                        this.splitPartition(inputOffset);
                    }
                    inputPartition = new IOConsolePartition(inputOffset, this.inputStream);
                    this.partitions.add(++inputPartitionIndex, inputPartition);
                    this.inputPartitions.add(inputPartition);
                    ++lastPartitionWithValidOffset;
                }
                inputPartition.setLength(inputPartition.getLength() + inputLength);
                if (foundNewline) {
                    this.inputPartitions.sort(CMP_REGION_BY_OFFSET);
                    StringBuilder inputLine = new StringBuilder();
                    for (IOConsolePartition p : this.inputPartitions) {
                        try {
                            String fragment = this.document.get(p.getOffset(), p.getLength());
                            inputLine.append(fragment);
                        }
                        catch (BadLocationException e) {
                            IOConsolePartitioner.log(e);
                        }
                        p.setReadOnly();
                    }
                    this.inputPartitions.clear();
                    this.inputStream.appendData(inputLine.toString());
                }
                Assert.isTrue((newTextOffset > textOffset ? 1 : 0) != 0);
                textOffset = newTextOffset;
            }
        }
        int newOffset = 0;
        if (lastPartitionWithValidOffset >= 0) {
            IOConsolePartition partition2 = this.partitions.get(lastPartitionWithValidOffset);
            newOffset = partition2.getOffset() + partition2.getLength();
        }
        ListIterator<IOConsolePartition> it = this.partitions.listIterator(lastPartitionWithValidOffset + 1);
        while (it.hasNext()) {
            partition = (IOConsolePartition)it.next();
            if (partition.getLength() <= 0) {
                it.remove();
                if (!IOConsolePartitioner.isInputPartition(partition)) continue;
                boolean bl = this.inputPartitions.remove(partition);
                continue;
            }
            partition.setOffset(newOffset);
            newOffset += partition.getLength();
        }
        return new Region(0, this.document.getLength());
    }

    private IOConsolePartition splitPartition(int offset) {
        IOConsolePartition newPartition;
        int partitionIndex = this.findPartitionCandidate(offset);
        IOConsolePartition existingPartition = this.partitions.get(partitionIndex);
        if (IOConsolePartitioner.isInputPartition(existingPartition)) {
            newPartition = new IOConsolePartition(offset, existingPartition.getInputStream());
            if (existingPartition.isReadOnly()) {
                newPartition.setReadOnly();
            }
            if (this.inputPartitions.contains(existingPartition)) {
                this.inputPartitions.add(newPartition);
            }
        } else {
            newPartition = new IOConsolePartition(offset, existingPartition.getOutputStream());
        }
        newPartition.setLength(existingPartition.getOffset() + existingPartition.getLength() - offset);
        existingPartition.setLength(offset - existingPartition.getOffset());
        this.partitions.add(partitionIndex + 1, newPartition);
        return newPartition;
    }

    private void setUpdateInProgress(boolean b) {
        this.updateInProgress = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamAppended(IOConsoleOutputStream stream, String s) throws IOException {
        if (this.document == null) {
            throw new IOException("Document is closed");
        }
        ArrayList<PendingPartition> arrayList = this.pendingPartitions;
        synchronized (arrayList) {
            PendingPartition last;
            PendingPartition pendingPartition = last = this.pendingPartitions.size() > 0 ? this.pendingPartitions.get(this.pendingPartitions.size() - 1) : null;
            if (last != null && last.stream == stream) {
                last.append(s);
            } else {
                this.pendingPartitions.add(new PendingPartition(stream, s));
                if (this.fBuffer > 1000) {
                    this.queueJob.schedule();
                } else {
                    this.queueJob.schedule(50L);
                }
            }
            if (this.fBuffer > 160000) {
                if (Display.getCurrent() == null) {
                    try {
                        this.pendingPartitions.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                } else {
                    this.processQueue();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processQueue() {
        Object object = this.overflowLock;
        synchronized (object) {
            ArrayList<PendingPartition> pendingCopy = new ArrayList<PendingPartition>();
            StringBuilder buffer = null;
            boolean consoleClosed = false;
            ArrayList<PendingPartition> arrayList = this.pendingPartitions;
            synchronized (arrayList) {
                pendingCopy.addAll(this.pendingPartitions);
                this.pendingPartitions.clear();
                this.fBuffer = 0;
                this.pendingPartitions.notifyAll();
            }
            int size = 0;
            for (PendingPartition pp : pendingCopy) {
                if (pp == this.consoleClosedPartition) continue;
                size += pp.text.length();
            }
            buffer = new StringBuilder(size);
            for (PendingPartition pp : pendingCopy) {
                if (pp != this.consoleClosedPartition) {
                    buffer.append((CharSequence)pp.text);
                    continue;
                }
                consoleClosed = true;
            }
            if (this.connected) {
                this.setUpdateInProgress(true);
                this.updatePartitions = pendingCopy;
                this.firstOffset = this.document.getLength();
                try {
                    if (buffer != null) {
                        this.document.replace(this.firstOffset, 0, buffer.toString());
                    }
                }
                catch (BadLocationException badLocationException) {}
                this.updatePartitions = null;
                this.setUpdateInProgress(false);
            }
            if (consoleClosed) {
                this.console.partitionerFinished();
            }
            this.checkBufferSize();
        }
    }

    @Override
    public boolean isReadOnly(int offset) {
        IOConsolePartition partition = this.getIOPartition(offset);
        return partition != null ? partition.isReadOnly() : false;
    }

    @Override
    public StyleRange[] getStyleRanges(int offset, int length) {
        if (!this.connected) {
            return new StyleRange[0];
        }
        IOConsolePartition[] computedPartitions = this.computeIOPartitioning(offset, length);
        StyleRange[] styles = new StyleRange[computedPartitions.length];
        int i = 0;
        while (i < computedPartitions.length) {
            int rangeStart = Math.max(computedPartitions[i].getOffset(), offset);
            int rangeLength = computedPartitions[i].getLength();
            styles[i] = computedPartitions[i].getStyleRange(rangeStart, rangeLength);
            ++i;
        }
        return styles;
    }

    private IOConsolePartition getPartitionByIndex(int index) {
        return index >= 0 && index < this.partitions.size() ? this.partitions.get(index) : null;
    }

    private static boolean isInputPartition(IOConsolePartition partition) {
        return IOConsolePartition.INPUT_PARTITION_TYPE.equals(partition.getType());
    }

    private static void log(Throwable t) {
        ConsolePlugin.log(t);
    }

    private void checkPartitions() {
        if (!this.connected) {
            return;
        }
        ArrayList<IOConsolePartition> knownInputPartitions = new ArrayList<IOConsolePartition>(this.inputPartitions);
        int offset = 0;
        for (IOConsolePartition partition : this.partitions) {
            Assert.isTrue((offset == partition.getOffset() ? 1 : 0) != 0);
            Assert.isTrue((partition.getLength() > 0 ? 1 : 0) != 0);
            offset += partition.getLength();
            if (!IOConsolePartitioner.isInputPartition(partition) || partition.isReadOnly()) continue;
            Assert.isTrue((boolean)knownInputPartitions.remove(partition));
        }
        Assert.isTrue((offset == this.document.getLength() ? 1 : 0) != 0);
        Assert.isTrue((boolean)knownInputPartitions.isEmpty());
    }

    private class PendingPartition {
        StringBuilder text = new StringBuilder(8192);
        IOConsoleOutputStream stream;

        PendingPartition(IOConsoleOutputStream stream, String text) {
            this.stream = stream;
            if (text != null) {
                this.append(text);
            }
        }

        void append(String moreText) {
            this.text.append(moreText);
            IOConsolePartitioner iOConsolePartitioner = IOConsolePartitioner.this;
            iOConsolePartitioner.fBuffer = iOConsolePartitioner.fBuffer + moreText.length();
        }
    }

    private class QueueProcessingJob
    extends UIJob {
        QueueProcessingJob() {
            super("IOConsole Updater");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            IOConsolePartitioner.this.processQueue();
            return Status.OK_STATUS;
        }

        public boolean shouldRun() {
            boolean shouldRun = IOConsolePartitioner.this.connected && IOConsolePartitioner.this.pendingPartitions != null && IOConsolePartitioner.this.pendingPartitions.size() > 0;
            return shouldRun;
        }
    }

    private class TrimJob
    extends WorkbenchJob {
        private int truncateOffset;

        TrimJob() {
            super("Trim Job");
            this.setSystem(true);
        }

        public void setOffset(int offset) {
            this.truncateOffset = offset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (IOConsolePartitioner.this.document == null) {
                return Status.OK_STATUS;
            }
            int length = IOConsolePartitioner.this.document.getLength();
            if (this.truncateOffset < length) {
                Object object = IOConsolePartitioner.this.overflowLock;
                synchronized (object) {
                    try {
                        if (this.truncateOffset < 0) {
                            IOConsolePartitioner.this.setUpdateInProgress(true);
                            IOConsolePartitioner.this.document.set("");
                            IOConsolePartitioner.this.setUpdateInProgress(false);
                        } else {
                            int cutoffLine = IOConsolePartitioner.this.document.getLineOfOffset(this.truncateOffset);
                            int cutOffset = IOConsolePartitioner.this.document.getLineOffset(cutoffLine);
                            IOConsolePartition partition = (IOConsolePartition)IOConsolePartitioner.this.getPartition(cutOffset);
                            partition.setLength(partition.getOffset() + partition.getLength() - cutOffset);
                            IOConsolePartitioner.this.setUpdateInProgress(true);
                            IOConsolePartitioner.this.document.replace(0, cutOffset, "");
                            IOConsolePartitioner.this.setUpdateInProgress(false);
                            int index = IOConsolePartitioner.this.partitions.indexOf(partition);
                            int i = 0;
                            while (i < index) {
                                IOConsolePartitioner.this.partitions.remove(0);
                                ++i;
                            }
                            int offset = 0;
                            for (IOConsolePartition p : IOConsolePartitioner.this.partitions) {
                                p.setOffset(offset);
                                offset += p.getLength();
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return Status.OK_STATUS;
        }
    }
}

