/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.test.condition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.core.condition.ShellMatchingMatcherIsAvailable;
import org.eclipse.reddeer.core.test.condition.ShellTestBase;
import org.eclipse.reddeer.core.test.condition.matchers.ContainsStyledTextMatcher;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class ShellMatchingMatcherIsAvailableTest
extends ShellTestBase {
    Map<DefaultShell, WaitCondition> conditions = new HashMap<DefaultShell, WaitCondition>();
    List<WaitCondition> expectedAvailable = new ArrayList<WaitCondition>();
    List<WaitCondition> expectedNotAvailable = new ArrayList<WaitCondition>();

    @Before
    public void prepareTestedConditions() {
        for (DefaultShell shell : this.getTestShells()) {
            String expectedContent = this.getExpectedContent(shell);
            ShellMatchingMatcherIsAvailable available = new ShellMatchingMatcherIsAvailable(new Matcher[]{new ContainsStyledTextMatcher(expectedContent)});
            this.conditions.put(shell, (WaitCondition)available);
        }
        this.expectedNotAvailable.addAll(this.conditions.values());
    }

    @Test
    public void testShellContainsStyledText() {
        this.assertAvailable(this.expectedAvailable);
        this.assertNotAvailable(this.expectedNotAvailable);
        for (DefaultShell shell : this.getTestShells()) {
            this.insertStyledText(shell);
            WaitCondition condition = this.conditions.get(shell);
            this.expectedNotAvailable.remove(condition);
            this.expectedAvailable.add(condition);
            this.assertAvailable(this.expectedAvailable);
            this.assertNotAvailable(this.expectedNotAvailable);
        }
    }

    @Test
    public void testShellGetResult() {
        for (DefaultShell shell : this.getTestShells()) {
            WaitCondition condition = this.conditions.get(shell);
            condition.test();
            Assert.assertNull((Object)condition.getResult());
            this.insertStyledText(shell);
            condition.test();
            Assert.assertTrue((boolean)((Shell)shell.getSWTWidget()).equals(condition.getResult()));
        }
    }

    private String getExpectedContent(DefaultShell shell) {
        return String.valueOf(shell.getText()) + " Styled text";
    }

    private void assertAvailable(List<WaitCondition> conditions) {
        for (WaitCondition condition : conditions) {
            Assert.assertTrue((boolean)condition.test());
        }
    }

    private void assertNotAvailable(List<WaitCondition> conditions) {
        for (WaitCondition condition : conditions) {
            Assert.assertFalse((boolean)condition.test());
        }
    }

    private void insertStyledText(DefaultShell shell) {
        String textContent = this.getExpectedContent(shell);
        Display.syncExec(() -> {
            ((Shell)shell.getSWTWidget()).setLayout((Layout)new GridLayout());
            StyledText styledText = new StyledText((Composite)shell.getSWTWidget(), 2);
            styledText.setText(textContent);
            GridData data = new GridData(4, 4, true, true);
            data.heightHint = 100;
            styledText.setLayoutData((Object)data);
            ((Shell)shell.getSWTWidget()).layout();
        });
    }
}

