/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.view.servers.AbstractServerAction;

public class RenameAction
extends AbstractServerAction {
    protected TreeEditor treeEditor;
    protected Tree tree;
    protected Text textEditor;
    protected Composite textEditorParent;
    private TextActionHandler textActionHandler;
    protected IServer editedServer;
    protected boolean saving = false;

    public RenameAction(Shell shell, TreeViewer viewer, ISelectionProvider selectionProvider) {
        super(shell, selectionProvider, Messages.actionRename);
        this.setActionDefinitionId("org.eclipse.ui.edit.rename");
        this.tree = viewer.getTree();
        this.treeEditor = new TreeEditor(this.tree);
        try {
            this.selectionChanged((IStructuredSelection)selectionProvider.getSelection());
        }
        catch (Exception exception) {}
    }

    public void perform(IServer server) {
        this.runWithInlineEditor(server);
    }

    private void runWithInlineEditor(IServer server) {
        this.queryNewServerNameInline(server);
    }

    private static int getCellEditorInset(Control c) {
        if ("carbon".equals(SWT.getPlatform()) && (System.getProperty("org.eclipse.swt.internal.carbon.noFocusRing") == null || c.getShell().getParent() != null)) {
            return -2;
        }
        return 1;
    }

    private Tree getTree() {
        return this.tree;
    }

    private Composite createParent() {
        Tree tree2 = this.getTree();
        Composite result = new Composite((Composite)tree2, 0);
        TreeItem[] selectedItems = tree2.getSelection();
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void queryNewServerNameInline(IServer server) {
        if (this.textEditorParent == null) {
            this.createTextEditor(server);
        }
        this.textEditor.setText(server.getName());
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = RenameAction.getCellEditorInset((Control)this.textEditorParent);
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    private void createTextEditor(final IServer server) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        final int inset = RenameAction.getCellEditorInset((Control)this.textEditorParent);
        if (inset > 0) {
            this.textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point textSize = RenameAction.this.textEditor.getSize();
                    Point parentSize = RenameAction.this.textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.tree.getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameAction.this.textEditorParent.getSize();
                RenameAction.this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
                RenameAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameAction.this.saveChangesAndDispose(server);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameAction.this.saveChangesAndDispose(server);
            }
        });
        if (this.textActionHandler != null) {
            this.textActionHandler.addText(this.textEditor);
        }
    }

    protected void disposeTextWidget() {
        if (this.textActionHandler != null) {
            this.textActionHandler.removeText(this.textEditor);
        }
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            this.treeEditor.setEditor(null, null);
        }
    }

    protected void saveChangesAndDispose(IServer server) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        this.editedServer = server;
        final String newName = this.textEditor.getText();
        this.getTree().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    if (!newName.equals(RenameAction.this.editedServer.getName())) {
                        if (ServerPlugin.isNameOnlyInUse((Object)RenameAction.this.editedServer, (String)newName)) {
                            MessageDialog.openError((Shell)RenameAction.this.shell, (String)Messages.defaultDialogTitle, (String)Messages.errorDuplicateName);
                        } else {
                            try {
                                IServerWorkingCopy wc = RenameAction.this.editedServer.createWorkingCopy();
                                wc.setName(newName);
                                wc.save(false, null);
                            }
                            catch (CoreException coreException) {}
                        }
                    }
                    RenameAction.this.editedServer = null;
                    RenameAction.this.disposeTextWidget();
                    if (RenameAction.this.tree != null && !RenameAction.this.tree.isDisposed()) {
                        RenameAction.this.tree.setFocus();
                    }
                }
                finally {
                    RenameAction.this.saving = false;
                }
            }
        });
    }
}

