/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.pde.core.ISourceObject;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.DependencyExtentSearchResult;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.Match;

public class DependencyExtentOperation {
    private DependencyExtentSearchResult fSearchResult;
    private String fImportID;
    private IPluginModelBase fModel;
    private IProject fProject;

    public DependencyExtentOperation(IProject project, String importID, ISearchResult searchResult) {
        this.fSearchResult = (DependencyExtentSearchResult)searchResult;
        this.fProject = project;
        this.fImportID = importID;
        this.fModel = PluginRegistry.findModel((IProject)project);
    }

    public void execute(IProgressMonitor monitor) {
        IPluginModelBase[] plugins = PluginJavaSearchUtil.getPluginImports((String)this.fImportID);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)(String.valueOf(PDEUIMessages.DependencyExtentOperation_searching) + " " + this.fImportID + "..."), (int)10);
        this.checkForJavaDependencies(plugins, (IProgressMonitor)subMonitor.split(9));
        subMonitor.setWorkRemaining(plugins.length);
        IPluginModelBase[] iPluginModelBaseArray = plugins;
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase plugin = iPluginModelBaseArray[n2];
            this.checkForExtensionPointsUsed(plugin);
            subMonitor.worked(1);
            ++n2;
        }
    }

    private void checkForExtensionPointsUsed(IPluginModelBase model) {
        IPluginExtensionPoint[] extPoints;
        IPluginExtensionPoint[] iPluginExtensionPointArray = extPoints = model.getPluginBase().getExtensionPoints();
        int n = extPoints.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtensionPoint extPoint = iPluginExtensionPointArray[n2];
            this.findMatches(extPoint);
            ++n2;
        }
    }

    private void findMatches(IPluginExtensionPoint point) {
        IPluginExtension[] extensions;
        String fullID = point.getFullId();
        if (fullID == null) {
            return;
        }
        IPluginExtension[] iPluginExtensionArray = extensions = this.fModel.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            int line;
            IPluginExtension extension = iPluginExtensionArray[n2];
            if (fullID.equals(extension.getPoint()) && (line = ((ISourceObject)extension).getStartLine() - 1) >= 0) {
                this.fSearchResult.addMatch(new Match((Object)point, 1, line, 1));
                break;
            }
            ++n2;
        }
    }

    private void checkForJavaDependencies(IPluginModelBase[] models, IProgressMonitor monitor) {
        try {
            if (!this.fProject.hasNature("org.eclipse.jdt.core.javanature")) {
                return;
            }
            IJavaProject jProject = JavaCore.create((IProject)this.fProject);
            IPackageFragment[] packageFragments = PluginJavaSearchUtil.collectPackageFragments((IPluginModelBase[])models, (IJavaProject)jProject, (boolean)true);
            monitor.beginTask("", packageFragments.length);
            SearchEngine engine = new SearchEngine();
            IPackageFragment[] iPackageFragmentArray = packageFragments;
            int n = packageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment pkgFragment = iPackageFragmentArray[n2];
                if (!monitor.isCanceled()) {
                    monitor.subTask(String.valueOf(PDEUIMessages.DependencyExtentOperation_inspecting) + " " + pkgFragment.getElementName());
                    if (pkgFragment.hasChildren()) {
                        IJavaElement[] children;
                        IJavaElement[] iJavaElementArray = children = pkgFragment.getChildren();
                        int n3 = children.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IJavaElement child = iJavaElementArray[n4];
                            if (monitor.isCanceled()) break;
                            IType[] types = new IType[]{};
                            if (child instanceof IOrdinaryClassFile) {
                                types = new IType[]{((IOrdinaryClassFile)child).getType()};
                            } else if (child instanceof ICompilationUnit) {
                                types = ((ICompilationUnit)child).getTypes();
                            }
                            if (types.length > 0) {
                                this.searchForTypesUsed(engine, child, types, PluginJavaSearchUtil.createSeachScope((IJavaProject)jProject));
                            }
                            ++n4;
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (CoreException coreException) {}
    }

    private void searchForTypesUsed(SearchEngine engine, IJavaElement parent, IType[] types, IJavaSearchScope scope) throws CoreException {
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (!type.isAnonymous()) {
                TypeReferenceSearchRequestor requestor = new TypeReferenceSearchRequestor();
                engine.search(SearchPattern.createPattern((IJavaElement)type, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
                if (requestor.containMatches()) {
                    TypeDeclarationSearchRequestor decRequestor = new TypeDeclarationSearchRequestor();
                    engine.search(SearchPattern.createPattern((IJavaElement)type, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{parent}), (SearchRequestor)decRequestor, null);
                    Match match = decRequestor.getMatch();
                    if (match != null) {
                        this.fSearchResult.addMatch(match);
                    }
                }
            }
            ++n2;
        }
    }

    class TypeDeclarationSearchRequestor
    extends SearchRequestor {
        private Match fMatch;

        TypeDeclarationSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (!match.isInsideDocComment()) {
                this.fMatch = new Match(match.getElement(), 2, match.getOffset(), match.getLength());
            }
        }

        public Match getMatch() {
            return this.fMatch;
        }
    }

    class TypeReferenceSearchRequestor
    extends SearchRequestor {
        boolean fUsed = false;

        TypeReferenceSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            if (match.getAccuracy() == 0 && !match.isInsideDocComment()) {
                this.fUsed = true;
            }
        }

        public boolean containMatches() {
            return this.fUsed;
        }
    }
}

