/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.MenuService;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.IObjectActionContributor;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class PopupMenuExtender
implements IMenuListener2,
IRegistryChangeListener {
    private static final int STATIC_ACTION_READ = 1;
    private static final int INCLUDE_EDITOR_INPUT = 2;
    public static final String POPUP_EXTENDER_MODEL_ID = "popupExtenderModelId";
    private final MenuManager menu;
    private SubMenuManager menuWrapper;
    private final ISelectionProvider selProvider;
    private final IWorkbenchPart part;
    private Map<String, ViewerActionBuilder> staticActionBuilders = null;
    private int bitSet = 0;
    private ArrayList<PluginActionContributionItem> actionContributionCache = new ArrayList();
    private boolean cleanupNeeded = false;
    private MPart modelPart;
    private IEclipseContext context;
    private MPopupMenu menuModel;

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part, IEclipseContext context) {
        this(id, menu, prov, part, context, true);
    }

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part, IEclipseContext context, boolean includeEditorInput) {
        this.menu = menu;
        this.selProvider = prov;
        this.part = part;
        this.context = context;
        this.modelPart = (MPart)part.getSite().getService(MPart.class);
        if (includeEditorInput) {
            this.bitSet |= 2;
        }
        menu.addMenuListener((IMenuListener)this);
        if (!menu.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager((IMenuManager)menu);
            this.menuWrapper.setVisible(true);
        }
        this.createModelFor(id);
        this.addMenuId(id);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    private void createModelFor(String id) {
        IRendererFactory factory;
        AbstractPartRenderer obj;
        if (id == null) {
            id = String.valueOf(this.getClass().getName()) + '.' + System.identityHashCode(this);
        }
        Object popupModelId = this.context == null ? null : this.context.get(POPUP_EXTENDER_MODEL_ID);
        this.menuModel = null;
        for (MMenu item : this.modelPart.getMenus()) {
            if (!id.equals(item.getElementId()) || !(item instanceof MPopupMenu) || !item.getTags().contains("menuContribution:popup") || popupModelId != null && !item.getTags().contains(popupModelId)) continue;
            this.menuModel = (MPopupMenu)item;
            break;
        }
        if (this.menuModel == null) {
            this.menuModel = MenuFactoryImpl.eINSTANCE.createPopupMenu();
            this.menuModel.getPersistedState().put("persistState", Boolean.FALSE.toString());
            this.menuModel.setElementId(id);
            this.menuModel.getTags().add("menuContribution:popup");
            if (popupModelId != null) {
                this.menuModel.getTags().add(Objects.toString(popupModelId));
            }
            this.modelPart.getMenus().add(this.menuModel);
        }
        if ((obj = (factory = (IRendererFactory)this.modelPart.getContext().get(IRendererFactory.class)).getRenderer((MUIElement)this.menuModel, null)) instanceof MenuManagerRenderer) {
            ((MenuManagerRenderer)obj).linkModelToManager((MMenu)this.menuModel, this.menu);
        }
        this.registerE4Support();
        this.cleanUpContributionCache();
    }

    private void registerE4Support() {
        if (this.menuModel.getWidget() == null && this.menu.getMenu() != null) {
            MenuService.registerMenu((Control)this.menu.getMenu().getParent(), (MPopupMenu)this.menuModel, (IEclipseContext)this.context);
        }
    }

    public Set<String> getMenuIds() {
        if (this.staticActionBuilders == null) {
            return Collections.emptySet();
        }
        return this.staticActionBuilders.keySet();
    }

    public final void addMenuId(String menuId) {
        String tag;
        List tags;
        this.bitSet &= 0xFFFFFFFE;
        if (this.menuModel != null && !(tags = this.menuModel.getTags()).contains(tag = "popup:" + menuId)) {
            tags.add(tag);
        }
        this.readStaticActionsFor(menuId);
    }

    public final boolean matches(MenuManager menuManager, ISelectionProvider selectionProvider, IWorkbenchPart part) {
        return this.menu == menuManager && this.selProvider == selectionProvider && this.part == part;
    }

    private void addEditorActions(IMenuManager mgr, Set<IObjectActionContributor> alreadyContributed) {
        ISelectionProvider activeEditor = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public ISelection getSelection() {
                if (PopupMenuExtender.this.part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)PopupMenuExtender.this.part;
                    return new StructuredSelection(new Object[]{editorPart.getEditorInput()});
                }
                return new StructuredSelection(new Object[0]);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public void setSelection(ISelection selection) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
        if (ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, activeEditor, alreadyContributed)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addObjectActions(IMenuManager mgr, Set<IObjectActionContributor> alreadyContributed) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, this.selProvider, alreadyContributed)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private final void clearStaticActions() {
        this.bitSet &= 0xFFFFFFFE;
        if (this.staticActionBuilders != null) {
            for (ViewerActionBuilder staticActionBuilder : this.staticActionBuilders.values()) {
                staticActionBuilder.dispose();
            }
        }
    }

    private void addStaticActions(IMenuManager mgr) {
        if (this.staticActionBuilders != null) {
            for (ViewerActionBuilder staticActionBuilder : this.staticActionBuilders.values()) {
                staticActionBuilder.contribute(mgr, null, true);
            }
        }
    }

    public void menuAboutToShow(IMenuManager mgr) {
        IWorkbench workbench;
        this.registerE4Support();
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            Workbench realWorkbench = (Workbench)workbench;
            this.runCleanUp(realWorkbench);
            StructuredSelection input = null;
            if ((this.bitSet & 2) != 0 && this.part instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)this.part;
                input = new StructuredSelection(new Object[]{editorPart.getEditorInput()});
            }
            ISelection s = this.selProvider == null ? null : this.selProvider.getSelection();
            realWorkbench.addShowingMenus(this.getMenuIds(), s, (ISelection)input);
        }
        this.addMenuContributions(mgr);
        this.readStaticActions();
        if (this.menuWrapper != null) {
            mgr = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        HashSet<IObjectActionContributor> contributedItems = new HashSet<IObjectActionContributor>();
        if ((this.bitSet & 2) != 0) {
            this.addEditorActions(mgr, contributedItems);
        }
        this.addObjectActions(mgr, contributedItems);
        this.addStaticActions(mgr);
    }

    private void addMenuContributions(IMenuManager mgr) {
        IRendererFactory factory = (IRendererFactory)this.modelPart.getContext().get(IRendererFactory.class);
        AbstractPartRenderer obj = factory.getRenderer((MUIElement)this.menuModel, null);
        if (obj instanceof MenuManagerRenderer) {
            MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
            renderer.reconcileManagerToModel(this.menu, (MMenu)this.menuModel);
            renderer.processContributions((MMenu)this.menuModel, this.menuModel.getElementId(), false, true);
            renderer.processContents((MElementContainer)this.menuModel);
        }
    }

    public final void menuAboutToHide(IMenuManager mgr) {
        IWorkbench workbench;
        this.gatherContributions(mgr);
        this.cleanupNeeded = true;
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            workbench.getDisplay().asyncExec(() -> {
                Workbench realWorkbench = (Workbench)workbench;
                this.runCleanUp(realWorkbench);
            });
        }
    }

    private void runCleanUp(Workbench realWorkbench) {
        if (!this.cleanupNeeded) {
            return;
        }
        this.cleanupNeeded = false;
        realWorkbench.removeShowingMenus(this.getMenuIds(), null, null);
        this.cleanUpContributionCache();
    }

    private void gatherContributions(IMenuManager mgr) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = mgr.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof PluginActionContributionItem) {
                this.actionContributionCache.add((PluginActionContributionItem)item);
            } else if (item instanceof IMenuManager) {
                this.gatherContributions((IMenuManager)item);
            }
            ++n2;
        }
    }

    private void cleanUpContributionCache() {
        AbstractPartRenderer obj;
        IRendererFactory factory;
        if (!this.actionContributionCache.isEmpty()) {
            PluginActionContributionItem[] items = this.actionContributionCache.toArray(new PluginActionContributionItem[this.actionContributionCache.size()]);
            this.actionContributionCache.clear();
            PluginActionContributionItem[] pluginActionContributionItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                PluginActionContributionItem item = pluginActionContributionItemArray[n2];
                item.dispose();
                ++n2;
            }
        }
        if (this.modelPart == null || this.menuModel == null) {
            return;
        }
        IEclipseContext modelContext = this.modelPart.getContext();
        if (modelContext != null && (factory = (IRendererFactory)modelContext.get(IRendererFactory.class)) != null && (obj = factory.getRenderer((MUIElement)this.menuModel, null)) instanceof MenuManagerRenderer) {
            MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
            renderer.cleanUp((MMenu)this.menuModel);
        }
    }

    private final void readStaticActions() {
        if (this.staticActionBuilders != null) {
            for (String menuId : this.staticActionBuilders.keySet()) {
                this.readStaticActionsFor(menuId);
            }
        }
    }

    private void readStaticActionsFor(String menuId) {
        ViewerActionBuilder builder;
        if ((this.bitSet & 1) != 0) {
            return;
        }
        this.bitSet |= 1;
        if (menuId == null || menuId.length() < 1) {
            return;
        }
        if (this.staticActionBuilders == null) {
            this.staticActionBuilders = new HashMap<String, ViewerActionBuilder>();
        }
        if ((builder = this.staticActionBuilders.get(menuId)) == null) {
            builder = new ViewerActionBuilder();
            this.staticActionBuilders.put(menuId, builder);
        }
        builder.readViewerContributions(menuId, this.selProvider, this.part);
    }

    public void dispose() {
        this.clearStaticActions();
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        this.menu.removeMenuListener((IMenuListener)this);
        if (this.menuModel != null) {
            IRendererFactory factory = (IRendererFactory)this.modelPart.getContext().get(IRendererFactory.class);
            AbstractPartRenderer obj = factory.getRenderer((MUIElement)this.menuModel, null);
            if (obj instanceof MenuManagerRenderer) {
                MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
                this.unlink(renderer, (MMenu)this.menuModel);
                renderer.clearModelToManager((MMenu)this.menuModel, this.menu);
            }
            this.modelPart.getMenus().remove(this.menuModel);
        }
    }

    private void unlink(MenuManagerRenderer renderer, MMenu menu) {
        for (MMenuElement menuElement : menu.getChildren()) {
            if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)menuElement) || OpaqueElementUtil.isOpaqueMenuSeparator((MUIElement)menuElement)) {
                Object item = OpaqueElementUtil.getOpaqueItem((MUIElement)menuElement);
                if (!(item instanceof IContributionItem)) continue;
                renderer.clearModelToContribution(menuElement, (IContributionItem)item);
                OpaqueElementUtil.clearOpaqueItem((MUIElement)menuElement);
                continue;
            }
            if (menuElement instanceof MMenu) {
                MMenu subMenu = (MMenu)menuElement;
                this.unlink(renderer, subMenu);
                MenuManager manager = renderer.getManager(subMenu);
                if (manager == null) continue;
                renderer.clearModelToManager(subMenu, manager);
                continue;
            }
            IContributionItem contribution = renderer.getContribution(menuElement);
            if (contribution == null) continue;
            renderer.clearModelToContribution(menuElement, contribution);
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas;
        Display display = Display.getDefault();
        if (this.part != null) {
            display = this.part.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
        }
        IExtensionDelta[] iExtensionDeltaArray = deltas = event.getExtensionDeltas();
        int n = deltas.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta delta = iExtensionDeltaArray[n2];
            IExtensionPoint extensionPoint = delta.getExtensionPoint();
            if (extensionPoint.getContributor().getName().equals(WorkbenchPlugin.PI_WORKBENCH) && extensionPoint.getSimpleIdentifier().equals("popupMenus")) {
                IConfigurationElement[] elements;
                boolean clearPopups = false;
                IConfigurationElement[] iConfigurationElementArray = elements = delta.getExtension().getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("viewerContribution")) {
                        clearPopups = true;
                        break;
                    }
                    ++n4;
                }
                if (clearPopups) {
                    display.syncExec(() -> this.clearStaticActions());
                }
            }
            ++n2;
        }
    }

    public MenuManager getManager() {
        return this.menu;
    }
}

