/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.publisher.Messages;
import org.eclipse.equinox.internal.p2.publisher.eclipse.GeneratorBundleInfo;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.AdviceFileAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherAdvice;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.IBundleShapeAdvice;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.publishing.Activator;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRequirement;

public class BundlesAction
extends AbstractPublisherAction {
    public static final String TYPE_ECLIPSE_BUNDLE = "bundle";
    public static final String TYPE_ECLIPSE_SOURCE = "source";
    public static final String OSGI_BUNDLE_CLASSIFIER = "osgi.bundle";
    public static final String CAPABILITY_NS_OSGI_BUNDLE = "osgi.bundle";
    public static final String CAPABILITY_NS_OSGI_FRAGMENT = "osgi.fragment";
    public static final IProvidedCapability BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"bundle", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    public static final IProvidedCapability SOURCE_BUNDLE_CAPABILITY = MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.eclipse.type", (String)"source", (Version)Version.createOSGi((int)1, (int)0, (int)0));
    static final String DEFAULT_BUNDLE_LOCALIZATION = "OSGI-INF/l10n/bundle";
    private static final String[] BUNDLE_IU_PROPERTY_MAP = new String[]{"Bundle-Name", "org.eclipse.equinox.p2.name", "Bundle-Description", "org.eclipse.equinox.p2.description", "Bundle-Vendor", "org.eclipse.equinox.p2.provider", "Bundle-ContactAddress", "org.eclipse.equinox.p2.contact", "Bundle-DocURL", "org.eclipse.equinox.p2.doc.url", "Bundle-UpdateLocation", "org.eclipse.equinox.p2.bundle.localization", "Bundle-Localization", "org.eclipse.equinox.p2.bundle.localization"};
    public static final int BUNDLE_LOCALIZATION_INDEX = PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length - 1;
    public static final String DIR = "dir";
    public static final String JAR = "jar";
    public static final String BUNDLE_SHAPE = "Eclipse-BundleShape";
    public static final String INSTALLATION_DIRECTIVE = "x-installation";
    public static final String INSTALLATION_GREEDY = "greedy";
    private File[] locations;
    private BundleDescription[] bundles;
    protected MultiStatus finalStatus;

    public static IArtifactKey createBundleArtifactKey(String bsn, String version) {
        return new ArtifactKey("osgi.bundle", bsn, Version.parseVersion((String)version));
    }

    public static IInstallableUnit createBundleConfigurationUnit(String hostId, Version cuVersion, boolean isBundleFragment, GeneratorBundleInfo configInfo, String configurationFlavor, IMatchExpression<IInstallableUnit> filter) {
        if (configInfo == null) {
            return null;
        }
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = String.valueOf(configurationFlavor) + hostId;
        cu.setId(configUnitId);
        cu.setVersion(cuVersion);
        Version hostVersion = Version.parseVersion((String)configInfo.getVersion());
        VersionRange range = hostVersion == Version.emptyVersion ? VersionRange.emptyRange : new VersionRange(hostVersion, true, Version.MAX_VERSION, true);
        cu.setHost(new IRequirement[]{MetadataFactory.createRequirement((String)"osgi.bundle", (String)hostId, (VersionRange)range, null, (boolean)false, (boolean)false, (boolean)true), MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)TYPE_ECLIPSE_BUNDLE, (VersionRange)new VersionRange(Version.createOSGi((int)1, (int)0, (int)0), true, Version.createOSGi((int)2, (int)0, (int)0), false), null, (boolean)false, (boolean)false, (boolean)false)});
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability((String)configUnitId, (Version)cuVersion), MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.flavor", (String)configurationFlavor, (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", BundlesAction.createConfigScript(configInfo, isBundleFragment));
        touchpointData.put("unconfigure", BundlesAction.createUnconfigScript(configInfo, isBundleFragment));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        cu.setFilter(filter);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    public static IInstallableUnit createBundleIU(BundleDescription bd, IArtifactKey key, IPublisherInfo info) {
        return new BundlesAction(new BundleDescription[]{bd}).doCreateBundleIU(bd, key, info);
    }

    protected IInstallableUnit doCreateBundleIU(BundleDescription bd, IArtifactKey key, IPublisherInfo info) {
        Map manifest = (Map)bd.getUserObject();
        Map<Locale, Map<String, String>> manifestLocalizations = null;
        if (manifest != null && bd.getLocation() != null) {
            manifestLocalizations = BundlesAction.getManifestLocalizations(manifest, new File(bd.getLocation()));
        }
        MetadataFactory.InstallableUnitDescription iu = new MetadataFactory.InstallableUnitDescription();
        iu.setSingleton(bd.isSingleton());
        iu.setId(bd.getSymbolicName());
        iu.setVersion(PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
        iu.setFilter(bd.getPlatformFilter());
        iu.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor((String)bd.getSymbolicName(), (VersionRange)BundlesAction.computeUpdateRange(bd.getVersion()), (int)0, null));
        iu.setArtifacts(new IArtifactKey[]{key});
        iu.setTouchpointType(PublisherHelper.TOUCHPOINT_OSGI);
        boolean isFragment = bd.getHost() != null;
        ArrayList<IRequirement> requirements = new ArrayList<IRequirement>();
        if (isFragment) {
            requirements.add(MetadataFactory.createRequirement((String)"osgi.bundle", (String)bd.getHost().getName(), (VersionRange)PublisherHelper.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)bd.getHost().getVersionRange()), null, (boolean)false, (boolean)false));
        }
        ManifestElement[] rawRequireBundleHeader = BundlesAction.parseManifestHeader("Require-Bundle", manifest, bd.getLocation());
        BundleSpecification[] bundleSpecificationArray = bd.getRequiredBundles();
        int n = bundleSpecificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            BundleSpecification requiredBundle = bundleSpecificationArray[n2];
            this.addRequireBundleRequirement((List<IRequirement>)requirements, requiredBundle, rawRequireBundleHeader);
            ++n2;
        }
        ManifestElement[] rawImportPackageHeader = BundlesAction.parseManifestHeader("Import-Package", manifest, bd.getLocation());
        ImportPackageSpecification[] importPackageSpecificationArray = bd.getImportPackages();
        int n3 = importPackageSpecificationArray.length;
        n = 0;
        while (n < n3) {
            ImportPackageSpecification importedPackage = importPackageSpecificationArray[n];
            if (!BundlesAction.isDynamicImport(importedPackage)) {
                this.addImportPackageRequirement((List<IRequirement>)requirements, importedPackage, rawImportPackageHeader);
            }
            ++n;
        }
        ManifestElement[] rawRequireCapHeader = BundlesAction.parseManifestHeader("Require-Capability", manifest, bd.getLocation());
        GenericSpecification[] genericSpecificationArray = bd.getGenericRequires();
        int n4 = genericSpecificationArray.length;
        n3 = 0;
        while (n3 < n4) {
            GenericSpecification requiredCap = genericSpecificationArray[n3];
            this.addRequirement(requirements, requiredCap, rawRequireCapHeader);
            ++n3;
        }
        iu.setRequirements(requirements.toArray(new IRequirement[requirements.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)bd.getSymbolicName(), (Version)PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion())));
        providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"osgi.bundle", (String)bd.getSymbolicName(), (Version)PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion())));
        ExportPackageDescription[] exportPackageDescriptionArray = bd.getExportPackages();
        int n5 = exportPackageDescriptionArray.length;
        n4 = 0;
        while (n4 < n5) {
            ExportPackageDescription packageExport = exportPackageDescriptionArray[n4];
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)"java.package", (String)packageExport.getName(), (Version)PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)packageExport.getVersion())));
            ++n4;
        }
        int capNo = 0;
        GenericDescription[] genericDescriptionArray = bd.getGenericCapabilities();
        int n6 = genericDescriptionArray.length;
        n5 = 0;
        while (n5 < n6) {
            GenericDescription genericCap = genericDescriptionArray[n5];
            this.addCapability(providedCapabilities, genericCap, iu, capNo);
            ++capNo;
            ++n5;
        }
        if (manifest != null && manifest.containsKey("Eclipse-SourceBundle")) {
            providedCapabilities.add(SOURCE_BUNDLE_CAPABILITY);
        } else {
            providedCapabilities.add(BUNDLE_CAPABILITY);
        }
        if (isFragment) {
            providedCapabilities.add(MetadataFactory.createProvidedCapability((String)CAPABILITY_NS_OSGI_FRAGMENT, (String)bd.getHost().getName(), (Version)PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion())));
        }
        if (manifestLocalizations != null) {
            for (Map.Entry<Locale, Map<String, String>> locEntry : manifestLocalizations.entrySet()) {
                Locale locale = locEntry.getKey();
                Map<String, String> translatedStrings = locEntry.getValue();
                for (Map.Entry<String, String> entry : translatedStrings.entrySet()) {
                    iu.setProperty(String.valueOf(locale.toString()) + '.' + entry.getKey(), entry.getValue());
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)bd.getSymbolicName(), (Locale)locale));
            }
        }
        iu.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        BundlesAction.processUpdateDescriptorAdvice((MetadataFactory.InstallableUnitDescription)iu, (IPublisherInfo)info);
        BundlesAction.processCapabilityAdvice((MetadataFactory.InstallableUnitDescription)iu, (IPublisherInfo)info);
        if (manifest != null) {
            int i = 0;
            while (i < BUNDLE_IU_PROPERTY_MAP.length) {
                String value;
                if (manifest.containsKey(BUNDLE_IU_PROPERTY_MAP[i]) && (value = (String)manifest.get(BUNDLE_IU_PROPERTY_MAP[i])) != null && value.length() > 0) {
                    iu.setProperty(BUNDLE_IU_PROPERTY_MAP[i + 1], value);
                }
                i += 2;
            }
        }
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("manifest", BundlesAction.toManifestString(manifest));
        if (BundlesAction.isDir(bd, info)) {
            touchpointData.put("zipped", "true");
        }
        BundlesAction.processTouchpointAdvice((MetadataFactory.InstallableUnitDescription)iu, touchpointData, (IPublisherInfo)info);
        BundlesAction.processInstallableUnitPropertiesAdvice((MetadataFactory.InstallableUnitDescription)iu, (IPublisherInfo)info);
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iu);
    }

    @Deprecated
    protected void addImportPackageRequirement(ArrayList<IRequirement> reqsDeps, ImportPackageSpecification importSpec, ManifestElement[] rawImportPackageHeader) {
        this.addImportPackageRequirement((List<IRequirement>)reqsDeps, importSpec, rawImportPackageHeader);
    }

    protected void addImportPackageRequirement(List<IRequirement> reqsDeps, ImportPackageSpecification importSpec, ManifestElement[] rawImportPackageHeader) {
        VersionRange versionRange = PublisherHelper.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)importSpec.getVersionRange());
        boolean optional = BundlesAction.isOptional(importSpec);
        boolean greedy = optional ? INSTALLATION_GREEDY.equals(BundlesAction.getInstallationDirective(importSpec.getName(), rawImportPackageHeader)) : true;
        reqsDeps.add(MetadataFactory.createRequirement((String)"java.package", (String)importSpec.getName(), (VersionRange)versionRange, null, (boolean)optional, (boolean)false, (boolean)greedy));
    }

    @Deprecated
    protected void addRequireBundleRequirement(ArrayList<IRequirement> reqsDeps, BundleSpecification requiredBundle, ManifestElement[] rawRequireBundleHeader) {
        this.addRequireBundleRequirement((List<IRequirement>)reqsDeps, requiredBundle, rawRequireBundleHeader);
    }

    protected void addRequireBundleRequirement(List<IRequirement> reqsDeps, BundleSpecification requiredBundle, ManifestElement[] rawRequireBundleHeader) {
        boolean optional = requiredBundle.isOptional();
        boolean greedy = optional ? INSTALLATION_GREEDY.equals(BundlesAction.getInstallationDirective(requiredBundle.getName(), rawRequireBundleHeader)) : true;
        reqsDeps.add(MetadataFactory.createRequirement((String)"osgi.bundle", (String)requiredBundle.getName(), (VersionRange)PublisherHelper.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)requiredBundle.getVersionRange()), null, (int)(optional ? 0 : 1), (int)1, (boolean)greedy));
    }

    protected void addRequirement(List<IRequirement> reqsDeps, GenericSpecification requireCapSpec, ManifestElement[] rawRequireCapabilities) {
        BundleRequirement req = requireCapSpec.getRequirement();
        String namespace = req.getNamespace();
        Map directives = req.getDirectives();
        String capFilter = (String)directives.get("filter");
        boolean optional = directives.get("resolution") == "optional";
        boolean greedy = optional ? INSTALLATION_GREEDY.equals(directives.get(INSTALLATION_DIRECTIVE)) : true;
        IRequirement requireCap = MetadataFactory.createRequirement((String)namespace, (String)capFilter, null, (int)(optional ? 0 : 1), (int)1, (boolean)greedy);
        reqsDeps.add(requireCap);
    }

    protected void addCapability(List<IProvidedCapability> caps, GenericDescription provideCapDesc, MetadataFactory.InstallableUnitDescription iu, int capNo) {
        Map<String, Object> capAttrs = provideCapDesc.getDeclaredAttributes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.convertAttribute(e.getValue())));
        String capNs = provideCapDesc.getType();
        capAttrs.compute(capNs, (k, v) -> v instanceof String ? v : String.format("%s_%s-%s", iu.getId(), iu.getVersion(), capNo));
        capAttrs.compute("version", (k, v) -> v instanceof Version ? v : Version.emptyVersion);
        caps.add(MetadataFactory.createProvidedCapability((String)capNs, capAttrs));
    }

    private Object convertAttribute(Object attr) {
        if (attr instanceof Collection) {
            return ((Collection)attr).stream().map(this::convertScalarAttribute).collect(Collectors.toList());
        }
        return this.convertScalarAttribute(attr);
    }

    private Object convertScalarAttribute(Object attr) {
        if (attr instanceof org.osgi.framework.Version) {
            org.osgi.framework.Version osgiVer = (org.osgi.framework.Version)attr;
            return Version.createOSGi((int)osgiVer.getMajor(), (int)osgiVer.getMinor(), (int)osgiVer.getMicro(), (String)osgiVer.getQualifier());
        }
        return attr.toString();
    }

    static VersionRange computeUpdateRange(org.osgi.framework.Version base) {
        VersionRange updateRange = null;
        updateRange = !base.equals((Object)org.osgi.framework.Version.emptyVersion) ? new VersionRange(Version.emptyVersion, true, PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)base), false) : VersionRange.emptyRange;
        return updateRange;
    }

    private IInstallableUnitFragment createHostLocalizationFragment(IInstallableUnit bundleIU, BundleDescription bd, String hostId, String[] hostBundleManifestValues) {
        Map<Locale, Map<String, String>> hostLocalizations = BundlesAction.getHostLocalizations(new File(bd.getLocation()), hostBundleManifestValues);
        if (hostLocalizations == null || hostLocalizations.isEmpty()) {
            return null;
        }
        return BundlesAction.createLocalizationFragmentOfHost(bd, hostId, hostBundleManifestValues, hostLocalizations);
    }

    private static IInstallableUnitFragment createLocalizationFragmentOfHost(BundleDescription bd, String hostId, String[] hostManifestValues, Map<Locale, Map<String, String>> hostLocalizations) {
        MetadataFactory.InstallableUnitFragmentDescription fragment = new MetadataFactory.InstallableUnitFragmentDescription();
        String fragmentId = BundlesAction.makeHostLocalizationFragmentId(bd.getSymbolicName());
        fragment.setId(fragmentId);
        fragment.setVersion(PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
        HostSpecification hostSpec = bd.getHost();
        IRequirement[] hostReqs = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)hostSpec.getName(), (VersionRange)PublisherHelper.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)hostSpec.getVersionRange()), null, (boolean)false, (boolean)false, (boolean)false)};
        fragment.setHost(hostReqs);
        fragment.setSingleton(true);
        fragment.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>(hostLocalizations.keySet().size());
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)fragmentId, (Version)fragment.getVersion()));
        for (Map.Entry<Locale, Map<String, String>> localeEntry : hostLocalizations.entrySet()) {
            Locale locale = localeEntry.getKey();
            Map<String, String> translatedStrings = localeEntry.getValue();
            for (Map.Entry<String, String> entry : translatedStrings.entrySet()) {
                fragment.setProperty(String.valueOf(locale.toString()) + '.' + entry.getKey(), entry.getValue());
            }
            providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)hostId, (Locale)locale));
        }
        fragment.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        return MetadataFactory.createInstallableUnitFragment((MetadataFactory.InstallableUnitFragmentDescription)fragment);
    }

    private static String makeHostLocalizationFragmentId(String id) {
        return String.valueOf(id) + ".translated_host_properties";
    }

    private static String createConfigScript(GeneratorBundleInfo configInfo, boolean isBundleFragment) {
        if (configInfo == null) {
            return "";
        }
        String configScript = "";
        if (!isBundleFragment && configInfo.getStartLevel() != -1) {
            configScript = String.valueOf(configScript) + "setStartLevel(startLevel:" + configInfo.getStartLevel() + ");";
        }
        if (!isBundleFragment && configInfo.isMarkedAsStarted()) {
            configScript = String.valueOf(configScript) + "markStarted(started: true);";
        }
        if (configInfo.getSpecialConfigCommands() != null) {
            configScript = String.valueOf(configScript) + configInfo.getSpecialConfigCommands();
        }
        return configScript;
    }

    private static String createDefaultBundleConfigScript(GeneratorBundleInfo configInfo) {
        return BundlesAction.createConfigScript(configInfo, false);
    }

    public static IInstallableUnit createDefaultBundleConfigurationUnit(GeneratorBundleInfo configInfo, GeneratorBundleInfo unconfigInfo, String configurationFlavor) {
        MetadataFactory.InstallableUnitFragmentDescription cu = new MetadataFactory.InstallableUnitFragmentDescription();
        String configUnitId = PublisherHelper.createDefaultConfigUnitId((String)"osgi.bundle", (String)configurationFlavor);
        cu.setId(configUnitId);
        Version configUnitVersion = Version.createOSGi((int)1, (int)0, (int)0);
        cu.setVersion(configUnitVersion);
        cu.setProperty("org.eclipse.equinox.p2.type.fragment", Boolean.TRUE.toString());
        cu.setCapabilities(new IProvidedCapability[]{PublisherHelper.createSelfCapability((String)configUnitId, (Version)configUnitVersion), MetadataFactory.createProvidedCapability((String)"org.eclipse.equinox.p2.flavor", (String)configurationFlavor, (Version)Version.createOSGi((int)1, (int)0, (int)0))});
        IRequirement[] reqs = new IRequirement[]{MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.eclipse.type", (String)TYPE_ECLIPSE_BUNDLE, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true, (boolean)false)};
        cu.setHost(reqs);
        HashMap<String, String> touchpointData = new HashMap<String, String>();
        touchpointData.put("install", "installBundle(bundle:${artifact})");
        touchpointData.put("uninstall", "uninstallBundle(bundle:${artifact})");
        touchpointData.put("configure", BundlesAction.createDefaultBundleConfigScript(configInfo));
        touchpointData.put("unconfigure", BundlesAction.createDefaultBundleUnconfigScript(unconfigInfo));
        cu.addTouchpointData(MetadataFactory.createTouchpointData(touchpointData));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cu);
    }

    private static String createDefaultBundleUnconfigScript(GeneratorBundleInfo unconfigInfo) {
        return BundlesAction.createUnconfigScript(unconfigInfo, false);
    }

    private static String createUnconfigScript(GeneratorBundleInfo unconfigInfo, boolean isBundleFragment) {
        if (unconfigInfo == null) {
            return "";
        }
        String unconfigScript = "";
        if (!isBundleFragment && unconfigInfo.getStartLevel() != -1) {
            unconfigScript = String.valueOf(unconfigScript) + "setStartLevel(startLevel:-1);";
        }
        if (!isBundleFragment && unconfigInfo.isMarkedAsStarted()) {
            unconfigScript = String.valueOf(unconfigScript) + "markStarted(started: false);";
        }
        if (unconfigInfo.getSpecialUnconfigCommands() != null) {
            unconfigScript = String.valueOf(unconfigScript) + unconfigInfo.getSpecialUnconfigCommands();
        }
        return unconfigScript;
    }

    private static boolean isDynamicImport(ImportPackageSpecification importedPackage) {
        return importedPackage.getDirective("resolution").equals("dynamic");
    }

    protected static boolean isOptional(ImportPackageSpecification importedPackage) {
        return importedPackage.getDirective("resolution").equals("optional");
    }

    private static String toManifestString(Map<String, String> p) {
        String[] interestingKeys;
        if (p == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        String[] stringArray = interestingKeys = new String[]{"Bundle-SymbolicName", "Bundle-Version", "Fragment-Host"};
        int n = interestingKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = p.get(key);
            if (value != null) {
                result.append(key).append(": ").append(value).append('\n');
            }
            ++n2;
        }
        return result.length() == 0 ? null : result.toString();
    }

    private static Map<Locale, Map<String, String>> getManifestLocalizations(Map<String, String> manifest, File bundleLocation) {
        Locale defaultLocale = null;
        String[] bundleManifestValues = BundlesAction.getManifestCachedValues(manifest);
        String bundleLocalization = bundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        Map localizations = JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations((File)bundleLocation, (String)bundleLocalization, defaultLocale, (String[])bundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations((File)bundleLocation, (String)bundleLocalization, defaultLocale, (String[])bundleManifestValues);
        return localizations;
    }

    public static String[] getExternalizedStrings(IInstallableUnit iu) {
        String[] result = new String[PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length];
        int j = 0;
        int i = 1;
        while (i < BUNDLE_IU_PROPERTY_MAP.length - 1) {
            if (iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]) != null && iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]).length() > 0 && iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]).charAt(0) == '%') {
                result[j++] = iu.getProperty(BUNDLE_IU_PROPERTY_MAP[i]).substring(1);
            } else {
                ++j;
            }
            i += 2;
        }
        result[BundlesAction.BUNDLE_LOCALIZATION_INDEX] = iu.getProperty("org.eclipse.equinox.p2.bundle.localization");
        return result;
    }

    public static String[] getManifestCachedValues(Map<String, String> manifest) {
        String[] cachedValues = new String[PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length];
        int j = 0;
        while (j < PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES.length) {
            String value = manifest.get(PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES[j]);
            if (PublisherHelper.BUNDLE_LOCALIZED_PROPERTIES[j].equals("Bundle-Localization")) {
                if (value == null) {
                    value = DEFAULT_BUNDLE_LOCALIZATION;
                }
                cachedValues[j] = value;
            } else if (value != null && value.length() > 1 && value.charAt(0) == '%') {
                cachedValues[j] = value.substring(1);
            }
            ++j;
        }
        return cachedValues;
    }

    public static Map<Locale, Map<String, String>> getHostLocalizations(File bundleLocation, String[] hostBundleManifestValues) {
        Locale defaultLocale = null;
        String hostBundleLocalization = hostBundleManifestValues[BUNDLE_LOCALIZATION_INDEX];
        if (hostBundleLocalization == null) {
            return null;
        }
        Map localizations = JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile() ? LocalizationHelper.getJarPropertyLocalizations((File)bundleLocation, (String)hostBundleLocalization, defaultLocale, (String[])hostBundleManifestValues) : LocalizationHelper.getDirPropertyLocalizations((File)bundleLocation, (String)hostBundleLocalization, defaultLocale, (String[])hostBundleManifestValues);
        return localizations;
    }

    public static BundleDescription createBundleDescription(Dictionary<String, String> enhancedManifest, File bundleLocation) {
        try {
            BundleDescription descriptor = StateObjectFactory.defaultFactory.createBundleDescription(null, enhancedManifest, bundleLocation == null ? null : bundleLocation.getAbsolutePath(), 1L);
            descriptor.setUserObject(enhancedManifest);
            return descriptor;
        }
        catch (BundleException e) {
            String message = NLS.bind((String)Messages.exception_stateAddition, (Object)(bundleLocation == null ? null : bundleLocation.getAbsoluteFile()));
            Status status = new Status(2, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
            return null;
        }
    }

    @Deprecated
    public static BundleDescription createBundleDescriptionIgnoringExceptions(File bundleLocation) {
        try {
            return BundlesAction.createBundleDescription(bundleLocation);
        }
        catch (IOException e) {
            BundlesAction.logWarning(bundleLocation, e);
            return null;
        }
        catch (BundleException e) {
            BundlesAction.logWarning(bundleLocation, e);
            return null;
        }
    }

    private static void logWarning(File bundleLocation, Throwable t) {
        String message = NLS.bind((String)Messages.exception_errorLoadingManifest, (Object)bundleLocation);
        LogHelper.log((IStatus)new Status(2, Activator.ID, message, t));
    }

    public static BundleDescription createBundleDescription(File bundleLocation) throws IOException, BundleException {
        Dictionary<String, String> manifest = BundlesAction.loadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        return BundlesAction.createBundleDescription(manifest, bundleLocation);
    }

    @Deprecated
    public static Dictionary<String, String> loadManifestIgnoringExceptions(File bundleLocation) {
        try {
            return BundlesAction.loadManifest(bundleLocation);
        }
        catch (IOException e) {
            BundlesAction.logWarning(bundleLocation, e);
            return null;
        }
        catch (BundleException e) {
            BundlesAction.logWarning(bundleLocation, e);
            return null;
        }
    }

    public static Dictionary<String, String> loadManifest(File bundleLocation) throws IOException, BundleException {
        Dictionary<String, String> manifest = BundlesAction.basicLoadManifest(bundleLocation);
        if (manifest == null) {
            return null;
        }
        if (manifest.get(BUNDLE_SHAPE) == null) {
            manifest.put(BUNDLE_SHAPE, bundleLocation.isDirectory() ? DIR : JAR);
        }
        return manifest;
    }

    @Deprecated
    public static Dictionary<String, String> basicLoadManifestIgnoringExceptions(File bundleLocation) {
        try {
            return BundlesAction.basicLoadManifest(bundleLocation);
        }
        catch (IOException e) {
            BundlesAction.logWarning(bundleLocation, e);
            return null;
        }
        catch (BundleException e) {
            BundlesAction.logWarning(bundleLocation, e);
            return null;
        }
    }

    public static Dictionary<String, String> basicLoadManifest(File bundleLocation) throws IOException, BundleException {
        InputStream manifestStream = null;
        ZipFile jarFile = null;
        if (JAR.equalsIgnoreCase(new Path(bundleLocation.getName()).getFileExtension()) && bundleLocation.isFile()) {
            jarFile = new ZipFile(bundleLocation, 1);
            ZipEntry manifestEntry = jarFile.getEntry("META-INF/MANIFEST.MF");
            if (manifestEntry != null) {
                manifestStream = jarFile.getInputStream(manifestEntry);
            }
        } else {
            File manifestFile = new File(bundleLocation, "META-INF/MANIFEST.MF");
            if (manifestFile.exists()) {
                manifestStream = new BufferedInputStream(new FileInputStream(manifestFile));
            }
        }
        Headers<String, String> manifest = null;
        try {
            if (manifestStream != null) {
                manifest = BundlesAction.parseBundleManifestIntoModifyableDictionaryWithCaseInsensitiveKeys(manifestStream);
            }
        }
        catch (Throwable throwable) {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (jarFile != null) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {}
        return manifest;
    }

    private static Headers<String, String> parseBundleManifestIntoModifyableDictionaryWithCaseInsensitiveKeys(InputStream manifestStream) throws IOException, BundleException {
        return (Headers)ManifestElement.parseBundleManifest((InputStream)manifestStream, (Map)new Headers(10));
    }

    private static ManifestElement[] parseManifestHeader(String header, Map<String, String> manifest, String bundleLocation) {
        try {
            return ManifestElement.parseHeader((String)header, (String)manifest.get(header));
        }
        catch (BundleException e) {
            String message = NLS.bind((String)Messages.exception_errorReadingManifest, (Object)bundleLocation, (Object)e.getMessage());
            LogHelper.log((IStatus)new Status(4, Activator.ID, message, (Throwable)e));
            return null;
        }
    }

    private static String getInstallationDirective(String requirementId, ManifestElement[] correspondingBundleHeader) {
        ManifestElement[] manifestElementArray = correspondingBundleHeader;
        int n = correspondingBundleHeader.length;
        int n2 = 0;
        while (n2 < n) {
            String[] packages;
            ManifestElement manifestElement = manifestElementArray[n2];
            String[] stringArray = packages = manifestElement.getValueComponents();
            int n3 = packages.length;
            int n4 = 0;
            while (n4 < n3) {
                String pckg = stringArray[n4];
                if (requirementId.equals(pckg)) {
                    return manifestElement.getDirective(INSTALLATION_DIRECTIVE);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public BundlesAction(File[] locations) {
        this.locations = locations;
    }

    public BundlesAction(BundleDescription[] bundles) {
        this.bundles = bundles;
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (this.bundles == null && this.locations == null) {
            throw new IllegalStateException(Messages.exception_noBundlesOrLocations);
        }
        this.setPublisherInfo(publisherInfo);
        this.finalStatus = new MultiStatus(Activator.ID, 0, Messages.message_bundlesPublisherMultistatus, null);
        try {
            if (this.bundles == null) {
                this.bundles = this.getBundleDescriptions(this.expandLocations(this.locations), monitor);
            }
            this.generateBundleIUs(this.bundles, publisherInfo, results, monitor);
            this.bundles = null;
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        if (!this.finalStatus.isOK()) {
            return this.finalStatus;
        }
        return Status.OK_STATUS;
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File base, File[] inclusions, IPublisherInfo publisherInfo) {
        IArtifactRepository destination = publisherInfo.getArtifactRepository();
        if (descriptor == null || destination == null) {
            return;
        }
        this.publishArtifact(descriptor, inclusions, null, publisherInfo, this.createRootPrefixComputer(base));
    }

    protected void publishArtifact(IArtifactDescriptor descriptor, File jarFile, IPublisherInfo publisherInfo) {
        File packFile;
        if (jarFile == null || publisherInfo == null) {
            return;
        }
        IArtifactRepository destination = publisherInfo.getArtifactRepository();
        if (destination == null || destination.contains(descriptor)) {
            return;
        }
        super.publishArtifact(descriptor, jarFile, publisherInfo);
        boolean reuse = "true".equals(destination.getProperties().get("publishPackFilesAsSiblings"));
        if (reuse && (publisherInfo.getArtifactOptions() & 2) > 0 && (packFile = new Path(jarFile.getAbsolutePath()).addFileExtension("pack.gz").toFile()).exists()) {
            IArtifactDescriptor ad200 = this.createPack200ArtifactDescriptor(descriptor.getArtifactKey(), packFile, descriptor.getProperty("artifact.size"));
            this.publishArtifact(ad200, packFile, publisherInfo);
        }
    }

    private File[] expandLocations(File[] list) {
        ArrayList<File> result = new ArrayList<File>();
        this.expandLocations(list, result);
        return result.toArray(new File[result.size()]);
    }

    private void expandLocations(File[] list, ArrayList<File> result) {
        if (list == null) {
            return;
        }
        File[] fileArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            File location = fileArray[n2];
            if (location.isDirectory()) {
                if (new File(location, "META-INF/MANIFEST.MF").exists()) {
                    result.add(location);
                } else if (new File(location, "plugin.xml").exists() || new File(location, "fragment.xml").exists()) {
                    result.add(location);
                } else {
                    this.expandLocations(location.listFiles(), result);
                }
            } else {
                result.add(location);
            }
            ++n2;
        }
    }

    @Deprecated
    protected void generateBundleIUs(BundleDescription[] bundleDescriptions, IPublisherResult result, IProgressMonitor monitor) {
        this.generateBundleIUs(bundleDescriptions, null, result, monitor);
    }

    protected void generateBundleIUs(BundleDescription[] bundleDescriptions, IPublisherInfo info, IPublisherResult result, IProgressMonitor monitor) {
        BundleDescription[] bundleDescriptionArray = bundleDescriptions;
        int n = bundleDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription bd = bundleDescriptionArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (bd != null && bd.getSymbolicName() != null && bd.getVersion() != null) {
                IInstallableUnit bundleIU = this.queryForIU(result, bd.getSymbolicName(), PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
                IArtifactKey bundleArtKey = BundlesAction.createBundleArtifactKey(bd.getSymbolicName(), bd.getVersion().toString());
                if (bundleIU == null) {
                    this.createAdviceFileAdvice(bd, info);
                    bundleIU = this.doCreateBundleIU(bd, bundleArtKey, info);
                }
                File bundleLocation = new File(bd.getLocation());
                IArtifactDescriptor ad = PublisherHelper.createArtifactDescriptor((IPublisherInfo)info, (IArtifactKey)bundleArtKey, (File)bundleLocation);
                BundlesAction.processArtifactPropertiesAdvice((IInstallableUnit)bundleIU, (IArtifactDescriptor)ad, (IPublisherInfo)info);
                if (bundleLocation.isDirectory()) {
                    this.publishArtifact(ad, bundleLocation, bundleLocation.listFiles(), info);
                } else {
                    this.publishArtifact(ad, bundleLocation, info);
                }
                IInstallableUnit fragment = null;
                if (this.isFragment(bd)) {
                    String hostId = bd.getHost().getName();
                    VersionRange hostVersionRange = PublisherHelper.fromOSGiVersionRange((org.eclipse.osgi.service.resolver.VersionRange)bd.getHost().getVersionRange());
                    IQueryResult hosts = this.queryForIUs(result, hostId, hostVersionRange);
                    for (IInstallableUnit host : hosts) {
                        String fragmentId = BundlesAction.makeHostLocalizationFragmentId(bd.getSymbolicName());
                        fragment = this.queryForIU(result, fragmentId, PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bd.getVersion()));
                        if (fragment != null) continue;
                        String[] externalizedStrings = BundlesAction.getExternalizedStrings(host);
                        fragment = this.createHostLocalizationFragment(bundleIU, bd, hostId, externalizedStrings);
                    }
                }
                result.addIU(bundleIU, "root");
                if (fragment != null) {
                    result.addIU(fragment, "non_root");
                }
                MetadataFactory.InstallableUnitDescription[] others = BundlesAction.processAdditionalInstallableUnitsAdvice((IInstallableUnit)bundleIU, (IPublisherInfo)info);
                int iuIndex = 0;
                while (others != null && iuIndex < others.length) {
                    result.addIU(MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)others[iuIndex]), "root");
                    ++iuIndex;
                }
            }
            ++n2;
        }
    }

    protected void createAdviceFileAdvice(BundleDescription bundleDescription, IPublisherInfo publisherInfo) {
        String location = bundleDescription.getLocation();
        if (location == null) {
            return;
        }
        AdviceFileAdvice advice = new AdviceFileAdvice(bundleDescription.getSymbolicName(), PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bundleDescription.getVersion()), (IPath)new Path(location), AdviceFileAdvice.BUNDLE_ADVICE_FILE);
        if (advice.containsAdvice()) {
            publisherInfo.addAdvice((IPublisherAdvice)advice);
        }
    }

    private static boolean isDir(BundleDescription bundle, IPublisherInfo info) {
        String shape;
        Collection advice = info.getAdvice(null, true, bundle.getSymbolicName(), PublisherHelper.fromOSGiVersion((org.osgi.framework.Version)bundle.getVersion()), IBundleShapeAdvice.class);
        if (advice != null && !advice.isEmpty() && (shape = ((IBundleShapeAdvice)advice.iterator().next()).getShape()) != null) {
            return shape.equals(DIR);
        }
        Map manifest = (Map)bundle.getUserObject();
        String format = (String)manifest.get(BUNDLE_SHAPE);
        return DIR.equals(format);
    }

    private boolean isFragment(BundleDescription bd) {
        return bd.getHost() != null;
    }

    protected BundleDescription[] getBundleDescriptions(File[] bundleLocations, IProgressMonitor monitor) {
        if (bundleLocations == null) {
            return new BundleDescription[0];
        }
        ArrayList<BundleDescription> result = new ArrayList<BundleDescription>(bundleLocations.length);
        File[] fileArray = bundleLocations;
        int n = bundleLocations.length;
        int n2 = 0;
        while (n2 < n) {
            File bundleLocation = fileArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            BundleDescription description = null;
            try {
                description = BundlesAction.createBundleDescription(bundleLocation);
            }
            catch (IOException e) {
                this.addPublishingErrorToFinalStatus(e, bundleLocation);
            }
            catch (BundleException e) {
                this.addPublishingErrorToFinalStatus(e, bundleLocation);
            }
            if (description != null) {
                result.add(description);
            }
            ++n2;
        }
        return result.toArray(new BundleDescription[0]);
    }

    private void addPublishingErrorToFinalStatus(Throwable t, File bundleLocation) {
        this.finalStatus.add((IStatus)new Status(4, Activator.ID, NLS.bind((String)Messages.exception_errorPublishingBundle, (Object)bundleLocation, (Object)t.getMessage()), t));
    }
}

