/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.graphiti.datatypes.ILocation;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.pref.GFPreferences;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.CompositeConnection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.ContextMenuEntry;
import org.eclipse.graphiti.tb.IContextMenuEntry;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.Messages;
import org.eclipse.graphiti.ui.internal.action.CustomAction;
import org.eclipse.graphiti.ui.internal.action.DeleteAction;
import org.eclipse.graphiti.ui.internal.action.IAvailable;
import org.eclipse.graphiti.ui.internal.action.UpdateAction;
import org.eclipse.graphiti.ui.internal.feature.DebugFeature;
import org.eclipse.graphiti.ui.internal.parts.CompositeConnectionEditPart;
import org.eclipse.graphiti.ui.internal.parts.ConnectionEditPart;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.graphiti.util.ILocationInfo;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.actions.ActionFactory;

public class DiagramEditorContextMenuProvider
extends ContextMenuProvider {
    private final ActionRegistry actionRegistry;
    private final IConfigurationProvider configurationProvider;

    public DiagramEditorContextMenuProvider(EditPartViewer viewer, ActionRegistry registry, IConfigurationProvider configurationProvider) {
        super(viewer);
        if (registry == null) {
            throw new IllegalArgumentException("Argument registry must not be null");
        }
        this.actionRegistry = registry;
        if (configurationProvider == null) {
            throw new IllegalArgumentException("Argument configurationProvider must not be null");
        }
        this.configurationProvider = configurationProvider;
    }

    public void buildContextMenu(IMenuManager manager) {
        GEFActionConstants.addStandardActionGroups((IMenuManager)manager);
        this.addDefaultMenuGroupUndo(manager);
        this.addDefaultMenuGroupSave(manager);
        this.addDefaultMenuGroupEdit(manager);
        this.addDefaultMenuGroupPrint(manager);
        this.addDefaultMenuGroupRest(manager);
    }

    protected void addDefaultMenuGroupUndo(IMenuManager manager) {
        this.addActionToMenu(manager, ActionFactory.UNDO.getId(), "org.eclipse.gef.group.undo");
        this.addActionToMenu(manager, ActionFactory.REDO.getId(), "org.eclipse.gef.group.undo");
    }

    protected void addDefaultMenuGroupSave(IMenuManager manager) {
        this.addActionToMenu(manager, "export_diagram_action", "org.eclipse.gef.group.save");
    }

    protected void addDefaultMenuGroupEdit(IMenuManager manager) {
        this.addActionToMenuIfAvailable(manager, ActionFactory.COPY.getId(), "org.eclipse.gef.group.edit");
        this.addActionToMenuIfAvailable(manager, ActionFactory.PASTE.getId(), "org.eclipse.gef.group.edit");
    }

    protected void addDefaultMenuGroupPrint(IMenuManager manager) {
        IPrintFeature pf;
        IFeatureProvider fp = this.configurationProvider.getDiagramTypeProvider().getFeatureProvider();
        if (fp != null && (pf = fp.getPrintFeature()) != null) {
            this.addActionToMenu(manager, ActionFactory.PRINT.getId(), "org.eclipse.gef.group.print");
        }
    }

    protected void addDefaultMenuGroupRest(IMenuManager manager) {
        this.addAlignmentSubMenu(manager, "org.eclipse.gef.group.rest");
        this.addActionToMenuIfAvailable(manager, "predefined update action", "org.eclipse.gef.group.rest");
        this.addActionToMenuIfAvailable(manager, "predefined remove action", "org.eclipse.gef.group.rest");
        this.addActionToMenuIfAvailable(manager, DeleteAction.ACTION_ID, "org.eclipse.gef.group.rest");
        PictogramElement[] pes = this.getEditor().getSelectedPictogramElements();
        CustomContext context = new CustomContext(pes);
        boolean diagramSelected = false;
        if (pes.length == 1) {
            this.extendCustomContext(pes[0], context);
            if (pes[0] instanceof Diagram) {
                diagramSelected = true;
            }
        }
        IToolBehaviorProvider tb = this.configurationProvider.getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        IContextMenuEntry[] contextMenuEntries = tb.getContextMenu((ICustomContext)context);
        if (GFPreferences.getInstance().areDebugActionsActive()) {
            IFeatureProvider fp = this.configurationProvider.getDiagramTypeProvider().getFeatureProvider();
            ContextMenuEntry debugEntry = new ContextMenuEntry(null, (IContext)context);
            debugEntry.setText("Debug");
            debugEntry.setSubmenu(true);
            debugEntry.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new DebugFeature(fp, 1), (IContext)context));
            if (diagramSelected) {
                debugEntry.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new DebugFeature(fp, 5), (IContext)context));
            }
            debugEntry.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new DebugFeature(fp, 0), (IContext)context));
            debugEntry.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new DebugFeature(fp, 2), (IContext)context));
            debugEntry.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new DebugFeature(fp, 3), (IContext)context));
            debugEntry.add((IContextMenuEntry)new ContextMenuEntry((IFeature)new DebugFeature(fp, 4), (IContext)context));
            IContextMenuEntry[] contextMenuEntries2 = new IContextMenuEntry[contextMenuEntries.length + 1];
            System.arraycopy(contextMenuEntries, 0, contextMenuEntries2, 0, contextMenuEntries.length);
            contextMenuEntries2[contextMenuEntries2.length - 1] = debugEntry;
            contextMenuEntries = contextMenuEntries2;
        }
        this.addEntries(manager, contextMenuEntries, (ICustomContext)context, "org.eclipse.gef.group.rest", null);
    }

    private void addEntries(IMenuManager manager, IContextMenuEntry[] contextMenuEntries, ICustomContext context, String groupID, String textParentEntry) {
        int i = 0;
        while (i < contextMenuEntries.length) {
            IContextMenuEntry cmEntry = contextMenuEntries[i];
            String text = cmEntry.getText();
            if (cmEntry.getChildren().length == 0) {
                IFeature feature = cmEntry.getFeature();
                if (feature instanceof ICustomFeature && feature.isAvailable((IContext)context)) {
                    CustomAction action = new CustomAction((ICustomFeature)feature, context, this.configurationProvider.getDiagramBehavior());
                    if (textParentEntry != null) {
                        text = String.valueOf(textParentEntry) + " " + text;
                    }
                    action.setText(text);
                    action.setDescription(cmEntry.getDescription());
                    ImageDescriptor image = GraphitiUi.getImageService().getImageDescriptorForId(this.configurationProvider.getDiagramTypeProvider().getProviderId(), cmEntry.getIconId());
                    action.setImageDescriptor(image);
                    this.appendContributionItem(manager, groupID, (IContributionItem)new ActionContributionItem((IAction)action));
                }
            } else if (cmEntry.isSubmenu()) {
                MenuManager subMenu = new MenuManager(text);
                this.addEntries((IMenuManager)subMenu, cmEntry.getChildren(), context, null, null);
                if (!subMenu.isEmpty()) {
                    this.appendContributionItem(manager, groupID, (IContributionItem)subMenu);
                }
            } else {
                this.appendContributionItem(manager, groupID, (IContributionItem)new Separator());
                this.addEntries(manager, cmEntry.getChildren(), context, groupID, text);
                this.appendContributionItem(manager, groupID, (IContributionItem)new Separator());
            }
            ++i;
        }
    }

    private void appendContributionItem(IMenuManager manager, String groupID, IContributionItem contributionItem) {
        if (groupID != null) {
            manager.appendToGroup(groupID, contributionItem);
        } else {
            manager.add(contributionItem);
        }
    }

    private void extendCustomContext(PictogramElement pe, CustomContext context) {
        block3: {
            block2: {
                Point location = this.getEditor().getMouseLocation();
                int mX = location.x;
                int mY = location.y;
                context.setX(mX);
                context.setY(mY);
                if (!(pe instanceof Shape) || pe instanceof Diagram) break block2;
                GraphicsAlgorithm ga = pe.getGraphicsAlgorithm();
                if (ga == null) break block3;
                ILocation relLocation = Graphiti.getPeService().getLocationRelativeToDiagram((Shape)pe);
                int x = relLocation.getX();
                int y = relLocation.getY();
                int width = ga.getWidth();
                int height = ga.getHeight();
                if (mX <= x || mX >= x + width || mY <= y || mY >= y + height) break block3;
                int relativeX = mX - x;
                int relativeY = mY - y;
                ILocationInfo locationInfo = Graphiti.getLayoutService().getLocationInfo((Shape)pe, relativeX, relativeY);
                context.setInnerPictogramElement((PictogramElement)locationInfo.getShape());
                context.setInnerGraphicsAlgorithm(locationInfo.getGraphicsAlgorithm());
                break block3;
            }
            if (pe instanceof CompositeConnection) {
                List selectedEditParts = this.getViewer().getSelectedEditParts();
                for (Object object : selectedEditParts) {
                    CompositeConnectionEditPart compEditPart;
                    ConnectionEditPart originallySelectedChildConnection;
                    if (!(object instanceof CompositeConnectionEditPart) || (originallySelectedChildConnection = (compEditPart = (CompositeConnectionEditPart)object).getOriginallySelectedChild()) == null) continue;
                    Connection connectionPicto = (Connection)originallySelectedChildConnection.getModel();
                    context.setInnerGraphicsAlgorithm(connectionPicto.getGraphicsAlgorithm());
                    context.setInnerPictogramElement((PictogramElement)connectionPicto);
                }
            }
        }
    }

    protected void addAlignmentSubMenu(IMenuManager manager, String group) {
        MenuManager alignmentSubMenu = new MenuManager(Messages.GraphicsContextMenuProvider_0_xmen);
        IAction action = this.actionRegistry.getAction((Object)"org.eclipse.gef.align_left");
        if (action != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.gef.align_center")) != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.gef.align_right")) != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.gef.align_top")) != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.gef.align_middle")) != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.gef.align_bottom")) != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.gef.match.width")) != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if ((action = this.actionRegistry.getAction((Object)"org.eclipse.gef.match.height")) != null && action.isEnabled()) {
            alignmentSubMenu.add(action);
        }
        if (!alignmentSubMenu.isEmpty()) {
            manager.appendToGroup(group, (IContributionItem)alignmentSubMenu);
        }
    }

    protected void addActionToMenu(IMenuManager manager, String actionId, String menuGroup) {
        IAction action = this.actionRegistry.getAction((Object)actionId);
        if (action != null && action.isEnabled()) {
            manager.appendToGroup(menuGroup, action);
        }
    }

    protected void addActionToMenuIfAvailable(IMenuManager manager, String actionId, String menuGroup) {
        IAction action = this.actionRegistry.getAction((Object)actionId);
        if (action instanceof IAvailable && ((IAvailable)action).isAvailable()) {
            manager.appendToGroup(menuGroup, action);
            if (action instanceof UpdateAction) {
                UpdateAction updateAction = (UpdateAction)action;
                updateAction.setEnabled(updateAction.isEnabled());
            }
        }
    }

    protected boolean allowItem(IContributionItem itemToAdd) {
        String itemId;
        boolean ret = super.allowItem(itemToAdd);
        if (ret && (itemId = itemToAdd.getId()) != null && itemId.startsWith("org.eclipse.debug.ui.contextualLaunch.")) {
            return false;
        }
        return ret;
    }

    private DiagramBehavior getEditor() {
        return this.configurationProvider.getDiagramBehavior();
    }
}

