/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.JavaStackFrameActionFilter;
import org.eclipse.jdt.internal.debug.ui.JavaThreadActionFilter;
import org.eclipse.jdt.internal.debug.ui.JavaVarActionFilter;
import org.eclipse.jdt.internal.debug.ui.MemberActionFilter;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.ui.IActionFilter;

class ActionFilterAdapterFactory
implements IAdapterFactory {
    ActionFilterAdapterFactory() {
    }

    public <T> T getAdapter(Object obj, Class<T> adapterType) {
        if (adapterType.isInstance(obj)) {
            return (T)obj;
        }
        if (adapterType == IActionFilter.class) {
            if (obj instanceof IJavaThread) {
                return (T)new JavaThreadActionFilter();
            }
            if (obj instanceof IJavaStackFrame) {
                return (T)new JavaStackFrameActionFilter();
            }
            if (obj instanceof IMember) {
                return (T)new MemberActionFilter();
            }
            if (obj instanceof IJavaVariable || obj instanceof JavaInspectExpression) {
                return (T)new JavaVarActionFilter();
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IActionFilter.class};
    }
}

