/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.xml.ui.tabletree;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.reddeer.common.util.XPathEvaluator;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.workbench.api.EditorFile;
import org.xml.sax.SAXException;

public class XMLEditorFile
implements EditorFile {
    private EditorFile editorFile;

    public XMLEditorFile(EditorFile editorFile) {
        this.editorFile = editorFile;
    }

    public InputStream getInputStream() {
        return this.editorFile.getInputStream();
    }

    public String getRelativePath() {
        return this.editorFile.getRelativePath();
    }

    public String getAbsolutePath() {
        return this.editorFile.getAbsolutePath();
    }

    public String xpath(String xPathExpression) {
        return this.xpath(xPathExpression, true);
    }

    public String xpath(String xPathExpression, boolean namespaceAware) {
        try {
            XPathEvaluator xPathEvaluator = new XPathEvaluator(this.getInputStream(), namespaceAware);
            return xPathEvaluator.evaluateXPath(xPathExpression);
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new EclipseLayerException("Cannot evaluate xPath " + xPathExpression, e);
        }
    }
}

