/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.features;

import org.eclipse.draw2d.PrintFigureOperation;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IPrintFeature;
import org.eclipse.graphiti.features.context.IPrintContext;
import org.eclipse.graphiti.features.impl.AbstractPrintFeature;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.internal.util.ui.print.PrintFigureDialog;
import org.eclipse.graphiti.ui.internal.util.ui.print.PrintFigureScaleableOperation;
import org.eclipse.graphiti.ui.print.IPrintConfiguration;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Shell;

public class DefaultPrintFeature
extends AbstractPrintFeature
implements IPrintFeature {
    public DefaultPrintFeature(IFeatureProvider fp) {
        super(fp);
    }

    public void print(IPrintContext context) {
        PrinterData printerData;
        Printer printer;
        GraphicalViewer viewer = this.getGraphicalViewer(context);
        IPrintConfiguration printConfiguration = this.getPrintConfiguration(viewer, printer = new Printer(printerData = this.getPrinterData(context)));
        if (printConfiguration.configure() == 0) {
            PrintFigureOperation op = this.getPrintOperation(printConfiguration);
            op.run(this.getName());
            printConfiguration.cleanUp();
        }
    }

    protected GraphicalViewer getGraphicalViewer(IPrintContext context) {
        DiagramEditor diagramEditor = (DiagramEditor)this.getDiagramBehavior().getDiagramContainer();
        return (GraphicalViewer)diagramEditor.getAdapter(GraphicalViewer.class);
    }

    protected PrinterData getPrinterData(IPrintContext context) {
        PrinterData[] printerDatas;
        PrinterData printerData = Printer.getDefaultPrinterData();
        if ((printerData == null || printerData.name == null && printerData.driver == null) && (printerDatas = Printer.getPrinterList()) != null && printerDatas.length > 0) {
            printerData = printerDatas[0];
        }
        return printerData;
    }

    protected IPrintConfiguration getPrintConfiguration(GraphicalViewer viewer, Printer printer) {
        Shell shell = GraphitiUiInternal.getWorkbenchService().getShell();
        PrintFigureDialog printImageDialog = new PrintFigureDialog(shell, viewer, printer);
        return printImageDialog;
    }

    protected PrintFigureOperation getPrintOperation(IPrintConfiguration printConfiguration) {
        PrintFigureScaleableOperation op = new PrintFigureScaleableOperation(printConfiguration);
        return op;
    }
}

