/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.templates;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TextTemplateMessages;

public class GlobalTemplateVariables {
    public static final String SELECTION = "selection";

    public static class Cursor
    extends SimpleTemplateVariableResolver {
        public static final String NAME = "cursor";

        public Cursor() {
            super(NAME, TextTemplateMessages.getString("GlobalVariables.variable.description.cursor"));
            this.setEvaluationString("");
        }
    }

    public static class Date
    extends SimpleTemplateVariableResolver {
        public Date() {
            super("date", TextTemplateMessages.getString("GlobalVariables.variable.description.date"));
        }

        @Override
        public void resolve(TemplateVariable variable, TemplateContext context) {
            List<String> params = variable.getVariableType().getParams();
            if (!params.isEmpty() && params.get(0) != null) {
                this.resolveWithParams(variable, context, params);
            } else {
                super.resolve(variable, context);
            }
        }

        private void resolveWithParams(TemplateVariable variable, TemplateContext context, List<String> params) {
            try {
                SimpleDateFormat format = params.size() >= 2 && params.get(1) != null ? new SimpleDateFormat(params.get(0), new ULocale(params.get(1))) : new SimpleDateFormat(params.get(0));
                variable.setValue(format.format(new java.util.Date()));
                variable.setUnambiguous(true);
                variable.setResolved(true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                super.resolve(variable, context);
            }
        }

        @Override
        protected String resolve(TemplateContext context) {
            return DateFormat.getDateInstance().format(new java.util.Date());
        }
    }

    public static class Dollar
    extends SimpleTemplateVariableResolver {
        public Dollar() {
            super("dollar", TextTemplateMessages.getString("GlobalVariables.variable.description.dollar"));
            this.setEvaluationString("$");
        }
    }

    public static class LineSelection
    extends Selection {
        public static final String NAME = "line_selection";

        public LineSelection() {
            super(NAME, TextTemplateMessages.getString("GlobalVariables.variable.description.selectedLines"));
        }
    }

    public static class Selection
    extends SimpleTemplateVariableResolver {
        public Selection(String name, String description) {
            super(name, description);
        }

        @Override
        protected String resolve(TemplateContext context) {
            String selection = context.getVariable(GlobalTemplateVariables.SELECTION);
            if (selection == null) {
                return "";
            }
            return selection;
        }

        @Override
        public void resolve(TemplateVariable variable, TemplateContext context) {
            List<String> params = variable.getVariableType().getParams();
            if (!params.isEmpty() && params.get(0) != null) {
                this.resolveWithParams(variable, context, params);
            } else {
                super.resolve(variable, context);
            }
        }

        private void resolveWithParams(TemplateVariable variable, TemplateContext context, List<String> params) {
            String selection = context.getVariable(GlobalTemplateVariables.SELECTION);
            if (selection != null && !selection.isEmpty()) {
                variable.setValue(selection);
            } else {
                String defaultValue = params.get(0);
                variable.setValue(defaultValue);
            }
            variable.setUnambiguous(true);
            variable.setResolved(true);
        }
    }

    public static class Time
    extends SimpleTemplateVariableResolver {
        public Time() {
            super("time", TextTemplateMessages.getString("GlobalVariables.variable.description.time"));
        }

        @Override
        protected String resolve(TemplateContext context) {
            return DateFormat.getTimeInstance().format(new java.util.Date());
        }
    }

    public static class User
    extends SimpleTemplateVariableResolver {
        public User() {
            super("user", TextTemplateMessages.getString("GlobalVariables.variable.description.user"));
        }

        @Override
        protected String resolve(TemplateContext context) {
            return System.getProperty("user.name");
        }
    }

    public static class WordSelection
    extends Selection {
        public static final String NAME = "word_selection";

        public WordSelection() {
            super(NAME, TextTemplateMessages.getString("GlobalVariables.variable.description.selectedWord"));
        }
    }

    public static class Year
    extends SimpleTemplateVariableResolver {
        public Year() {
            super("year", TextTemplateMessages.getString("GlobalVariables.variable.description.year"));
        }

        @Override
        protected String resolve(TemplateContext context) {
            return Integer.toString(Calendar.getInstance().get(1));
        }
    }
}

