/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.Policy;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.KeyBindingService;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PopupMenuExtender;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.contexts.NestableContextService;
import org.eclipse.ui.internal.expressions.ActivePartExpression;
import org.eclipse.ui.internal.handlers.LegacyHandlerService;
import org.eclipse.ui.internal.part.IMultiPageEditorSiteHolder;
import org.eclipse.ui.internal.services.INestable;
import org.eclipse.ui.internal.services.IServiceLocatorCreator;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.internal.services.ServiceLocator;
import org.eclipse.ui.internal.services.WorkbenchLocationService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageSelectionProvider;

public class MultiPageEditorSite
implements IEditorSite,
INestable {
    private final IEditorPart editor;
    private ArrayList menuExtenders;
    private final MultiPageEditorPart multiPageEditor;
    private ISelectionChangedListener postSelectionChangedListener;
    private ISelectionChangedListener selectionChangedListener;
    private ISelectionProvider selectionProvider;
    private IKeyBindingService service;
    private final ServiceLocator serviceLocator;
    private NestableContextService contextService;
    private final IEclipseContext context;
    private boolean active;

    public MultiPageEditorSite(MultiPageEditorPart multiPageEditor, IEditorPart editor) {
        Assert.isNotNull((Object)multiPageEditor);
        Assert.isNotNull((Object)editor);
        this.multiPageEditor = multiPageEditor;
        this.editor = editor;
        PartSite site = (PartSite)this.getNestedEditorSite();
        IServiceLocatorCreator slc = site.getService(IServiceLocatorCreator.class);
        String name = "MultiPageEditorSite (" + editor.getClass().getName() + ")";
        this.context = site.getModel().getContext().createChild(name);
        this.serviceLocator = (ServiceLocator)slc.createServiceLocator(this.getNestedEditorSite(), null, () -> this.getMultiPageEditor().close(), this.context);
        this.initializeDefaultServices();
    }

    private void initializeDefaultServices() {
        this.serviceLocator.registerService(IWorkbenchLocationService.class, new WorkbenchLocationService("org.eclipse.ui.part.MultiPageEditorSite", this.getWorkbenchWindow().getWorkbench(), this.getWorkbenchWindow(), this.getNestedEditorSite(), this, null, 3));
        this.serviceLocator.registerService(IMultiPageEditorSiteHolder.class, () -> this);
        this.context.set(IContextService.class.getName(), (Object)new ContextFunction(){

            public Object compute(IEclipseContext ctxt, String contextKey) {
                if (MultiPageEditorSite.this.contextService == null) {
                    MultiPageEditorSite.this.contextService = new NestableContextService((IContextService)ctxt.getParent().get(IContextService.class), new ActivePartExpression(MultiPageEditorSite.this.multiPageEditor));
                }
                return MultiPageEditorSite.this.contextService;
            }
        });
        LegacyHandlerService handlerService = new LegacyHandlerService(this.context);
        this.context.set(IHandlerService.class, (Object)handlerService);
    }

    @Override
    public final void activate() {
        this.active = true;
        if (Policy.DEBUG_CONTEXTS) {
            Activator.trace((String)"/trace/eclipse.context", (String)("Activating " + this), null);
        }
        this.context.activate();
        this.serviceLocator.activate();
        if (this.contextService != null) {
            this.contextService.activate();
        }
    }

    @Override
    public final void deactivate() {
        this.active = false;
        if (Policy.DEBUG_CONTEXTS) {
            Activator.trace((String)"/trace/eclipse.context", (String)("Deactivating " + this), null);
        }
        if (this.contextService != null) {
            this.contextService.deactivate();
        }
        this.serviceLocator.deactivate();
        this.context.deactivate();
    }

    public void dispose() {
        if (Policy.DEBUG_CONTEXTS) {
            Activator.trace((String)"/trace/eclipse.context", (String)("Disposing " + this), null);
        }
        if (this.menuExtenders != null) {
            for (Object menuExtender : this.menuExtenders) {
                ((PopupMenuExtender)menuExtender).dispose();
            }
            this.menuExtenders = null;
        }
        if (this.service != null) {
            IKeyBindingService parentService = this.getMultiPageEditor().getEditorSite().getKeyBindingService();
            if (parentService instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableParent = (INestableKeyBindingService)parentService;
                nestableParent.removeKeyBindingService(this);
            }
            if (this.service instanceof KeyBindingService) {
                ((KeyBindingService)this.service).dispose();
            }
            this.service = null;
        }
        if (this.contextService != null) {
            this.contextService.dispose();
        }
        if (this.serviceLocator != null) {
            this.serviceLocator.dispose();
        }
        this.context.dispose();
    }

    @Override
    public IEditorActionBarContributor getActionBarContributor() {
        return null;
    }

    @Override
    public IActionBars getActionBars() {
        return this.multiPageEditor.getEditorSite().getActionBars();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Deprecated
    public ILabelDecorator getDecoratorManager() {
        return this.getWorkbenchWindow().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public IEditorPart getEditor() {
        return this.editor;
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public IKeyBindingService getKeyBindingService() {
        if (this.service == null) {
            this.service = this.getMultiPageEditor().getEditorSite().getKeyBindingService();
            if (this.service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)this.service;
                this.service = nestableService.getKeyBindingService(this);
            } else {
                WorkbenchPlugin.log("MultiPageEditorSite.getKeyBindingService()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + this.service.getClass().getName() + " instead.");
            }
        }
        return this.service;
    }

    public MultiPageEditorPart getMultiPageEditor() {
        return this.multiPageEditor;
    }

    @Override
    public IWorkbenchPage getPage() {
        return this.getNestedEditorSite().getPage();
    }

    @Override
    public IWorkbenchPart getPart() {
        return this.editor;
    }

    @Override
    public String getPluginId() {
        return "";
    }

    private ISelectionChangedListener getPostSelectionChangedListener() {
        if (this.postSelectionChangedListener == null) {
            this.postSelectionChangedListener = event -> this.handlePostSelectionChanged(event);
        }
        return this.postSelectionChangedListener;
    }

    @Override
    public String getRegisteredName() {
        return "";
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = event -> this.handleSelectionChanged(event);
        }
        return this.selectionChangedListener;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    @Override
    public final <T> T getService(Class<T> key) {
        T service = this.serviceLocator.getService(key);
        if (this.active && service instanceof INestable) {
            ((INestable)service).activate();
        }
        return service;
    }

    @Override
    public Shell getShell() {
        return this.getNestedEditorSite().getShell();
    }

    @Override
    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getNestedEditorSite().getWorkbenchWindow();
    }

    protected IWorkbenchPartSite getNestedEditorSite() {
        return this.getMultiPageEditor().getSite();
    }

    protected void handlePostSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getNestedEditorSite().getSelectionProvider();
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
            prov.firePostSelectionChanged(newEvent);
        }
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider = this.getNestedEditorSite().getSelectionProvider();
        if (parentProvider instanceof MultiPageSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            MultiPageSelectionProvider prov = (MultiPageSelectionProvider)parentProvider;
            prov.fireSelectionChanged(newEvent);
        }
    }

    public final boolean hasService(Class key) {
        return this.serviceLocator.hasService(key);
    }

    @Override
    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
        this.getNestedEditorSite().registerContextMenu(menuManager, selProvider);
    }

    @Override
    public final void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        this.registerContextMenu(this.getId(), menuManager, selectionProvider, includeEditorInput);
    }

    @Override
    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(menuID, menuMgr, selProvider, true, this.editor, this.context, this.menuExtenders);
    }

    @Override
    public final void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
        if (this.menuExtenders == null) {
            this.menuExtenders = new ArrayList(1);
        }
        PartSite.registerContextMenu(menuId, menuManager, selectionProvider, includeEditorInput, this.editor, this.context, this.menuExtenders);
    }

    @Override
    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this.selectionProvider;
        this.selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
            if (oldSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)oldSelectionProvider).removePostSelectionChangedListener(this.getPostSelectionChangedListener());
            } else {
                oldSelectionProvider.removeSelectionChangedListener(this.getPostSelectionChangedListener());
            }
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
            if (this.selectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.selectionProvider).addPostSelectionChangedListener(this.getPostSelectionChangedListener());
            } else {
                this.selectionProvider.addSelectionChangedListener(this.getPostSelectionChangedListener());
            }
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.context);
        builder.append(", active=");
        builder.append(this.active);
        return builder.toString();
    }
}

