/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.util.IClassFileReader;
import org.eclipse.jdt.core.util.IFieldInfo;
import org.eclipse.jdt.core.util.IInnerClassesAttribute;
import org.eclipse.jdt.core.util.IInnerClassesAttributeEntry;
import org.eclipse.jdt.core.util.IMethodInfo;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.fix.AbstractSerialVersionOperationCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionHashOperationDisplayCore;

public final class SerialVersionHashOperationCore
extends AbstractSerialVersionOperationCore {
    private static final String STATIC_CLASS_INITIALIZER = "<clinit>";
    private final ICompilationUnit fCompilationUnit;
    private final SerialVersionHashOperationDisplayCore fDisplay;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long calculateSerialVersionId(ITypeBinding typeBinding, IProgressMonitor monitor) throws CoreException, IOException {
        try {
            InputStream contents;
            block13: {
                IFile classfileResource = SerialVersionHashOperationCore.getClassfile(typeBinding);
                if (classfileResource == null) {
                    return null;
                }
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    Long l;
                    contents = classfileResource.getContents();
                    try {
                        IClassFileReader cfReader = ToolFactory.createDefaultClassFileReader((InputStream)contents, (int)65535);
                        if (cfReader == null) break block13;
                        l = SerialVersionHashOperationCore.calculateSerialVersionId(cfReader);
                        if (contents == null) return l;
                    }
                    catch (Throwable throwable2) {
                        if (contents == null) throw throwable2;
                        contents.close();
                        throw throwable2;
                    }
                    contents.close();
                    return l;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            if (contents == null) return null;
            contents.close();
            return null;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private static String getClassName(char[] name) {
        return new String(name).replace('/', '.');
    }

    private static Long calculateSerialVersionId(IClassFileReader cfReader) throws IOException {
        int flags;
        char[] curr;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream doos = new DataOutputStream(os);
        doos.writeUTF(SerialVersionHashOperationCore.getClassName(cfReader.getClassName()));
        int mod = SerialVersionHashOperationCore.getClassModifiers(cfReader);
        int classModifiers = mod & 0x611;
        doos.writeInt(classModifiers);
        Object object = SerialVersionHashOperationCore.getSortedInterfacesNames(cfReader);
        int n = ((char[][])object).length;
        int n2 = 0;
        while (n2 < n) {
            char[] interface1 = object[n2];
            doos.writeUTF(SerialVersionHashOperationCore.getClassName(interface1));
            ++n2;
        }
        IFieldInfo[] iFieldInfoArray = SerialVersionHashOperationCore.getSortedFields(cfReader);
        object = iFieldInfoArray;
        n = iFieldInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            curr = object[n2];
            flags = curr.getAccessFlags();
            if (!Flags.isPrivate((int)flags) || !Flags.isStatic((int)flags) && !Flags.isTransient((int)flags)) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xDF);
                doos.writeUTF(new String(curr.getDescriptor()));
            }
            ++n2;
        }
        if (SerialVersionHashOperationCore.hasStaticClassInitializer(cfReader)) {
            doos.writeUTF(STATIC_CLASS_INITIALIZER);
            doos.writeInt(8);
            doos.writeUTF("()V");
        }
        IMethodInfo[] iMethodInfoArray = SerialVersionHashOperationCore.getSortedMethods(cfReader);
        object = iMethodInfoArray;
        n = iMethodInfoArray.length;
        n2 = 0;
        while (n2 < n) {
            curr = object[n2];
            flags = curr.getAccessFlags();
            if (!Flags.isPrivate((int)flags) && !curr.isClinit()) {
                doos.writeUTF(new String(curr.getName()));
                doos.writeInt(flags & 0xD3F);
                doos.writeUTF(SerialVersionHashOperationCore.getClassName(curr.getDescriptor()));
            }
            ++n2;
        }
        doos.flush();
        return SerialVersionHashOperationCore.computeHash(os.toByteArray());
    }

    private static int getClassModifiers(IClassFileReader cfReader) {
        IInnerClassesAttribute innerClassesAttribute = cfReader.getInnerClassesAttribute();
        if (innerClassesAttribute != null) {
            IInnerClassesAttributeEntry[] iInnerClassesAttributeEntryArray = innerClassesAttribute.getInnerClassAttributesEntries();
            int n = iInnerClassesAttributeEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IInnerClassesAttributeEntry entry = iInnerClassesAttributeEntryArray[n2];
                char[] innerClassName = entry.getInnerClassName();
                if (innerClassName != null && CharOperation.equals((char[])cfReader.getClassName(), (char[])innerClassName)) {
                    return entry.getAccessFlags();
                }
                ++n2;
            }
        }
        return cfReader.getAccessFlags();
    }

    private static Long computeHash(byte[] bytes) {
        try {
            byte[] sha = MessageDigest.getInstance("SHA-1").digest(bytes);
            if (sha.length >= 8) {
                long hash = 0L;
                int i = 7;
                while (i >= 0) {
                    hash = hash << 8 | (long)(sha[i] & 0xFF);
                    --i;
                }
                return hash;
            }
        }
        catch (NoSuchAlgorithmException e) {
            JavaManipulationPlugin.log(e);
        }
        return null;
    }

    private static char[][] getSortedInterfacesNames(IClassFileReader cfReader) {
        char[][] interfaceNames = cfReader.getInterfaceNames();
        Arrays.sort(interfaceNames, CharOperation::compareTo);
        return interfaceNames;
    }

    private static IFieldInfo[] getSortedFields(IClassFileReader cfReader) {
        IFieldInfo[] allFields = cfReader.getFieldInfos();
        Arrays.sort(allFields, (o1, o2) -> CharOperation.compareTo((char[])o1.getName(), (char[])o2.getName()));
        return allFields;
    }

    private static boolean hasStaticClassInitializer(IClassFileReader cfReader) {
        IMethodInfo[] iMethodInfoArray = cfReader.getMethodInfos();
        int n = iMethodInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodInfo methodInfo = iMethodInfoArray[n2];
            if (methodInfo.isClinit()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IMethodInfo[] getSortedMethods(IClassFileReader cfReader) {
        IMethodInfo[] allMethods = cfReader.getMethodInfos();
        Arrays.sort(allMethods, (mi1, mi2) -> {
            if (mi1.isConstructor() != mi2.isConstructor()) {
                return mi1.isConstructor() ? -1 : 1;
            }
            if (mi1.isConstructor()) {
                return 0;
            }
            int res = CharOperation.compareTo((char[])mi1.getName(), (char[])mi2.getName());
            if (res != 0) {
                return res;
            }
            return CharOperation.compareTo((char[])mi1.getDescriptor(), (char[])mi2.getDescriptor());
        });
        return allMethods;
    }

    private static IFile getClassfile(ITypeBinding typeBinding) throws CoreException {
        IType type = (IType)typeBinding.getJavaElement();
        if (type == null || type.getCompilationUnit() == null) {
            return null;
        }
        IRegion region = JavaCore.newRegion();
        region.add((IJavaElement)type.getCompilationUnit());
        String name = typeBinding.getBinaryName();
        if (name != null) {
            int packStart = name.lastIndexOf(46);
            if (packStart != -1) {
                name = name.substring(packStart + 1);
            }
        } else {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core.manipulation", CorrectionMessages.SerialVersionHashOperation_error_classnotfound));
        }
        name = String.valueOf(name) + ".class";
        IResource[] iResourceArray = JavaCore.getGeneratedResources((IRegion)region, (boolean)false);
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.getType() == 1 && resource.getName().equals(name)) {
                return (IFile)resource;
            }
            ++n2;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core.manipulation", CorrectionMessages.SerialVersionHashOperation_error_classnotfound));
    }

    private void displayErrorMessage(String message) {
        this.fDisplay.displayErrorMessage(message);
    }

    private void displayErrorMessage(Throwable throwable) {
        this.displayErrorMessage(throwable.getLocalizedMessage());
    }

    private boolean displayYesNoMessage(String title, String message) {
        return this.fDisplay.displayYesNoMessage(title, message);
    }

    public SerialVersionHashOperationCore(ICompilationUnit unit, ASTNode[] nodes) {
        this(unit, nodes, new SerialVersionHashOperationDisplayCore());
    }

    public SerialVersionHashOperationCore(ICompilationUnit unit, ASTNode[] nodes, SerialVersionHashOperationDisplayCore display) {
        super(unit, nodes);
        this.fCompilationUnit = unit;
        this.fDisplay = display;
    }

    @Override
    protected boolean addInitializer(VariableDeclarationFragment fragment, ASTNode declarationNode) {
        Assert.isNotNull((Object)fragment);
        try {
            String id = this.computeId(declarationNode, (IProgressMonitor)new NullProgressMonitor());
            fragment.setInitializer((Expression)fragment.getAST().newNumberLiteral(id));
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    @Override
    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModelCore positionGroups) {
    }

    private String computeId(ASTNode declarationNode, IProgressMonitor monitor) throws InterruptedException {
        long serialVersionID;
        block17: {
            Assert.isNotNull((Object)monitor);
            serialVersionID = 1L;
            try {
                Long id;
                monitor.beginTask(CorrectionMessages.SerialVersionHashOperation_computing_id, 200);
                IJavaProject project = this.fCompilationUnit.getJavaProject();
                IPath path = this.fCompilationUnit.getResource().getFullPath();
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                try {
                    bufferManager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ITextFileBuffer buffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                    if (buffer.isDirty() && buffer.isStateValidated() && buffer.isCommitable() && this.displayYesNoMessage(CorrectionMessages.SerialVersionHashOperation_save_caption, CorrectionMessages.SerialVersionHashOperation_save_message)) {
                        buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 20), true);
                    } else {
                        monitor.worked(20);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    bufferManager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                }
                project.getProject().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ITypeBinding typeBinding = SerialVersionHashOperationCore.getTypeBinding(declarationNode);
                if (typeBinding != null && (id = SerialVersionHashOperationCore.calculateSerialVersionId(typeBinding, (IProgressMonitor)new SubProgressMonitor(monitor, 100))) != null) {
                    serialVersionID = id;
                }
            }
            catch (CoreException exception) {
                this.displayErrorMessage(exception);
                monitor.done();
                break block17;
            }
            catch (IOException exception) {
                try {
                    this.displayErrorMessage(exception);
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    monitor.done();
                }
            }
            monitor.done();
        }
        return String.valueOf(serialVersionID) + "L";
    }

    private static ITypeBinding getTypeBinding(ASTNode parent) {
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration declaration = (AnonymousClassDeclaration)parent;
            return declaration.resolveBinding();
        }
        if (parent instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parent;
            return type.resolveBinding();
        }
        return null;
    }
}

