/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.monitors;

import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementContentProvider;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.ui.monitors.ContendedMonitorContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaContendedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwnedMonitor;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaOwningThread;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaThreadContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.JavaWaitingThread;
import org.eclipse.jdt.internal.debug.ui.monitors.OwnedMonitorContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.OwningThreadContentProvider;
import org.eclipse.jdt.internal.debug.ui.monitors.WaitingThreadContentProvider;
import org.eclipse.jdt.internal.debug.ui.variables.JavaStackFrameContentProvider;

public class MonitorsAdapterFactory
implements IAdapterFactory {
    private static IElementContentProvider fgCPThread;
    private static IElementContentProvider fgCPFrame;
    private static IElementContentProvider fgCPOwnedMonitor;
    private static IElementContentProvider fgCPWaitingThread;
    private static IElementContentProvider fgCPContendedMonitor;
    private static IElementContentProvider fgCPOwningThread;

    static {
        fgCPFrame = new JavaStackFrameContentProvider();
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (IElementContentProvider.class.equals(adapterType)) {
            if (adaptableObject instanceof IJavaThread) {
                return (T)this.getThreadPresentation();
            }
            if (adaptableObject instanceof IJavaStackFrame) {
                return (T)fgCPFrame;
            }
            if (adaptableObject instanceof JavaOwnedMonitor) {
                return (T)this.getOwnedMonitorContentProvider();
            }
            if (adaptableObject instanceof JavaWaitingThread) {
                return (T)this.getWaitingThreadContentProvider();
            }
            if (adaptableObject instanceof JavaContendedMonitor) {
                return (T)this.getContendedMonitorContentProvider();
            }
            if (adaptableObject instanceof JavaOwningThread) {
                return (T)this.getOwningThreadContentProvider();
            }
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{IElementContentProvider.class};
    }

    private IElementContentProvider getThreadPresentation() {
        if (fgCPThread == null) {
            fgCPThread = new JavaThreadContentProvider();
        }
        return fgCPThread;
    }

    private IElementContentProvider getOwnedMonitorContentProvider() {
        if (fgCPOwnedMonitor == null) {
            fgCPOwnedMonitor = new OwnedMonitorContentProvider();
        }
        return fgCPOwnedMonitor;
    }

    private IElementContentProvider getWaitingThreadContentProvider() {
        if (fgCPWaitingThread == null) {
            fgCPWaitingThread = new WaitingThreadContentProvider();
        }
        return fgCPWaitingThread;
    }

    private IElementContentProvider getContendedMonitorContentProvider() {
        if (fgCPContendedMonitor == null) {
            fgCPContendedMonitor = new ContendedMonitorContentProvider();
        }
        return fgCPContendedMonitor;
    }

    private IElementContentProvider getOwningThreadContentProvider() {
        if (fgCPOwningThread == null) {
            fgCPOwningThread = new OwningThreadContentProvider();
        }
        return fgCPOwningThread;
    }
}

