/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.reddeer.codegen.builder.ClassBuilder;
import org.eclipse.reddeer.codegen.wizards.FirstPage;
import org.eclipse.reddeer.codegen.wizards.MethodsPage;
import org.eclipse.reddeer.codegen.wizards.PreviewPage;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CodeGenWizard
extends NewElementWizard
implements INewWizard {
    public static final String WIZZARD_NAME = "RedDeer CodeGen";
    private final Logger log = Logger.getLogger(CodeGenWizard.class);
    private static final String JAVA_SUFFIX = ".java";
    private FirstPage firstPage;
    private MethodsPage methodsPage;
    private PreviewPage previewPage;
    private ISelection selection;
    private ClassBuilder classBuilder;
    private boolean ans = false;

    public CodeGenWizard() {
        this.setWindowTitle(WIZZARD_NAME);
        this.setNeedsProgressMonitor(true);
        this.classBuilder = new ClassBuilder();
    }

    public void addPages() {
        this.methodsPage = new MethodsPage(this.selection, this.classBuilder);
        this.firstPage = new FirstPage(this.selection, this.methodsPage);
        this.previewPage = new PreviewPage(this.selection);
        this.firstPage.init(this.getSelection());
        this.addPage((IWizardPage)this.firstPage);
        this.addPage((IWizardPage)this.methodsPage);
        this.addPage((IWizardPage)this.previewPage);
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() instanceof PreviewPage;
    }

    public boolean performFinish() {
        this.log.info("Trying finish after pressing 'Finish button'.");
        final String srcText = this.firstPage.getPackageFragmentRootText();
        final String packageName = this.firstPage.getPackageText();
        final String fileName = this.firstPage.getTypeName();
        final ByteArrayInputStream stream = new ByteArrayInputStream(this.previewPage.getAreaTXT().getBytes());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        CodeGenWizard.this.doFinish(String.valueOf(srcText) + "/" + packageName.replaceAll("\\.", "/"), CodeGenWizard.this.getFileName(fileName), stream, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getMessage());
            return false;
        }
        return this.ans;
    }

    private void doFinish(String containerName, String fileName, final InputStream stream, final IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Creating " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (resource == null) {
            resource = this.firstPage.getPackageFragmentRoot().createPackageFragment(this.firstPage.getPackageText(), true, monitor).getResource();
        }
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Container \"" + containerName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            if (file.exists()) {
                Display.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CodeGenWizard.this.ans = MessageDialog.openQuestion((Shell)CodeGenWizard.this.getShell(), (String)"Warning dialog", (String)"This class already exists, overwrite ?");
                        if (CodeGenWizard.this.ans) {
                            try {
                                file.setContents(stream, true, true, monitor);
                            }
                            catch (CoreException e) {
                                Throwable realException = e.getCause();
                                MessageDialog.openError((Shell)CodeGenWizard.this.getShell(), (String)"Error", (String)realException.getMessage());
                                return;
                            }
                        } else {
                            return;
                        }
                    }
                });
            } else {
                this.ans = true;
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName("Opening file for editing...");
        Display.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.reddeer.codegen", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    private String getFileName(String name) {
        try {
            if (name.substring(name.lastIndexOf("."), name.length()).equals(JAVA_SUFFIX)) {
                return name;
            }
            return String.valueOf(name) + JAVA_SUFFIX;
        }
        catch (Exception exception) {
            return String.valueOf(name) + JAVA_SUFFIX;
        }
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.firstPage.createType(monitor);
    }

    public IJavaElement getCreatedElement() {
        return this.firstPage.getCreatedType();
    }
}

